/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.base.ch.ebanking.EBankingACLContributor;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.base.ch.ebanking.esr.ESRFile;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.ESRRecordDialog;
import ch.elexis.base.ch.ebanking.esr.ESRSelectionListener;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.AbstractDataLoaderJob;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.LazyContentProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESRView
extends ViewPart
implements IActivationListener {
    CommonViewer cv;
    ViewerConfigurer vc;
    ESRLoader esrloader;
    Query<ESRRecord> qbe;
    private Action loadESRFile;
    private ViewMenus menus;
    private ESRSelectionListener esrl;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TimeTool ttBooking = new TimeTool();
    private final ElexisEventListenerImpl eeli_user = new ElexisEventListenerImpl(Anwender.class, 64){

        public void catchElexisEvent(ElexisEvent ev) {
            JobPool.getJobPool().activate("ESR-Loader", 20);
        }
    };

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.cv = new CommonViewer();
        this.qbe = new Query(ESRRecord.class);
        this.esrloader = (ESRLoader)JobPool.getJobPool().getJob("ESR-Loader");
        if (this.esrloader == null) {
            this.esrloader = new ESRLoader(this.qbe);
            JobPool.getJobPool().addJob((BackgroundJob)this.esrloader);
        }
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new LazyContentProvider(this.cv, (AbstractDataLoaderJob)this.esrloader, EBankingACLContributor.DISPLAY_ESR), (LabelProvider)new ESRLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(this.cv, new String[]{"Datum"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, this.cv));
        this.cv.create(this.vc, parent, 0, (Object)this.getViewSite());
        JobPool.getJobPool().activate("ESR-Loader", 20);
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[]{this.loadESRFile});
        this.menus.createMenu(new IAction[]{this.loadESRFile});
        this.esrl = new ESRSelectionListener();
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ESRRecordDialog erd = new ESRRecordDialog(ESRView.this.getViewSite().getShell(), (ESRRecord)obj);
                if (erd.open() == 0) {
                    cv.notify(CommonViewer.Message.update);
                }
            }
        });
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.loadESRFile = new Action(Messages.ESRView_read_ESR){
            {
                this.setToolTipText(Messages.ESRView_read_ESR_explain);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                FileDialog fld = new FileDialog(ESRView.this.getViewSite().getShell(), 4096);
                fld.setText(Messages.ESRView_selectESR);
                String filename = fld.open();
                if (filename != null) {
                    final ESRFile esrf = new ESRFile();
                    final File file = new File(filename);
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.ESRView_reading_ESR, (int)(file.length() / 25L));
                                Result<List<ESRRecord>> result = esrf.read(file, monitor);
                                if (result.isOK()) {
                                    for (ESRRecord rec : (List)result.get()) {
                                        Money offen;
                                        Money zahlung;
                                        Rechnung rn;
                                        monitor.worked(1);
                                        if (!rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) continue;
                                        if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                                            ESRView.this.log.info(String.valueOf(Messages.ESRView_ESR_finished) + rec.getBetrag());
                                            continue;
                                        }
                                        if (rec.getTyp().equals((Object)ESRRecord.MODE.Storno_edv) || rec.getTyp().equals((Object)ESRRecord.MODE.Storno_Schalter)) {
                                            rn = rec.getRechnung();
                                            Zahlung zahlungsObj = rn.addZahlung(zahlung = rec.getBetrag().negate(), String.valueOf(Messages.ESRView_storno_for) + rn.getNr() + " / " + rec.getPatient().getPatCode(), new TimeTool(rec.getValuta()));
                                            if (zahlungsObj != null && ESR.getAccount() != null) {
                                                AccountTransaction transaction = zahlungsObj.getTransaction();
                                                transaction.setAccount(ESR.getAccount());
                                            }
                                            rec.setGebucht(null);
                                            continue;
                                        }
                                        rn = rec.getRechnung();
                                        if (rn.getStatus() == 16 && !SWTHelper.askYesNo((String)Messages.ESRView_paid, (String)(String.valueOf(Messages.ESRView_rechnung) + rn.getNr() + Messages.ESRView_ispaid)) || (zahlung = rec.getBetrag()).isMoreThan(offen = rn.getOffenerBetrag()) && !SWTHelper.askYesNo((String)Messages.ESRView_toohigh, (String)(String.valueOf(Messages.ESRView_paymentfor) + rn.getNr() + Messages.ESRView_morethan))) continue;
                                        ESRView.this.ttBooking.set(rec.getValuta());
                                        Zahlung zahlungsObj = rn.addZahlung(zahlung, String.valueOf(Messages.ESRView_vesrfor) + rn.getNr() + " / " + rec.getPatient().getPatCode(), ESRView.this.ttBooking);
                                        if (zahlungsObj != null && ESR.getAccount() != null) {
                                            AccountTransaction transaction = zahlungsObj.getTransaction();
                                            transaction.setAccount(ESR.getAccount());
                                        }
                                        rec.setGebucht(ESRView.this.ttBooking);
                                    }
                                    monitor.done();
                                } else {
                                    ResultAdapter.displayResult(result, (String)Messages.ESRView_errorESR);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        ExHandler.handle((Throwable)e);
                        SWTHelper.showError((String)Messages.ESRView_errorESR2, (String)Messages.ESRView_errrorESR2, (String)(String.valueOf(Messages.ESRView_couldnotread) + e.getMessage() + e.getCause().getMessage()));
                    }
                    catch (InterruptedException e) {
                        ExHandler.handle((Throwable)e);
                        SWTHelper.showError((String)"ESR interrupted", (String)Messages.ESRView_interrupted, (String)e.getMessage());
                    }
                }
                JobPool.getJobPool().activate("ESR-Loader", 20);
            }
        };
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_user, this.esrl});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_user, this.esrl});
        }
        this.esrl.activate(mode);
    }

    class ESRLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        DecimalFormat df = new DecimalFormat("###0.00");

        ESRLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ESRRecord) {
                ESRRecord rec = (ESRRecord)((Object)element);
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                    return "-- Datei eingelesen am: " + rec.get("Datum") + ", " + rec.getBetrag() + " --";
                }
                if (rec.getId().equals("1")) {
                    return Messages.ESRView_headline;
                }
                StringBuilder sb = new StringBuilder(100);
                Rechnung rn = rec.getRechnung();
                if (rn != null) {
                    sb.append(rn.getNr()).append(": ");
                }
                String betrag = rec.getBetrag().getAmountAsString();
                sb.append(rec.getEinlesedatatum()).append("/").append(rec.getVerarbeitungsdatum()).append("/").append(rec.getValuta()).append(" - ").append(rec.getPatient().getLabel()).append(" - ").append(betrag);
                String dat = rec.getGebucht();
                if (StringTool.isNothing((Object)dat)) {
                    sb.append(Messages.ESRView_not_booked);
                } else {
                    sb.append(Messages.ESRView_booked).append(new TimeTool(dat).toString(4));
                }
                return sb.toString();
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return UiDesk.getDisplay().getSystemColor(2);
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof ESRRecord) {
                ESRRecord rec = (ESRRecord)((Object)element);
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                    return UiDesk.getDisplay().getSystemColor(5);
                }
                String buch = rec.getGebucht();
                if (rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) {
                    if (StringTool.isNothing((Object)buch)) {
                        return UiDesk.getDisplay().getSystemColor(15);
                    }
                    return UiDesk.getDisplay().getSystemColor(1);
                }
                return UiDesk.getDisplay().getSystemColor(3);
            }
            return UiDesk.getDisplay().getSystemColor(10);
        }
    }

    class ESRLoader
    extends AbstractDataLoaderJob {
        Query<ESRRecord> qbe;

        ESRLoader(Query<ESRRecord> qbe) {
            super("ESR-Loader", qbe, new String[]{"Datum"});
            this.qbe = qbe;
        }

        public IStatus execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ESRView_loadESR, 2);
            this.qbe.clear();
            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                if (CoreHub.actMandant == null) {
                    return Status.CANCEL_STATUS;
                }
                this.qbe.startGroup();
                this.qbe.add("MandantID", "=", CoreHub.actMandant.getId());
                this.qbe.or();
                this.qbe.add("MandantID", "", null);
                this.qbe.add("RejectCode", "<>", "0");
                this.qbe.endGroup();
                this.qbe.and();
            }
            ESRView.this.vc.getControlFieldProvider().setQuery(this.qbe);
            this.qbe.orderBy(true, new String[]{"Datum", "Gebucht"});
            List list = this.qbe.execute();
            this.result = list.toArray();
            monitor.done();
            return Status.OK_STATUS;
        }

        public int getSize() {
            return PersistentObject.getConnection().queryInt("SELECT COUNT(0) FROM ESRRECORDS");
        }
    }
}

