/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ESRRecordDialog
extends TitleAreaDialog {
    private ESRRecord rec;
    private boolean bBooked;
    private Button bKeep;
    private Button bBook;
    private Button bUnbook;
    private Button bDelete;
    private Label lFile;
    private LabeledInputField.AutoForm af;
    private TimeTool ttBooking = new TimeTool();
    private LabeledInputField.InputData[] fields = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.ESRRecordDialog_readInDate, "Eingelesen", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_esrType, "ESRCode", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_bookedDate, "Verarbeitet", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_addedDate, "Gutgeschrieben", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_receivedDate, "Datum", LabeledInputField.InputData.Typ.DATE, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_amount, "BetragInRp", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(Messages.ESRRecordDialog_billNr, "RechnungsID", new LabeledInputField.IContentProvider(){

        public void displayContent(PersistentObject po, LabeledInputField.InputData ltf) {
            Rechnung rn = ESRRecordDialog.this.rec.getRechnung();
            if (rn == null) {
                ltf.setText("??");
            } else {
                ltf.setText(rn.getNr());
            }
        }

        public void reloadContent(PersistentObject po, LabeledInputField.InputData ltf) {
            InputDialog id = new InputDialog(ESRRecordDialog.this.getShell(), Messages.ESRRecordDialog_changeBillNr, Messages.ESRRecordDialog_pleaseEnterNewBilNr, ltf.getText(), null);
            if (id.open() == 0) {
                String rnid = new Query(Rechnung.class).findSingle("RnNummer", "=", id.getValue());
                int err = 0;
                if (rnid != null) {
                    Rechnung r = Rechnung.load((String)rnid);
                    if (r.isAvailable()) {
                        Fall fall = r.getFall();
                        if (fall.isAvailable()) {
                            Patient pat = fall.getPatient();
                            Mandant mn = r.getMandant();
                            if (pat.isAvailable()) {
                                ESRRecordDialog.this.rec.set("RechnungsID", r.getId());
                                ESRRecordDialog.this.rec.set("PatientID", pat.getId());
                                if (mn != null && mn.isValid()) {
                                    ESRRecordDialog.this.rec.set("MandantID", mn.getId());
                                }
                                ESRRecordDialog.this.af.reload((PersistentObject)ESRRecordDialog.this.rec);
                            } else {
                                err = 4;
                            }
                        } else {
                            err = 3;
                        }
                    } else {
                        err = 2;
                    }
                } else {
                    err = 1;
                }
                if (err != 0) {
                    SWTHelper.showError((String)Messages.ESRRecordDialog_billNotFound, (String)MessageFormat.format(Messages.ESRRecordDialog_noValidBillFound, id.getValue()));
                }
            }
        }
    }), new LabeledInputField.InputData(Messages.ESRRecordDialog_patient, "PatientID", new LabeledInputField.IContentProvider(){

        public void displayContent(PersistentObject po, LabeledInputField.InputData ltf) {
            ltf.setText(ESRRecordDialog.this.rec.getPatient().getLabel());
        }

        public void reloadContent(PersistentObject po, LabeledInputField.InputData ltf) {
            KontaktSelektor ksl = new KontaktSelektor(ESRRecordDialog.this.getShell(), Patient.class, Messages.ESRRecordDialog_selectPatient, Messages.ESRRecordDialog_pleaseSelectPatient, Patient.DEFAULT_SORT);
            if (ksl.open() == 0) {
                Patient actPatient = (Patient)ksl.getSelection();
                ESRRecordDialog.this.rec.set("PatientID", actPatient.getId());
                ltf.setText(actPatient.getLabel());
            }
        }
    })};

    public ESRRecordDialog(Shell shell, ESRRecord record) {
        super(shell);
        this.rec = record;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        TableWrapLayout twl = new TableWrapLayout();
        ret.setLayout((Layout)twl);
        this.af = new LabeledInputField.AutoForm(ret, this.fields);
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.af.setLayoutData((Object)twd);
        this.lFile = new Label(ret, 0);
        this.lFile.setText(String.valueOf(Messages.ESRRecordDialog_file) + this.rec.getFile());
        TableWrapData tw3 = new TableWrapData();
        tw3.grabHorizontal = true;
        this.lFile.setLayoutData((Object)tw3);
        Composite cChoices = new Composite(ret, 2048);
        TableWrapData tw2 = new TableWrapData();
        tw2.grabHorizontal = true;
        cChoices.setLayoutData((Object)tw2);
        RowLayout rl = new RowLayout(512);
        rl.fill = true;
        cChoices.setLayout((Layout)rl);
        this.bKeep = new Button(cChoices, 16);
        this.bKeep.setText(Messages.ESRRecordDialog_dontchange);
        this.bBook = new Button(cChoices, 16);
        this.bBook.setText(Messages.ESRRecordDialog_bookRecord);
        this.bUnbook = new Button(cChoices, 16);
        this.bUnbook.setText(Messages.ESRRecordDialog_dontBookRecord);
        this.bDelete = new Button(cChoices, 16);
        this.bDelete.setText(Messages.ESRRecordDialog_deleteRecord);
        this.bBooked = !StringTool.isNothing((Object)this.rec.getGebucht());
        this.bKeep.setSelection(true);
        this.af.reload((PersistentObject)this.rec);
        ret.pack();
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.ESRRecordDialog_editRecord);
        this.setMessage(Messages.ESRRecordDialog_warningEditing);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        this.getShell().setText(Messages.ESRRecordDialog_detailsForESRRecord);
    }

    protected void okPressed() {
        if (this.bBook.getSelection()) {
            if (!this.bBooked) {
                Money zahlung = this.rec.getBetrag();
                Rechnung rn = this.rec.getRechnung();
                this.ttBooking.set(this.rec.getValuta());
                Zahlung zahlungsObj = rn.addZahlung(zahlung, String.valueOf(Messages.ESRRecordDialog_vESRForBill) + rn.getNr() + " / " + this.rec.getPatient().getPatCode(), this.ttBooking);
                if (zahlungsObj != null && ESR.getAccount() != null) {
                    AccountTransaction transaction = zahlungsObj.getTransaction();
                    transaction.setAccount(ESR.getAccount());
                }
                this.rec.setGebucht(this.ttBooking);
            }
        } else if (this.bUnbook.getSelection()) {
            if (this.bBooked) {
                Money zahlung = this.rec.getBetrag();
                Rechnung rn = this.rec.getRechnung();
                Zahlung zahlungsObj = rn.addZahlung(zahlung.negate(), String.valueOf(Messages.ESRRecordDialog_stornoESR) + rn.getNr() + " / " + this.rec.getPatient().getPatCode(), null);
                if (zahlungsObj != null && ESR.getAccount() != null) {
                    AccountTransaction transaction = zahlungsObj.getTransaction();
                    transaction.setAccount(ESR.getAccount());
                }
                this.rec.set(Messages.ESRRecordDialog_booked, "");
            }
        } else if (this.bDelete.getSelection()) {
            this.rec.delete();
        }
        super.okPressed();
    }
}

