/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.command;

import ch.elexis.base.ch.ebanking.ESRView;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.base.ch.ebanking.esr.ESRFile;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadESRFileHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "ch.elexis.ebanking_ch.command.loadESRFile";
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        FileDialog fld = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
        fld.setText(Messages.ESRView_selectESR);
        String filename = fld.open();
        if (filename != null) {
            final ESRFile esrf = new ESRFile();
            final File file = new File(filename);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ESRView_reading_ESR, (int)(file.length() / 25L));
                        Result<List<ESRRecord>> result = esrf.read(file, monitor);
                        if (result.isOK()) {
                            for (ESRRecord rec : (List)result.get()) {
                                monitor.worked(1);
                                if (rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) {
                                    Money offen;
                                    Money zahlung;
                                    Rechnung rn;
                                    if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                                        LoadESRFileHandler.this.log.info(String.valueOf(Messages.ESRView_ESR_finished) + rec.getBetrag());
                                        continue;
                                    }
                                    if (rec.getTyp().equals((Object)ESRRecord.MODE.Storno_edv) || rec.getTyp().equals((Object)ESRRecord.MODE.Storno_Schalter)) {
                                        rn = rec.getRechnung();
                                        Zahlung zahlungsObj = rn.addZahlung(zahlung = rec.getBetrag().negate(), String.valueOf(Messages.ESRView_storno_for) + rn.getNr() + " / " + rec.getPatient().getPatCode(), new TimeTool(rec.getValuta()));
                                        if (zahlungsObj != null && ESR.getAccount() != null) {
                                            AccountTransaction transaction = zahlungsObj.getTransaction();
                                            transaction.setAccount(ESR.getAccount());
                                        }
                                        rec.setGebucht(null);
                                        continue;
                                    }
                                    rn = rec.getRechnung();
                                    if (rn.getStatus() == 16 && !SWTHelper.askYesNo((String)Messages.ESRView_paid, (String)(String.valueOf(Messages.ESRView_rechnung) + rn.getNr() + Messages.ESRView_ispaid)) || rn.getStatus() == 12 && !SWTHelper.askYesNo((String)Messages.ESRView_compulsoryExecution, (String)(String.valueOf(Messages.ESRView_rechnung) + rn.getNr() + Messages.ESRView_isInCompulsoryExecution)) || (zahlung = rec.getBetrag()).isMoreThan(offen = rn.getOffenerBetrag()) && !SWTHelper.askYesNo((String)Messages.ESRView_toohigh, (String)(String.valueOf(Messages.ESRView_paymentfor) + rn.getNr() + Messages.ESRView_morethan))) continue;
                                    Zahlung zahlungsObj = rn.addZahlung(zahlung, String.valueOf(Messages.ESRView_vesrfor) + rn.getNr() + " / " + rec.getPatient().getPatCode(), new TimeTool(rec.getValuta()));
                                    if (zahlungsObj != null && ESR.getAccount() != null) {
                                        AccountTransaction transaction = zahlungsObj.getTransaction();
                                        transaction.setAccount(ESR.getAccount());
                                    }
                                    rec.setGebucht(null);
                                    continue;
                                }
                                if (!rec.getRejectCode().equals((Object)ESRRecord.REJECT.RN_NUMMER)) continue;
                                TimeTool valutaDate = new TimeTool(rec.getValuta());
                                AccountTransaction transaction = new AccountTransaction(rec.getPatient(), null, rec.getBetrag(), valutaDate.toString(4), Messages.LoadESRFileHandler_notAssignable);
                                if (ESR.getAccount() == null) continue;
                                transaction.setAccount(ESR.getAccount());
                            }
                            monitor.done();
                            LoadESRFileHandler.this.updateEsrView(event);
                        } else {
                            ResultAdapter.displayResult(result, (String)Messages.ESRView_errorESR);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ExHandler.handle((Throwable)e);
                SWTHelper.showError((String)Messages.ESRView_errorESR2, (String)Messages.ESRView_errrorESR2, (String)(String.valueOf(Messages.ESRView_couldnotread) + e.getMessage() + e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ExHandler.handle((Throwable)e);
                SWTHelper.showError((String)"ESR interrupted", (String)Messages.ESRView_interrupted, (String)e.getMessage());
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setIcon(Images.IMG_IMPORT.getImageDescriptor());
        element.setTooltip(Messages.ESRView_read_ESR_explain);
    }

    private void updateEsrView(final ExecutionEvent event) {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ESRView view;
                IWorkbenchPage page;
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                if (window != null && (page = window.getActivePage()) != null && (view = (ESRView)page.findView("ch.elexis.ebanking_ch.ESRView")) != null) {
                    view.updateView();
                }
            }
        });
    }
}

