/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking;

import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ESRLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    DecimalFormat df = new DecimalFormat("###0.00");

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        ESRRecord rec = (ESRRecord)((Object)element);
        switch (columnIndex) {
            case 0: {
                text = rec.get("Datum");
                break;
            }
            case 1: {
                Rechnung rn = rec.getRechnung();
                if (rn == null) break;
                text = rn.getNr();
                break;
            }
            case 2: {
                text = rec.getBetrag().getAmountAsString();
                break;
            }
            case 3: {
                text = rec.getEinlesedatatum();
                break;
            }
            case 4: {
                text = rec.getVerarbeitungsdatum();
                break;
            }
            case 5: {
                text = rec.getValuta();
                break;
            }
            case 6: {
                text = rec.getPatient().getLabel();
                break;
            }
            case 7: {
                String dat = rec.getGebucht();
                if (StringTool.isNothing((Object)dat)) {
                    text = Messages.ESRView2_notbooked;
                    break;
                }
                text = new TimeTool(dat).toString(4);
                break;
            }
            case 8: {
                text = rec.getFile();
            }
        }
        return text;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        ESRRecord rec = (ESRRecord)((Object)element);
        if (rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) {
            if (StringTool.isNothing((Object)rec.getGebucht())) {
                return UiDesk.getColor((String)"grau");
            }
            return UiDesk.getColor((String)"weiss");
        }
        return UiDesk.getColor((String)"rot");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

