/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.base.ch.ticode.TessinerCode;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.data.PersistentObject;
import java.util.Hashtable;
import java.util.List;

public class TICode
extends PersistentObject
implements ICodeElement,
IDiagnose {
    private static Hashtable<String, TICode> hash = new Hashtable();
    private String Text;

    TICode(String Code, String Text2) {
        super(Code);
        this.Text = Text2;
    }

    public String getText() {
        return this.Text;
    }

    public String getCode() {
        return this.getId();
    }

    public String getLabel() {
        return String.valueOf(this.getId()) + " " + this.Text;
    }

    public String getCodeSystemName() {
        return "TI-Code";
    }

    public static TICode load(String code) {
        return TICode.getFromCode(code);
    }

    public static TICode[] getRootNodes() {
        TICode[] ret = new TICode[TessinerCode.ticode.length];
        int i = 0;
        while (i < TessinerCode.ticode.length) {
            String[] line = TessinerCode.ticode[i];
            ret[i] = new TICode(line[0], line[1]);
            ++i;
        }
        return ret;
    }

    public static TICode getFromCode(String code) {
        TICode ret = hash.get(code);
        if (ret == null && !code.isEmpty()) {
            String chapter = code.substring(0, 1);
            int subch = 0;
            if (code.length() == 2) {
                subch = Integer.parseInt(code.substring(1));
            }
            int i = 0;
            while (i < TessinerCode.ticode.length) {
                if (TessinerCode.ticode[i][0].startsWith(chapter)) {
                    if (subch == 9) {
                        subch = TessinerCode.ticode[i].length - 2;
                        ret = new TICode(String.valueOf(chapter) + "9", TessinerCode.ticode[i][subch + 1]);
                    } else {
                        ret = new TICode(String.valueOf(chapter) + subch, TessinerCode.ticode[i][subch + 1]);
                    }
                    hash.put(code, ret);
                    return ret;
                }
                ++i;
            }
        }
        return ret;
    }

    public TICode getParent() {
        if (this.getId().length() == 1) {
            return null;
        }
        return TICode.getFromCode(this.getId().substring(0, 1));
    }

    public boolean hasChildren() {
        return this.getId().length() == 1;
    }

    public boolean exists() {
        return true;
    }

    public TICode[] getChildren() {
        if (this.getId().length() > 1) {
            return null;
        }
        String chapter = this.getId().substring(0, 1);
        int i = 0;
        while (i < TessinerCode.ticode.length) {
            if (TessinerCode.ticode[i][0].equals(chapter)) {
                TICode[] ret = new TICode[TessinerCode.ticode[i].length - 2];
                int j = 2;
                while (j < TessinerCode.ticode[i].length) {
                    String x = j == TessinerCode.ticode[i].length - 1 ? "9" : Integer.toString(j - 1);
                    ret[j - 2] = new TICode(String.valueOf(chapter) + x, TessinerCode.ticode[i][j]);
                    ++j;
                }
                return ret;
            }
            ++i;
        }
        return null;
    }

    protected String getTableName() {
        return "None";
    }

    public boolean isDragOK() {
        return !this.hasChildren();
    }

    TICode() {
    }

    public String getCodeSystemCode() {
        return "999";
    }

    public List<Object> getActions(Object kontext) {
        return null;
    }
}

