/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.base.ch.diagnosecodes_schweiz.Messages;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.ICD10;
import ch.rgw.tools.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class ICDImporter
extends ImporterPage {
    ImporterPage.DirectoryBasedImporter dbi;
    private Pattern pat_group;
    private static final String regex_group = "([A-Z][0-9][0-9]-[A-Z][0-9][0-9])(.+?):";
    static Log log = Log.get((String)"ICD Import");

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String in;
        monitor.beginTask(Messages.ICDImporter_icdImport, 15000);
        monitor.subTask(Messages.ICDImporter_createTable);
        ICD10.initialize();
        monitor.worked(500);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask(Messages.ICDImporter_readCodes);
        this.pat_group = Pattern.compile(regex_group, 2);
        File codes = new File(String.valueOf(this.results[0]) + File.separator + "codes.txt");
        InputStreamReader ir = new InputStreamReader((InputStream)new FileInputStream(codes), "iso-8859-1");
        BufferedReader br = new BufferedReader(ir);
        Hashtable<String, ICD10> chapters = new Hashtable<String, ICD10>();
        Hashtable<String, ICD10> groups = new Hashtable<String, ICD10>();
        Hashtable<String, ICD10> supercodes = new Hashtable<String, ICD10>();
        while ((in = br.readLine()) != null) {
            ICD10 node;
            ICD10 mygroup;
            String[] fields = in.split(";");
            String kap = fields[4];
            String group = fields[5];
            String supercode = fields[6];
            ICD10 kapitel = (ICD10)((Object)chapters.get(kap));
            if (kapitel == null) {
                kapitel = new ICD10("NIL", kap, "1;N;X;X;" + kap + ";" + kap + ";" + kap + ";" + kap + ";" + kap + ";" + kap + ";Kapitel " + kap + ";;;;;");
                chapters.put(kap, kapitel);
                LineFeeder lf = new LineFeeder(String.valueOf(this.results[0]) + File.separator + "KAP" + kap + ".asc");
                block7: while (lf.peek() == '0') {
                    String t = lf.nextLine();
                    switch (t.charAt(1)) {
                        case 'T': {
                            kapitel.set("Text", t.substring(2).replaceAll("\n", " - "));
                            break;
                        }
                        case 'I': {
                            kapitel.setExt("Incl:", t.substring(2));
                            break;
                        }
                        case 'E': {
                            kapitel.setExt("Excl:", t.substring(2));
                            break;
                        }
                        case 'G': {
                            String gruppen = t.substring(2).replaceAll("\n", "::");
                            kapitel.setExt("Gruppen", t.substring(2));
                            Matcher match = this.pat_group.matcher(String.valueOf(gruppen) + "::");
                            while (match.find()) {
                                String code = match.group(1);
                                String[] gs = code.split("-");
                                if (groups.get(gs[0]) != null) continue;
                                ICD10 Group2 = new ICD10(kapitel.getId(), code, "1;N;X;X;" + kap + ";" + code + ";" + gs[0] + ";" + gs[0] + ";" + code + ";" + code + ";" + match.group(2));
                                groups.put(gs[0], Group2);
                            }
                            continue block7;
                        }
                        default: {
                            kapitel.setExt("Zusatz", t.substring(2));
                        }
                    }
                }
            }
            if ((mygroup = (ICD10)((Object)groups.get(group))) == null) {
                node = new ICD10(kapitel.getId(), fields[7], in);
            } else if (fields[0].equals("3")) {
                node = new ICD10(mygroup.getId(), fields[7], in);
                supercodes.put(fields[7], node);
            } else {
                ICD10 icdSuper = (ICD10)((Object)supercodes.get(supercode));
                node = icdSuper == null ? new ICD10(mygroup.getId(), fields[7], in) : new ICD10(icdSuper.getId(), fields[7], in);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            node = null;
            kap = null;
        }
        ElexisEventDispatcher.reload(ICD10.class);
        return Status.OK_STATUS;
    }

    public String getTitle() {
        return "ICD-10";
    }

    public Composite createPage(Composite parent) {
        this.dbi = new ImporterPage.DirectoryBasedImporter(parent, (ImporterPage)this);
        this.dbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return this.dbi;
    }

    public String getDescription() {
        return Messages.ICDImporter_enterDirectory;
    }

    class LineFeeder {
        String prev;
        BufferedReader br;

        LineFeeder(String fname) throws Exception {
            this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fname), "iso-8859-1"));
            this.prev = this.br.readLine();
        }

        char peek() {
            return this.prev.charAt(0);
        }

        /*
         * Unable to fully structure code
         */
        String nextLine() throws Exception {
            if (this.prev == null) {
                return null;
            }
            ret = this.prev;
            this.prev = this.br.readLine();
            if (this.prev != null) ** GOTO lbl13
            this.br.close();
            return ret;
lbl-1000:
            // 1 sources

            {
                ret = String.valueOf(ret) + "\n" + this.prev.trim();
                this.prev = this.br.readLine();
                if (this.prev != null) continue;
                this.br.close();
                return ret;
lbl13:
                // 2 sources

                ** while (this.prev.startsWith((String)" ") || this.prev.startsWith((String)"P"))
            }
lbl14:
            // 1 sources

            if (!this.prev.substring(0, 2).equals(ret.substring(0, 2))) ** GOTO lbl21
            ret = String.valueOf(ret) + "\n" + this.nextLine().substring(2);
            return ret;
lbl-1000:
            // 1 sources

            {
                this.prev = this.br.readLine();
                if (this.prev != null) continue;
                this.br.close();
                break;
lbl21:
                // 2 sources

                ** while (this.prev.startsWith((String)"LZ"))
            }
lbl22:
            // 2 sources

            return ret;
        }

        boolean atEOF() {
            return this.prev == null;
        }

        public void close() throws Exception {
            this.br.close();
        }
    }
}

