/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.model.IDiagnose;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.util.List;
import java.util.Map;

public class ICD10
extends PersistentObject
implements IDiagnose {
    public static final String CODESYSTEM_NAME = "ICD-10";
    public static final String VERSION = "1.0.2";
    public static final String TABLENAME = "ICD10";
    public static final String FLD_CODE = "Code";
    public static final String FLD_TEXT = "Text";
    static final String drop = "DROP INDEX icd1;DROP INDEX icd2;DROP TABLE ICD10;";
    static final String create;
    static final int LEVEL = 0;
    static final int TERMINAL = 1;
    static final int GENERATED = 2;
    static final int KIND = 3;
    static final int CHAPTER = 4;
    static final int GROUP = 5;
    static final int SUPERCODE = 6;
    static final int CODE = 7;
    static final int CODE_SHORT = 8;
    static final int CODE_COMPACT = 9;
    static final int TEXT = 10;

    static {
        VersionInfo vi;
        ICD10 check;
        create = "CREATE TABLE ICD10 (ID       VARCHAR(25) primary key, lastupdate BIGINT,deleted  CHAR(1) default '0',parent   VARCHAR(25),ICDCode  VARCHAR(10),encoded  TEXT,ICDTxt   TEXT,ExtInfo  BLOB);CREATE INDEX icd1 ON ICD10 (parent);CREATE INDEX icd2 ON ICD10 (ICDCode);INSERT INTO ICD10 (ID,ICDTxt) VALUES ('1'," + JdbcLink.wrap((String)VERSION) + ");";
        ICD10.addMapping((String)TABLENAME, (String[])new String[]{"parent", "Code=ICDCode", "Text=ICDTxt", "encoded", "ExtInfo"});
        if (!PersistentObject.tableExists((String)TABLENAME)) {
            ICD10.initialize();
        }
        if ((check = ICD10.load("1")).exists() && (vi = new VersionInfo(check.get(FLD_TEXT))).isOlder(VERSION)) {
            if (vi.isOlder("1.0.1")) {
                ICD10.getConnection().exec("ALTER TABLE ICD10 ADD deleted CHAR(1) default '0';");
                check.set(FLD_TEXT, VERSION);
            }
            if (vi.isOlder(VERSION)) {
                ICD10.getConnection().exec("ALTER TABLE ICD10 ADD lastupdate BIGINT;");
                check.set(FLD_TEXT, VERSION);
            }
        }
    }

    public static void initialize() {
        if (PersistentObject.tableExists((String)TABLENAME)) {
            ICD10.createOrModifyTable((String)drop);
        }
        ICD10.createOrModifyTable((String)create);
    }

    public static ICD10 load(String id) {
        String dbId;
        ICD10 ret = new ICD10(id);
        if (!ret.exists() && (dbId = new Query(ICD10.class).findSingle(FLD_CODE, "=", id)) != null) {
            ret = new ICD10(dbId);
        }
        return ret;
    }

    public ICD10(String parent, String code, String shortCode) {
        this.create(null);
        this.set(FLD_CODE, code);
        this.set("encoded", shortCode);
        this.set("parent", parent);
        this.set(FLD_TEXT, this.getField(10));
    }

    public String getEncoded() {
        return this.get("encoded");
    }

    public String getField(int f) {
        return this.getEncoded().split(";")[f];
    }

    public ICD10() {
    }

    protected ICD10(String id) {
        super(id);
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_CODE, FLD_TEXT});
        return String.valueOf(vals[0]) + " " + vals[1];
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCode() {
        return this.get(FLD_CODE);
    }

    public String getText() {
        return this.get(FLD_TEXT);
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public void setExt(String name, String value) {
        Map ext = this.getExtInfo();
        ext.put(name, value);
        this.writeExtInfo(ext);
    }

    public String getExt(String name) {
        Map ext = this.getExtInfo();
        String ret = (String)ext.get(name);
        return ICD10.checkNull((Object)ret);
    }

    public Map getExtInfo() {
        return this.getMap("ExtInfo");
    }

    public void writeExtInfo(Map ext) {
        this.setMap("ExtInfo", ext);
    }

    public boolean isDragOK() {
        return this.getField(1).equals("T");
    }

    public String getCodeSystemCode() {
        return "999";
    }

    public List<Object> getActions(Object kontext) {
        return null;
    }
}

