/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.views;

import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.TICode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TICodeSelectorFactory
extends CodeSelectorFactory {
    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        return new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new TICodeContentProvider(cv), (LabelProvider)new TICodeLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(cv, new String[]{"Text"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
    }

    public Class getElementClass() {
        return TICode.class;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "TI-Code";
    }

    static class TICodeContentProvider
    implements ITreeContentProvider,
    ViewerConfigurer.ICommonViewerContentProvider {
        private CommonViewer viewer;
        private String value;
        private String TICKey = "Text";
        private List<TICode> nodes;
        private List<TICode> childs;
        private List<TICode> allNodes;

        public TICodeContentProvider(CommonViewer viewer) {
            this.viewer = viewer;
            this.allNodes = new ArrayList<TICode>(Arrays.asList(TICode.getRootNodes()));
            this.nodes = this.allNodes;
            this.value = "";
        }

        public Object[] getChildren(Object parentElement) {
            TICode c = (TICode)((Object)parentElement);
            if (this.value == null || this.value.isEmpty()) {
                return c.getChildren();
            }
            ArrayList<TICode> availableChildren = new ArrayList<TICode>();
            TICode[] tICodeArray = c.getChildren();
            int n = tICodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TICode tic = tICodeArray[n2];
                if (this.childs.contains((Object)tic)) {
                    availableChildren.add(tic);
                }
                ++n2;
            }
            return availableChildren.toArray(new TICode[availableChildren.size()]);
        }

        public Object getParent(Object element) {
            TICode c = (TICode)((Object)element);
            return c.getParent();
        }

        public boolean hasChildren(Object element) {
            TICode c = (TICode)((Object)element);
            return c.hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.nodes.toArray(new TICode[this.nodes.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void startListening() {
            this.viewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public void stopListening() {
            this.viewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }

        public void changed(HashMap<String, String> values) {
            String filterText = values.get(this.TICKey).toLowerCase();
            if (filterText == null || filterText.isEmpty() || filterText.equals("%")) {
                this.nodes = this.allNodes;
                this.setFilterValue("");
            } else {
                List<Object> filteredTICodes = new ArrayList();
                boolean startMatchesOnly = true;
                if (filterText.startsWith("%")) {
                    filterText = filterText.replace("%", "");
                    startMatchesOnly = false;
                }
                this.setFilterValue(filterText);
                filteredTICodes = this.findMatchingTiCodes(filterText, startMatchesOnly);
                this.nodes = filteredTICodes;
            }
            this.viewer.notify(CommonViewer.Message.update);
        }

        private List<TICode> findMatchingTiCodes(String search, boolean startMatchesOnly) {
            this.childs = new ArrayList<TICode>();
            List<TICode> matches = new ArrayList<TICode>();
            for (TICode tiCode : this.allNodes) {
                String text = tiCode.getText().toLowerCase();
                if (this.isMatch(search, text, startMatchesOnly)) {
                    matches.add(tiCode);
                }
                matches = this.addMatchingChildren(search, startMatchesOnly, matches, tiCode.getChildren(), tiCode);
            }
            return matches;
        }

        private List<TICode> addMatchingChildren(String search, boolean startMatchesOnly, List<TICode> matches, TICode[] tiChildren, TICode parent) {
            TICode[] tICodeArray = tiChildren;
            int n = tiChildren.length;
            int n2 = 0;
            while (n2 < n) {
                TICode tic = tICodeArray[n2];
                String text = tic.getText().toLowerCase();
                if (this.isMatch(search, text, startMatchesOnly)) {
                    this.childs.add(tic);
                    if (!matches.contains((Object)parent)) {
                        matches.add(parent);
                    }
                }
                ++n2;
            }
            return matches;
        }

        private boolean isMatch(String search, String text, boolean startMatchesOnly) {
            if (startMatchesOnly) {
                return text.startsWith(search);
            }
            return text.contains(search);
        }

        public void reorder(String field) {
        }

        public void selected() {
        }

        public void init() {
        }

        private void setFilterValue(String value) {
            this.value = value;
        }
    }

    static class TICodeLabelProvider
    extends LabelProvider {
        TICodeLabelProvider() {
        }

        public String getText(Object element) {
            TICode c = (TICode)((Object)element);
            return String.valueOf(c.getCode()) + " " + c.getText();
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

