/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.views;

import ch.elexis.base.ch.diagnosecodes.views.ICD10LazyTreeLoader;
import ch.elexis.core.data.util.Messages;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.rgw.tools.Tree;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ICD10TreeContentProvider
implements ITreeContentProvider,
BackgroundJob.BackgroundJobListener,
ViewerConfigurer.ICommonViewerContentProvider {
    ICD10LazyTreeLoader job;
    CommonViewer viewer;

    public ICD10TreeContentProvider(CommonViewer v, ICD10LazyTreeLoader loader) {
        this.job = loader;
        this.viewer = v;
        if (JobPool.getJobPool().getJob(this.job.getJobname()) == null) {
            JobPool.getJobPool().addJob((BackgroundJob)this.job);
        }
        this.job.addListener(this);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Tree result = (Tree)this.job.getData();
        if (result == null) {
            JobPool.getJobPool().activate(this.job.getJobname(), 20);
            return new String[]{Messages.TreeContentProvider_loadData};
        }
        if (this.viewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            result.setFilter(null);
        } else {
            result.setFilter(((DefaultControlFieldProvider)this.viewer.getConfigurer().getControlFieldProvider()).createFilter());
        }
        Collection c = result.getChildren();
        return c.toArray();
    }

    public void startListening() {
        this.viewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void stopListening() {
        this.viewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void dispose() {
        this.job.removeListener(this);
    }

    public void inputChanged(Viewer pViewer, Object oldInput, Object newInput) {
    }

    public void jobFinished(BackgroundJob j) {
        this.viewer.notify(CommonViewer.Message.update);
    }

    public void changed(HashMap<String, String> vals) {
        this.job.setVals(vals);
        if (this.viewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.viewer.notify(CommonViewer.Message.empty);
        } else {
            this.viewer.notify(CommonViewer.Message.notempty);
        }
        this.job.invalidate();
        this.viewer.notify(CommonViewer.Message.update);
    }

    public void reorder(String field) {
        this.job.invalidate();
    }

    public void selected() {
    }

    public void init() {
    }
}

