/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.views.TarmedCodeSelectorContentProvider;
import ch.elexis.views.TarmedLawFilter;
import ch.elexis.views.TarmedValidDateFilter;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TarmedSelectorPanelProvider
extends SelectorPanelProvider {
    private CommonViewer commonViewer;
    private StructuredViewer viewer;
    private TarmedLawFilter lawFilter = new TarmedLawFilter();
    private TarmedValidDateFilter validDateFilter = new TarmedValidDateFilter();
    private FilterKonsultationListener konsFilter = new FilterKonsultationListener(Konsultation.class);
    private Konsultation previousKons;
    private Fall previousFall;
    private boolean dirty;

    public TarmedSelectorPanelProvider(CommonViewer cv, FieldDescriptor<? extends PersistentObject>[] fields, boolean bExlusive) {
        super(fields, bExlusive);
        this.commonViewer = cv;
    }

    public void setFocus() {
        super.setFocus();
        if (this.viewer == null) {
            Konsultation selectedKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            this.viewer = this.commonViewer.getViewerWidget();
            IContentProvider contentProvider = this.viewer.getContentProvider();
            if (contentProvider instanceof TarmedCodeSelectorContentProvider) {
                if (selectedKons != null) {
                    this.updateLawFilter(selectedKons);
                }
                this.viewer.addFilter((ViewerFilter)this.lawFilter);
            }
            if (selectedKons != null) {
                this.updateValidFilter(selectedKons);
            }
            this.viewer.addFilter((ViewerFilter)this.validDateFilter);
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.konsFilter});
        }
        this.refreshViewer();
    }

    private void refreshViewer() {
        if (this.viewer != null && this.dirty) {
            this.dirty = false;
            this.viewer.getControl().setRedraw(false);
            this.viewer.setSelection((ISelection)new StructuredSelection());
            this.viewer.refresh();
            this.viewer.getControl().setRedraw(true);
        }
    }

    private void updateValidFilter(Konsultation kons) {
        this.validDateFilter.setValidDate(new TimeTool(kons.getDatum()));
    }

    private void updateLawFilter(Konsultation kons) {
        String konsLaw;
        Fall fall = kons.getFall();
        String law = "";
        if (fall != null && TarmedLeistung.isAvailableLaw(konsLaw = fall.getConfiguredBillingSystemLaw().name())) {
            law = konsLaw;
        }
        this.lawFilter.setLaw(law);
    }

    private void updateDirty(Konsultation kons) {
        if (kons != this.previousKons) {
            this.dirty = true;
            this.previousKons = kons;
        }
        if (kons != null && kons.getFall() != this.previousFall) {
            this.dirty = true;
            this.previousFall = kons.getFall();
        }
    }

    public void toggleFilters() {
        this.validDateFilter.setDoFilter(!this.validDateFilter.getDoFilter());
        this.lawFilter.setDoFilter(!this.lawFilter.getDoFilter());
        this.dirty = true;
        this.refreshViewer();
    }

    private class FilterKonsultationListener
    extends ElexisUiEventListenerImpl {
        public FilterKonsultationListener(Class<?> clazz) {
            super(clazz, 20532);
        }

        public void runInUi(ElexisEvent ev) {
            Konsultation selectedKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (selectedKons != null) {
                IContentProvider contentProvider = TarmedSelectorPanelProvider.this.viewer.getContentProvider();
                if (contentProvider instanceof TarmedCodeSelectorContentProvider) {
                    TarmedSelectorPanelProvider.this.updateLawFilter(selectedKons);
                }
                TarmedSelectorPanelProvider.this.updateValidFilter(selectedKons);
                TarmedSelectorPanelProvider.this.updateDirty(selectedKons);
            } else {
                IContentProvider contentProvider = TarmedSelectorPanelProvider.this.viewer.getContentProvider();
                if (contentProvider instanceof TarmedCodeSelectorContentProvider) {
                    TarmedSelectorPanelProvider.this.lawFilter.setLaw(null);
                }
                TarmedSelectorPanelProvider.this.validDateFilter.setValidDate(null);
                TarmedSelectorPanelProvider.this.updateDirty(null);
            }
        }
    }
}

