/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.tools.TimeTool;
import java.util.Hashtable;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TarmedDetailDisplay
implements IDetailDisplay {
    private FormToolkit tk;
    private ScrolledForm form;
    private String[] fields = new String[]{Messages.TarmedDetailDisplay_DigniQuant, Messages.TarmedDetailDisplay_DigniQual, Messages.TarmedDetailDisplay_Sparte, Messages.TarmedDetailDisplay_RiskClass, Messages.TarmedDetailDisplay_TPDoc, Messages.TarmedDetailDisplay_TPTec, Messages.TarmedDetailDisplay_TPAss, Messages.TarmedDetailDisplay_NumbereAss, Messages.TarmedDetailDisplay_TimeAct, Messages.TarmedDetailDisplay_TimeBeforeAfter, Messages.TarmedDetailDisplay_TimeWrite, Messages.TarmedDetailDisplay_TimeChange, Messages.TarmedDetailDisplay_TimeRoom, Messages.TarmedDetailDisplay_Relation, Messages.TarmedDetailDisplay_NameInternal};
    private String[] retrieve = new String[]{"DigniQuanti", "DigniQuali", "Sparte", "Anaesthesie", "TP_AL", "TP_TL", "TP_ASSI", "ANZ_ASSI", "LSTGIMES_MIN", "VBNB_MIN", "BEFUND_MIN", "WECHSEL_MIN", "RAUM_MIN", "Bezug", "Nickname"};
    private Text[] inputs = new Text[this.fields.length];
    private FormText medinter;
    private FormText techinter;
    private FormText exclusion;
    private FormText inclusion;
    private FormText limits;
    private FormText hirarchy;
    private FormText validity;
    private TarmedLeistung actCode;

    public Composite createDisplay(Composite parent, IViewSite notUsed) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        LabeledInputField.Tableau cFields = new LabeledInputField.Tableau(this.form.getBody());
        int i = 0;
        while (i < this.fields.length) {
            this.inputs[i] = (Text)cFields.addComponent(this.fields[i]).getControl();
            ++i;
        }
        final int last = this.fields.length - 1;
        this.inputs[last].addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TarmedDetailDisplay.this.actCode != null) {
                    TarmedDetailDisplay.this.actCode.set("Nickname", TarmedDetailDisplay.this.inputs[last].getText());
                }
            }
        });
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        cFields.setLayoutData((Object)twd);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_MedInter);
        this.medinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_TecInter);
        this.techinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DontCombine);
        this.exclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DoCombine);
        this.inclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_PossibleAdd);
        this.hirarchy = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Limits);
        this.limits = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Validity);
        this.validity = this.tk.createFormText(this.form.getBody(), false);
        return this.form.getBody();
    }

    public Class getElementClass() {
        return TarmedLeistung.class;
    }

    public void display(Object obj) {
        if (obj instanceof TarmedLeistung) {
            String text;
            this.actCode = (TarmedLeistung)((Object)obj);
            this.form.setText(this.actCode.getLabel());
            Hashtable<String, String> ext = this.actCode.loadExtension();
            this.inputs[0].setText(this.actCode.getDigniQuantiAsText());
            this.inputs[1].setText(this.actCode.getDigniQualiAsText());
            this.inputs[2].setText(this.actCode.getSparteAsText());
            this.inputs[3].setText(TarmedLeistung.getTextForRisikoKlasse(ext.get("ANAESTHESIE")));
            int i = 4;
            while (i < this.fields.length - 1) {
                String val = ext.get(this.retrieve[i]);
                if (val == null) {
                    val = "";
                }
                this.inputs[i].setText(val);
                ++i;
            }
            this.inputs[this.fields.length - 1].setText(this.actCode.get("Nickname"));
            this.medinter.setText(this.actCode.getMedInterpretation(), false, false);
            this.techinter.setText(this.actCode.getTechInterpretation(), false, false);
            List<TarmedKumulation> kumulations = TarmedKumulation.getKumulations(this.actCode.getCode(), TarmedKumulation.TarmedKumulationType.SERVICE, this.actCode.getGueltigVon(), this.actCode.get("Law"));
            this.exclusion.setText(this.getKumulationsString(kumulations, this.actCode.getCode(), "E"), false, false);
            this.inclusion.setText(this.getKumulationsString(kumulations, this.actCode.getCode(), "I"), false, false);
            List<String> hirarchyCodes = this.actCode.getHierarchy(this.actCode.getGueltigVon());
            this.hirarchy.setText(String.join((CharSequence)", ", hirarchyCodes), false, false);
            String limit = ext.get("limits");
            if (limit != null) {
                String[] ll;
                StringBuilder sb = new StringBuilder();
                sb.append("<form>");
                String[] stringArray = ll = limit.split("#");
                int n = ll.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String[] f = line.split(",");
                    if (f.length == 6) {
                        sb.append("<li>");
                        if (f[0].equals("<=")) {
                            sb.append(Messages.TarmedDetailDisplay_max).append(" ");
                        } else {
                            sb.append(f[0]).append(" ");
                        }
                        sb.append(f[1]).append(Messages.TarmedDetailDisplay_times);
                        if (f[3].equals("P")) {
                            sb.append(Messages.TarmedDetailDisplay_per);
                        } else {
                            sb.append(Messages.TarmedDetailDisplay_after);
                        }
                        sb.append(f[2]).append(" ");
                        sb.append(TarmedLeistung.getTextForZR_Einheit(f[4]));
                        sb.append("</li>");
                    }
                    ++n2;
                }
                sb.append("</form>");
                this.limits.setText(sb.toString(), true, false);
            } else {
                this.limits.setText("", false, false);
            }
            TimeTool tGueltigVon = this.actCode.getGueltigVon();
            TimeTool tGueltigBis = this.actCode.getGueltigBis();
            if (tGueltigVon != null && tGueltigBis != null) {
                String from = tGueltigVon.toString(4);
                String to = tGueltigBis.isSameDay(TarmedLeistung.INFINITE) ? "" : tGueltigBis.toString(4);
                text = String.valueOf(from) + "-" + to;
            } else {
                text = "";
            }
            this.validity.setText(text, false, false);
            this.form.reflow(true);
        }
    }

    private String getKumulationsString(List<TarmedKumulation> list, String code, String typ) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            List slaveServices = list.stream().filter(k -> k.isTyp(typ) && k.isSlaveType(TarmedKumulation.TarmedKumulationType.SERVICE) && k.isSlaveCode(code) && k.isMasterType(TarmedKumulation.TarmedKumulationType.SERVICE)).collect(Collectors.toList());
            List masterServices = list.stream().filter(k -> k.isTyp(typ) && k.isMasterType(TarmedKumulation.TarmedKumulationType.SERVICE) && k.isMasterCode(code) && k.isSlaveType(TarmedKumulation.TarmedKumulationType.SERVICE)).collect(Collectors.toList());
            if (!slaveServices.isEmpty() || !masterServices.isEmpty()) {
                sb.append("Leistungen: ");
                StringJoiner sj = new StringJoiner(", ");
                for (TarmedKumulation tarmedKumulation : slaveServices) {
                    if (sj.toString().contains(tarmedKumulation.getMasterCode())) continue;
                    sj.add(tarmedKumulation.getMasterCode());
                }
                for (TarmedKumulation tarmedKumulation : masterServices) {
                    if (sj.toString().contains(tarmedKumulation.getSlaveCode())) continue;
                    sj.add(tarmedKumulation.getSlaveCode());
                }
                sb.append(sj.toString());
            }
            List slaveGroups = list.stream().filter(k -> k.isTyp(typ) && k.isSlaveType(TarmedKumulation.TarmedKumulationType.GROUP)).collect(Collectors.toList());
            List masterGroups = list.stream().filter(k -> k.isTyp(typ) && k.isMasterType(TarmedKumulation.TarmedKumulationType.GROUP)).collect(Collectors.toList());
            if (!slaveGroups.isEmpty() || !masterGroups.isEmpty()) {
                sb.append(" ");
                sb.append("Gruppen: ");
                StringJoiner sj = new StringJoiner(", ");
                for (TarmedKumulation tarmedKumulation : slaveGroups) {
                    if (sj.toString().contains(tarmedKumulation.getSlaveCode())) continue;
                    sj.add(tarmedKumulation.getSlaveCode());
                }
                for (TarmedKumulation tarmedKumulation : masterGroups) {
                    if (sj.toString().contains(tarmedKumulation.getMasterCode())) continue;
                    sj.add(tarmedKumulation.getMasterCode());
                }
                sb.append(sj.toString());
            }
        }
        return sb.toString();
    }

    public String getTitle() {
        return "Tarmed";
    }
}

