/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TarmedDetailDialog
extends Dialog {
    private Verrechnet verrechnet;
    private Combo cSide;
    private Button bPflicht;
    private ComboViewer cBezug;

    public TarmedDetailDialog(Shell shell, Verrechnet tl) {
        super(shell);
        this.verrechnet = tl;
    }

    protected Control createDialogArea(Composite parent) {
        String side;
        TarmedLeistung tl = (TarmedLeistung)this.verrechnet.getVerrechenbar();
        Composite ret = (Composite)super.createDialogArea(parent);
        ret.setLayout((Layout)new GridLayout(8, false));
        Label lTitle = new Label(ret, 64);
        lTitle.setText(tl.getText());
        lTitle.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)true));
        double primaryScale = this.verrechnet.getPrimaryScaleFactor();
        double secondaryScale = this.verrechnet.getSecondaryScaleFactor();
        double tpAL = (double)TarmedLeistung.getAL(this.verrechnet) / 100.0;
        double tpTL = (double)TarmedLeistung.getTL(this.verrechnet) / 100.0;
        double tpw = this.verrechnet.getTPW();
        Money mAL = new Money(tpAL * tpw * primaryScale * secondaryScale);
        Money mTL = new Money(tpTL * tpw * primaryScale * secondaryScale);
        double tpAll = (double)Math.round((tpAL + tpTL) * 100.0) / 100.0;
        Money mAll = new Money(tpAll * tpw * primaryScale * secondaryScale);
        new Label(ret, 0).setText("TP AL");
        new Label(ret, 0).setText(Double.toString(tpAL));
        new Label(ret, 0).setText(" x ");
        new Label(ret, 0).setText("TP-Wert");
        new Label(ret, 0).setText(Double.toString(tpw));
        new Label(ret, 0).setText(" = ");
        new Label(ret, 0).setText("CHF AL");
        new Label(ret, 0).setText(mAL.getAmountAsString());
        new Label(ret, 0).setText("TP TL");
        new Label(ret, 0).setText(Double.toString(tpTL));
        new Label(ret, 0).setText(" x ");
        new Label(ret, 0).setText("TP-Wert");
        new Label(ret, 0).setText(Double.toString(tpw));
        new Label(ret, 0).setText(" = ");
        new Label(ret, 0).setText("CHF TL");
        new Label(ret, 0).setText(mTL.getAmountAsString());
        Label sep = new Label(ret, 258);
        sep.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText("TP ");
        new Label(ret, 0).setText(Double.toString(tpAll));
        new Label(ret, 0).setText(" x ");
        new Label(ret, 0).setText("TP-Wert");
        new Label(ret, 0).setText(Double.toString(tpw));
        new Label(ret, 0).setText(" = ");
        new Label(ret, 0).setText("CHF ");
        new Label(ret, 0).setText(mAll.getAmountAsString());
        Label sep2 = new Label(ret, 258);
        sep2.setLayoutData((Object)SWTHelper.getFillGridData((int)8, (boolean)true, (int)1, (boolean)false));
        String mins = Integer.toString(tl.getMinutes());
        new Label(ret, 0).setText("Zeit:");
        new Label(ret, 0).setText(String.valueOf(mins) + " min.");
        new Label(ret, 0).setText("Seite");
        this.cSide = new Combo(ret, 4);
        this.cSide.setItems(new String[]{"egal", "links", "rechts"});
        new Label(ret, 0).setText("Pflichtleist.");
        this.bPflicht = new Button(ret, 32);
        String sPflicht = this.verrechnet.getDetail("obligation");
        if (sPflicht == null || Boolean.parseBoolean(sPflicht)) {
            this.bPflicht.setSelection(true);
        }
        if ((side = this.verrechnet.getDetail("Seite")) == null) {
            this.cSide.select(0);
        } else if (side.equalsIgnoreCase("l")) {
            this.cSide.select(1);
        } else {
            this.cSide.select(2);
        }
        if (tl.getServiceTyp().equals("Z") || tl.getServiceTyp().equals("R") || tl.getServiceTyp().equals("B")) {
            new Label(ret, 0);
            new Label(ret, 0);
            new Label(ret, 0).setText("Bezug");
            this.cBezug = new ComboViewer(ret, 2048);
            this.cBezug.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.cBezug.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            ArrayList<BezugComboItem> input = new ArrayList<BezugComboItem>();
            input.add(BezugComboItem.noBezug());
            for (Verrechnet kVerr : this.verrechnet.getKons().getLeistungen()) {
                if (kVerr.getCode().equals(tl.getCode())) continue;
                input.add(BezugComboItem.of(kVerr.getCode()));
            }
            this.cBezug.setInput(input);
            String bezug = this.verrechnet.getDetail("Bezug");
            if (bezug != null) {
                this.cBezug.setSelection((ISelection)new StructuredSelection((Object)BezugComboItem.of(bezug)), true);
            } else {
                this.cBezug.setSelection((ISelection)new StructuredSelection((Object)BezugComboItem.noBezug()), true);
            }
            this.cBezug.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)TarmedDetailDialog.this.cBezug.getSelection();
                    if (selection != null && !selection.isEmpty()) {
                        BezugComboItem selected = (BezugComboItem)selection.getFirstElement();
                        if (selected.isNoBezug) {
                            TarmedDetailDialog.this.verrechnet.setDetail("Bezug", "");
                        } else {
                            TarmedDetailDialog.this.verrechnet.setDetail("Bezug", selected.getCode());
                        }
                    }
                }
            });
        }
        ret.pack();
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText("Tarmed-Details: " + this.verrechnet.getCode());
    }

    protected void okPressed() {
        int idx = this.cSide.getSelectionIndex();
        if (idx < 1) {
            this.verrechnet.setDetail("Seite", null);
        } else if (idx == 1) {
            this.verrechnet.setDetail("Seite", "l");
        } else {
            this.verrechnet.setDetail("Seite", "r");
        }
        this.verrechnet.setDetail("obligation", Boolean.toString(this.bPflicht.getSelection()));
        super.okPressed();
    }

    private static class BezugComboItem {
        private String code;
        private boolean isNoBezug;

        private BezugComboItem() {
        }

        public static BezugComboItem of(String code) {
            BezugComboItem ret = new BezugComboItem();
            ret.setCode(code);
            return ret;
        }

        public static BezugComboItem noBezug() {
            BezugComboItem ret = new BezugComboItem();
            ret.setCode("kein Bezug");
            ret.isNoBezug = true;
            return ret;
        }

        public boolean isNoBezug() {
            return this.isNoBezug;
        }

        private void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.getCode();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.isNoBezug ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BezugComboItem other = (BezugComboItem)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return this.isNoBezug == other.isNoBezug;
        }
    }
}

