/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.ui.actions.ReadOnceTreeLoader;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.views.TarmedCodeSelectorContentProvider;
import ch.elexis.views.TarmedSelectorPanelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TarmedCodeSelectorFactory
extends CodeSelectorFactory {
    SelectorPanelProvider slp;
    CommonViewer cv;
    FieldDescriptor<?>[] fields = new FieldDescriptor[]{new FieldDescriptor("Ziffer", "code", FieldDescriptor.Typ.STRING, null), new FieldDescriptor("Text", "Text", null)};
    int eventType = 1;
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            if (ss.isEmpty()) {
                TarmedCodeSelectorFactory.this.tvfa.updateSelection(null);
                return;
            }
            PersistentObject o = (PersistentObject)ss.getFirstElement();
            TarmedCodeSelectorFactory.this.tvfa.updateSelection(o.isDragOK() ? o : null);
        }
    };

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.cv = cv;
        cv.setSelectionChangedListener(this.selChangeListener);
        Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == TarmedCodeSelectorFactory.this.eventType && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    TarmedCodeSelectorFactory.this.slp.fireChangedEvent();
                }
            }
        };
        FieldDescriptor<?>[] fieldDescriptorArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor<?> fd = fieldDescriptorArray[n2];
            fd.setAssignedListener(this.eventType, keyListener);
            ++n2;
        }
        this.slp = new TarmedSelectorPanelProvider(cv, this.fields, true);
        this.slp.addActions(new IAction[]{new Action(){

            public String getToolTipText() {
                return "Kontext (Konsultation, Fall, etc.) Filter (de)aktivieren";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_FILTER.getImageDescriptor();
            }

            public void run() {
                ((TarmedSelectorPanelProvider)TarmedCodeSelectorFactory.this.slp).toggleFilters();
            }
        }});
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.tvfa);
        cv.setContextMenu(menu);
        Object contentProvider = new ReadOnceTreeLoader(cv, new Query(TarmedLeistung.class), "Parent", "ID");
        if (TarmedLeistung.hasParentIdReference()) {
            contentProvider = new TarmedCodeSelectorContentProvider(cv);
        }
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)contentProvider, (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        return vc;
    }

    public Class getElementClass() {
        return TarmedLeistung.class;
    }

    public void dispose() {
        this.cv.dispose();
    }

    public String getCodeSystemName() {
        return "Tarmed";
    }

    public PersistentObject findElement(String code) {
        return (PersistentObject)TarmedLeistung.getFromCode(code);
    }
}

