/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class TarmedCodeSelectorContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ITreeContentProvider {
    private Query<TarmedLeistung> childrenQuery;
    private List<TarmedLeistung> roots;
    private CommonViewer commonViewer;
    private boolean isFiltered;
    private Query<TarmedLeistung> leafsQuery;
    private HashMap<String, List<TarmedLeistung>> filteredLeafs;
    private RefreshExecutor refreshExecutor;
    private String currentZiffer;
    private String currentText;

    public TarmedCodeSelectorContentProvider(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
        this.childrenQuery = new Query(TarmedLeistung.class, null, null, "TARMED", new String[]{"GueltigVon", "GueltigBis", "Law"});
        this.leafsQuery = new Query(TarmedLeistung.class, null, null, "TARMED", new String[]{"GueltigVon", "GueltigBis", "Law"});
        this.filteredLeafs = new HashMap();
        this.refreshExecutor = new RefreshExecutor();
    }

    public void changed(HashMap<String, String> values) {
        this.currentZiffer = values.get("Ziffer");
        this.currentText = values.get("Text");
        if (this.shouldFilter(this.currentZiffer, this.currentText)) {
            if (!this.isFiltered) {
                this.isFiltered = true;
            }
            this.refreshExecutor.add(new RefreshRunnable(this.currentZiffer, this.currentText));
        } else if (this.isFiltered) {
            this.isFiltered = false;
            this.commonViewer.getViewerWidget().getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget();
                    viewer.setSelection((ISelection)new StructuredSelection());
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    viewer.getControl().setRedraw(true);
                }
            });
        }
    }

    private void refreshLeafs(String queryZiffer, String queryText) {
        this.filteredLeafs.clear();
        this.leafsQuery.clear();
        if (queryZiffer != null && queryZiffer.length() > 2) {
            this.leafsQuery.add("code", "LIKE", String.valueOf(queryZiffer) + "%");
        }
        if (queryText != null && queryText.length() > 2) {
            this.leafsQuery.add("Text", "LIKE", "%" + queryText + "%");
        }
        this.leafsQuery.add("ischapter", "=", "0");
        this.leafsQuery.orderBy(false, new String[]{"code"});
        List leafs = this.leafsQuery.execute();
        for (TarmedLeistung tarmedLeistung : leafs) {
            String parentId = tarmedLeistung.getParent();
            List<TarmedLeistung> list = this.filteredLeafs.get(parentId);
            if (list == null) {
                list = new ArrayList<TarmedLeistung>();
            }
            list.add(tarmedLeistung);
            this.filteredLeafs.put(parentId, list);
        }
    }

    private boolean shouldFilter(String ziffer, String text) {
        return ziffer.length() > 2 || text.length() > 2;
    }

    public void reorder(String field) {
        System.out.println(field);
    }

    public void selected() {
    }

    public void init() {
    }

    public void startListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void stopListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public Object[] getElements(Object inputElement) {
        if (this.roots == null) {
            this.roots = this.getRoots();
        }
        List<TarmedLeistung> ret = this.roots;
        if (this.isFiltered) {
            ret = this.purgeRoots(ret);
        }
        return ret.toArray();
    }

    private List<TarmedLeistung> getRoots() {
        Query rootQuery = new Query(TarmedLeistung.class);
        rootQuery.clear();
        rootQuery.add("Parent", "=", "NIL");
        rootQuery.orderBy(false, new String[]{"code"});
        return rootQuery.execute();
    }

    private List<TarmedLeistung> purgeRoots(List<TarmedLeistung> roots) {
        ArrayList<TarmedLeistung> ret = new ArrayList<TarmedLeistung>();
        for (TarmedLeistung root : roots) {
            if (this.currentZiffer != null && this.currentZiffer.length() > 2) {
                if (!root.getCode().equals(this.currentZiffer.substring(0, 2))) continue;
                ret.add(root);
                continue;
            }
            if (!this.subChaptersHaveChildren(root)) continue;
            ret.add(root);
        }
        return ret;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TarmedLeistung) {
            TarmedLeistung parentLeistung = (TarmedLeistung)((Object)parentElement);
            if (!this.isFiltered) {
                this.childrenQuery.clear();
                this.childrenQuery.add("Parent", "=", parentLeistung.getId());
                this.childrenQuery.orderBy(false, new String[]{"code"});
                return this.childrenQuery.execute().toArray();
            }
            if (this.subChaptersHaveChildren(parentLeistung)) {
                return this.getFilteredChapterChildren(parentLeistung).toArray();
            }
        }
        return null;
    }

    private boolean subChaptersHaveChildren(TarmedLeistung parentLeistung) {
        List<TarmedLeistung> children = this.getFilteredChapterChildren(parentLeistung);
        for (TarmedLeistung tarmedLeistung : children) {
            if (tarmedLeistung.isChapter()) {
                if (!this.subChaptersHaveChildren(tarmedLeistung)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof TarmedLeistung) {
            TarmedLeistung leistung = (TarmedLeistung)((Object)element);
            return TarmedLeistung.load(leistung.get("Parent"));
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof TarmedLeistung) {
            TarmedLeistung parentLeistung = (TarmedLeistung)((Object)parentElement);
            if (!this.isFiltered) {
                this.childrenQuery.clear();
                this.childrenQuery.add("Parent", "=", parentLeistung.getId());
                return !this.childrenQuery.execute().isEmpty();
            }
            List<TarmedLeistung> filteredChildren = this.getFilteredChapterChildren(parentLeistung);
            return !filteredChildren.isEmpty();
        }
        return false;
    }

    private List<TarmedLeistung> getFilteredChapterChildren(TarmedLeistung parentLeistung) {
        List<TarmedLeistung> leafs;
        ArrayList<TarmedLeistung> ret = new ArrayList<TarmedLeistung>();
        List<TarmedLeistung> chapterChildren = this.getChapterChildren(parentLeistung);
        if (!chapterChildren.isEmpty()) {
            for (TarmedLeistung chapter : chapterChildren) {
                if (!this.subChaptersHaveChildren(chapter)) continue;
                ret.add(chapter);
            }
        }
        if ((leafs = this.filteredLeafs.get(parentLeistung.getId())) != null && !leafs.isEmpty()) {
            ret.addAll(leafs);
        }
        return ret;
    }

    private List<TarmedLeistung> getChapterChildren(TarmedLeistung parentLeistung) {
        this.childrenQuery.clear();
        this.childrenQuery.add("Parent", "=", parentLeistung.getId());
        this.childrenQuery.add("ischapter", "=", "1");
        return this.childrenQuery.execute();
    }

    private class RefreshExecutor {
        private Executor executor = Executors.newSingleThreadExecutor();
        private boolean isRunning = false;
        private Timer timer;
        private int timerCountDown;
        private RefreshRunnable currentRunnable;
        private long currentRunnableMs;

        private RefreshExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RefreshRunnable refreshRunnable) {
            this.checkTimer();
            Class<RefreshExecutor> clazz = RefreshExecutor.class;
            synchronized (RefreshExecutor.class) {
                this.currentRunnable = refreshRunnable;
                this.currentRunnable.setExecutor(this);
                this.currentRunnableMs = System.currentTimeMillis();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTimer() {
            Class<RefreshExecutor> clazz = RefreshExecutor.class;
            synchronized (RefreshExecutor.class) {
                if (this.timer == null) {
                    this.timer = new Timer();
                    this.timerCountDown = 30;
                    this.timer.scheduleAtFixedRate(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Class<RefreshExecutor> clazz = RefreshExecutor.class;
                            synchronized (RefreshExecutor.class) {
                                if (!RefreshExecutor.this.isRunning && RefreshExecutor.this.currentRunnable != null && System.currentTimeMillis() - RefreshExecutor.this.currentRunnableMs > 750L) {
                                    RefreshExecutor.this.executor.execute(RefreshExecutor.this.currentRunnable);
                                    RefreshExecutor.this.setIsRunning(true);
                                    RefreshExecutor.this.currentRunnable = null;
                                }
                                RefreshExecutor refreshExecutor = RefreshExecutor.this;
                                int n = refreshExecutor.timerCountDown - 1;
                                refreshExecutor.timerCountDown = n;
                                if (n == 0) {
                                    RefreshExecutor.this.timer.cancel();
                                    RefreshExecutor.this.timer = null;
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    }, 250L, 250L);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void setIsRunning(boolean value) {
            this.isRunning = value;
            this.timerCountDown = 30;
        }
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshExecutor refreshExecutor;
        private String queryZiffer;
        private String queryText;
        private Display display;

        public RefreshRunnable(String queryZiffer, String queryText) {
            this.queryText = queryText;
            this.queryZiffer = queryZiffer;
            this.display = TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget().getControl().getDisplay();
        }

        public void setExecutor(RefreshExecutor refreshExecutor) {
            this.refreshExecutor = refreshExecutor;
        }

        @Override
        public void run() {
            if (this.queryText != null && this.queryText.length() > 2) {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog pmd = new ProgressMonitorDialog(RefreshRunnable.this.display.getActiveShell());
                        try {
                            pmd.run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask("Text Suche nach (" + RefreshRunnable.this.queryText + ")", -1);
                                    RefreshRunnable.this.doWork();
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.doWork();
            }
        }

        private void doWork() {
            TarmedCodeSelectorContentProvider.this.refreshLeafs(this.queryZiffer, this.queryText);
            if (this.refreshExecutor != null) {
                this.refreshExecutor.setIsRunning(false);
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = TarmedCodeSelectorContentProvider.this.commonViewer.getViewerWidget();
                    viewer.setSelection((ISelection)new StructuredSelection());
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    if (RefreshRunnable.this.queryZiffer != null && RefreshRunnable.this.queryZiffer.length() > 4 || RefreshRunnable.this.queryText != null && RefreshRunnable.this.queryText.length() > 4) {
                        if (viewer instanceof TreeViewer) {
                            ((TreeViewer)viewer).expandAll();
                        }
                    } else {
                        ((TreeViewer)viewer).collapseAll();
                    }
                    viewer.getControl().setRedraw(true);
                }
            });
        }
    }
}

