/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.tarmed.printer.XML40Printer;
import ch.elexis.tarmed.printer.XML44Printer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.jdom.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RnPrintView2
extends ViewPart {
    public static final String ID = "ch.elexis.arzttarife_ch.printview2";
    private static Logger logger = LoggerFactory.getLogger(RnPrintView2.class);
    TextContainer text;

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, new ITextPlugin.ICallback(){

            public void save() {
            }

            public boolean saveAs() {
                return false;
            }
        });
        this.text.getPlugin().setParameter(ITextPlugin.Parameter.NOUI);
    }

    public void setFocus() {
    }

    public boolean doPrint(Rechnung rn, IRnOutputter.TYPE rnType, String saveFile, boolean withESR, boolean withForms, boolean doVerify, IProgressMonitor monitor) {
        XMLExporter xmlex = new XMLExporter();
        Document xmlRn = xmlex.doExport(rn, saveFile, rnType, doVerify);
        if (rn.getStatus() == 22) {
            return false;
        }
        this.initializeRequiredTemplates();
        if (TarmedJaxbUtil.getXMLVersion((Document)xmlRn).equals("4.0")) {
            XML40Printer xmlPrinter = new XML40Printer(this.text);
            return xmlPrinter.doPrint(rn, xmlRn, rnType, saveFile, withESR, withForms, doVerify, monitor);
        }
        if (TarmedJaxbUtil.getXMLVersion((Document)xmlRn).equals("4.4")) {
            XML44Printer xmlPrinter = new XML44Printer(this.text);
            return xmlPrinter.doPrint(rn, xmlRn, rnType, saveFile, withESR, withForms, doVerify, monitor);
        }
        SWTHelper.showError((String)"Fehler beim Drucken", (String)"Die Rechnung ist in keinem g\u00fcltigen XML Format");
        rn.addTrace("Zur\u00fcckgewiesen", "XML Format");
        return false;
    }

    private void initializeRequiredTemplates() {
        if (!this.testTemplate("Tarmedrechnung_S1")) {
            this.initializeTemplate("Tarmedrechnung_S1");
        }
        if (!this.testTemplate("Tarmedrechnung_S2")) {
            this.initializeTemplate("Tarmedrechnung_S2");
        }
        if (!this.testTemplate("TR44_S1")) {
            this.initializeTemplate("TR44_S1");
        }
        if (!this.testTemplate("TR44_S2")) {
            this.initializeTemplate("TR44_S2");
        }
    }

    private void initializeTemplate(String name) {
        byte[] content;
        String templateUrl = this.getTemplateUrl(name);
        if (templateUrl != null && (content = this.downloadTempalte(templateUrl)) != null && content.length > 0) {
            Brief template = new Brief(name, null, (Kontakt)CoreHub.actUser, null, null, "Vorlagen");
            template.save(content, this.text.getPlugin().getMimeType());
            template.set("BehandlungsID", "SYS");
        }
    }

    private byte[] downloadTempalte(String templateUrl) {
        ByteArrayOutputStream bout;
        block23: {
            BufferedInputStream in = null;
            bout = null;
            try {
                try {
                    int count;
                    in = new BufferedInputStream(new URL(templateUrl).openStream());
                    bout = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((count = in.read(data, 0, 1024)) != -1) {
                        bout.write(data, 0, count);
                    }
                }
                catch (IOException e) {
                    logger.warn("Could not dowload template from [" + templateUrl + "]", (Throwable)e);
                    if (in == null) break block23;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (bout != null) {
                            bout.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (bout != null) {
                            bout.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bout != null ? bout.toByteArray() : null;
    }

    private String getTemplateUrl(String name) {
        block34: {
            block32: {
                if (!this.isWord()) break block32;
                switch (name) {
                    case "Tarmedrechnung_S1": {
                        return "https://medelexis.ch/wp-content/uploads/Tarmedrechnung_S1_01.docx";
                    }
                    case "Tarmedrechnung_S2": {
                        return "https://medelexis.ch/wp-content/uploads/Tarmedrechnung_S2_01.docx";
                    }
                    case "TR44_S1": {
                        return "https://medelexis.ch/wp-content/uploads/TR44_S1.docx";
                    }
                    case "TR44_S2": {
                        return "https://medelexis.ch/wp-content/uploads/TR44_S2.docx";
                    }
                }
                break block34;
            }
            switch (name) {
                case "Tarmedrechnung_S1": {
                    return "https://medelexis.ch/wp-content/uploads/Tarmedrechnung_S1.odt";
                }
                case "Tarmedrechnung_S2": {
                    return "https://medelexis.ch/wp-content/uploads/Tarmedrechnung_S2.odt";
                }
                case "TR44_S1": {
                    return "https://medelexis.ch/wp-content/uploads/TR44_S1.odt";
                }
                case "TR44_S2": {
                    return "https://medelexis.ch/wp-content/uploads/TR44_S2.odt";
                }
            }
        }
        return null;
    }

    private boolean isWord() {
        return this.text.getPlugin().getMimeType().equals("docx");
    }

    private boolean testTemplate(String name) {
        Query qbe = new Query(Brief.class);
        qbe.add("Typ", "=", "Vorlagen");
        qbe.and();
        qbe.add("Betreff", "=", name);
        List list = qbe.execute();
        return list != null && list.size() != 0;
    }
}

