/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.RFE;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class RFEView
extends ViewPart {
    Table longTable;
    Table shortTable;
    Table mediumTable;
    CTabFolder tabs;
    Composite cCalc;
    boolean bDaempfung = false;
    HashMap<String, Integer> mapCodeToIndex = new HashMap();
    HashMap<Integer, String> mapIndexToCode = new HashMap();
    static final int No_More_Valid = 1;
    ElexisUiEventListenerImpl eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class){

        public void runInUi(ElexisEvent ev) {
            Konsultation k = (Konsultation)ev.getObject();
            RFEView.this.adjustTable(k);
        }
    };

    private void adjustTable(Konsultation k) {
        Control c;
        List<Object> rfeForKOns = k != null ? RFE.getRfeForKons(k.getId()) : Collections.emptyList();
        CTabItem top = this.tabs.getSelection();
        if (top != null && (c = top.getControl()) instanceof Table) {
            Table table = (Table)c;
            table.deselectAll();
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                it.setImage(null);
                ++n2;
            }
            for (RFE rfe : rfeForKOns) {
                int idx = this.mapCodeToIndex.get(rfe.getCode());
                TableItem item = table.getItem(idx);
                if (!item.getChecked()) continue;
                item.setImage(Images.IMG_TICK.getImage());
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.tabs = new CTabFolder(parent, 1024);
        this.tabs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        CTabItem ctLong = new CTabItem(this.tabs, 0);
        ctLong.setText("lang");
        this.longTable = new Table((Composite)this.tabs, 65570);
        ctLong.setControl((Control)this.longTable);
        CTabItem ctMedium = new CTabItem(this.tabs, 0);
        ctMedium.setText("kurz");
        this.mediumTable = new Table((Composite)this.tabs, 65570);
        ctMedium.setControl((Control)this.mediumTable);
        CTabItem ctStat = new CTabItem(this.tabs, 0);
        ctStat.setText("Statistik");
        Composite cStat = new Composite((Composite)this.tabs, 0);
        cStat.setLayout((Layout)new GridLayout());
        ctStat.setControl((Control)cStat);
        Button bRecalc = new Button(cStat, 8);
        bRecalc.setText("Berechnen");
        bRecalc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cCalc = new Composite(cStat, 0);
        this.cCalc.setLayout((Layout)new GridLayout());
        this.cCalc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        bRecalc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = RFEView.this.cCalc.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                Query qbe = new Query(RFE.class);
                int[] result = new int[RFE.getRFETexts().length];
                int all = 0;
                for (RFE rfe : qbe.execute()) {
                    int idx;
                    String code = rfe.getCode();
                    if (code.length() != 2) continue;
                    int n3 = idx = RFEView.this.mapCodeToIndex.get(code).intValue();
                    result[n3] = result[n3] + 1;
                    ++all;
                }
                int rline = 0;
                while (rline < result.length) {
                    String code = RFEView.this.mapIndexToCode.get(rline);
                    int num = result[rline];
                    float percent = (float)num * 100.0f / (float)all;
                    int pc = Math.round(percent);
                    Label lbl = new Label(RFEView.this.cCalc, 0);
                    lbl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                    lbl.setText(String.valueOf(code) + ": " + num + " (=" + pc + "%)");
                    ++rline;
                }
                RFEView.this.cCalc.layout(true);
            }
        });
        int i = 0;
        String[][] stringArray = RFE.getRFEDescriptions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] t = stringArray[n2];
            TableItem longItem = new TableItem(this.longTable, 0);
            longItem.setText(t[2]);
            TableItem mediumItem = new TableItem(this.mediumTable, 0);
            mediumItem.setText(t[1]);
            this.mapCodeToIndex.put(t[0], i);
            this.mapIndexToCode.put(i, t[0]);
            if (i == 1) {
                mediumItem.setBackground(UiDesk.getColor((String)"hellgrau"));
                mediumItem.setGrayed(true);
                longItem.setBackground(UiDesk.getColor((String)"hellgrau"));
                longItem.setGrayed(true);
            }
            ++i;
            ++n2;
        }
        this.longTable.addSelectionListener((SelectionListener)new ClickListener(this.longTable));
        this.mediumTable.addSelectionListener((SelectionListener)new ClickListener(this.mediumTable));
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_kons});
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons});
    }

    public void setFocus() {
    }

    class ClickListener
    extends SelectionAdapter {
        Table table;

        ClickListener(Table table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            int[] sel;
            Konsultation k = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            if (k != null && (sel = this.table.getSelectionIndices()).length > 0) {
                RFE.clear(k);
                int[] nArray = sel;
                int n = sel.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    if (s == 1) break;
                    String code = RFEView.this.mapIndexToCode.get(s);
                    new RFE(k.getId(), code);
                    ++n2;
                }
                RFEView.this.adjustTable(k);
            }
        }
    }
}

