/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PhysioLeistung;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.LabelProvider;

public class PhysioLeistungsCodeSelectorFactory
extends CodeSelectorFactory {
    private Query<PhysioLeistung> qbe;
    private ViewerConfigurer vc;
    private UpdateDateEventListener updateListener = new UpdateDateEventListener();

    public PhysioLeistungsCodeSelectorFactory() {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.updateListener});
    }

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        FieldDescriptor[] fd = new FieldDescriptor[]{new FieldDescriptor("Ziffer", "Ziffer", null), new FieldDescriptor("Text", "Text", null)};
        this.qbe = new Query(PhysioLeistung.class);
        this.qbe.addPostQueryFilter(new IFilter(){
            private TimeTool validFrom = new TimeTool();
            private TimeTool validTo = new TimeTool();

            public boolean select(Object toTest) {
                if (toTest instanceof PhysioLeistung) {
                    PhysioLeistung physio = (PhysioLeistung)((Object)toTest);
                    if (physio.getId().equals("VERSION")) {
                        return false;
                    }
                    Konsultation selectedKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                    if (selectedKons != null) {
                        TimeTool validDate = new TimeTool(selectedKons.getDatum());
                        this.validTo.set(physio.get("bis"));
                        if (validDate.isBefore(this.validTo)) {
                            this.validFrom.set(physio.get("von"));
                            return validDate.isAfterOrEqual(this.validFrom);
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        FlatDataLoader fdl = new FlatDataLoader(cv, this.qbe);
        SelectorPanelProvider slp = new SelectorPanelProvider(fd, true);
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)fdl, (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, cv));
        return this.vc;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "Physiotherapie";
    }

    public Class<? extends PersistentObject> getElementClass() {
        return PhysioLeistung.class;
    }

    public PersistentObject findElement(String code) {
        String id = new Query(PhysioLeistung.class).findSingle("Ziffer", "=", code);
        return PhysioLeistung.load(id);
    }

    private class UpdateDateEventListener
    extends ElexisEventListenerImpl {
        public UpdateDateEventListener() {
            super(Konsultation.class, 48);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            if (PhysioLeistungsCodeSelectorFactory.this.vc != null && PhysioLeistungsCodeSelectorFactory.this.vc.getControlFieldProvider() != null) {
                PhysioLeistungsCodeSelectorFactory.this.vc.getControlFieldProvider().fireChangedEvent();
            }
        }
    }
}

