/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.ComplementaryLeistung;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class ComplementarySubDetail
extends Composite {
    private ComplementaryLeistung complementary;
    private ToolBar toolbar;
    private TableViewer subTable;

    public ComplementarySubDetail(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.createContent();
    }

    private void createContent() {
        ToolBarManager manager = new ToolBarManager();
        manager.add((IAction)new Action(){

            public String getToolTipText() {
                return "Neuer alternativer Leistungstext";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                SubDetailDialog dialog = new SubDetailDialog(ComplementarySubDetail.this.getShell(), "Neuer alternativer Leistungstext mit Wert", "Bitte den neuen alternativen Leistungstext und Wert eingeben.");
                if (dialog.open() == 0) {
                    String newAlternativeText = dialog.getText();
                    Integer newAlternativeValue = dialog.getValue();
                    ComplementaryLeistung newComplementary = new ComplementaryLeistung(ComplementarySubDetail.this.getNextSubId(), ComplementarySubDetail.this.complementary.get("chapter"), ComplementarySubDetail.this.complementary.getCode(), newAlternativeText, "", ComplementarySubDetail.this.complementary.get("validfrom"), ComplementarySubDetail.this.complementary.get("validto"));
                    newComplementary.setFixedValue(newAlternativeValue);
                    ComplementarySubDetail.this.updateContent();
                }
            }
        });
        manager.add((IAction)new Action(){

            public String getToolTipText() {
                return "Alternativer Leistungstext entfernen";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                ISelection selection = ComplementarySubDetail.this.subTable.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    ComplementaryLeistung element = (ComplementaryLeistung)((Object)((StructuredSelection)selection).getFirstElement());
                    element.delete();
                    ComplementarySubDetail.this.updateContent();
                }
            }
        });
        this.toolbar = manager.createControl((Composite)this);
        this.toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.subTable = new TableViewer((Composite)this, 2048);
        this.subTable.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.subTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.subTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ComplementaryLeistung) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((ComplementaryLeistung)((Object)element)).getText());
                    if (((ComplementaryLeistung)((Object)element)).isFixedValueSet()) {
                        sb.append(" (" + Double.toString((double)((ComplementaryLeistung)((Object)element)).getFixedValue() / 100.0) + ")");
                    }
                    return sb.toString();
                }
                return super.getText(element);
            }
        });
    }

    private void updateContent() {
        Query query = new Query(ComplementaryLeistung.class);
        query.add("code", "=", this.complementary.getCode());
        query.add("id", "LIKE", String.valueOf(this.complementary.getCode()) + "sub%");
        this.subTable.setInput((Object)query.execute());
        this.subTable.refresh();
    }

    private String getNextSubId() {
        Query query = new Query(ComplementaryLeistung.class);
        query.clear(true);
        query.add("code", "=", this.complementary.getCode());
        query.add("id", "LIKE", String.valueOf(this.complementary.getCode()) + "sub%-" + this.complementary.get("validfrom"));
        List existing = query.execute();
        HashMap<Integer, String> existingIndexMap = new HashMap<Integer, String>();
        for (ComplementaryLeistung complementaryLeistung : existing) {
            String id = complementaryLeistung.getId();
            String subId = id.substring(id.indexOf("sub") + 3, id.indexOf("-"));
            existingIndexMap.put(Integer.valueOf(subId), id);
        }
        Integer freeIndex = 1;
        while (existingIndexMap.containsKey(freeIndex)) {
            freeIndex = freeIndex + 1;
        }
        return String.valueOf(this.complementary.getCode()) + "sub" + freeIndex + "-" + this.complementary.get("validfrom");
    }

    public void hide() {
        this.complementary = null;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getLayoutData() instanceof GridData) {
                ((GridData)child.getLayoutData()).exclude = true;
            }
            child.setVisible(false);
            ++n2;
        }
        this.getParent().layout(true, true);
    }

    public void show(ComplementaryLeistung complementary) {
        this.complementary = complementary;
        this.updateContent();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getLayoutData() instanceof GridData) {
                ((GridData)child.getLayoutData()).exclude = false;
            }
            child.setVisible(true);
            ++n2;
        }
        this.getParent().layout(true, true);
    }

    private class SubDetailDialog
    extends Dialog {
        private String title;
        private String message;
        private String textString;
        private Text text;
        private Integer valueInt;
        private Text value;

        protected SubDetailDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
            super(parentShell);
            this.title = dialogTitle;
            this.message = dialogMessage;
        }

        public Integer getValue() {
            return this.valueInt;
        }

        public String getText() {
            return this.textString;
        }

        protected void okPressed() {
            this.valueInt = -1;
            if (StringUtils.isNotBlank((String)this.text.getText())) {
                try {
                    String valueString = this.value.getText();
                    valueString = valueString.replaceAll(",", ".");
                    this.valueInt = (int)(Float.parseFloat(valueString) * 100.0f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((String)this.text.getText())) {
                this.textString = this.text.getText();
                super.okPressed();
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            if (this.message != null) {
                Label label = new Label(composite, 64);
                label.setText(this.message);
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
            }
            this.text = new Text(composite, 2052);
            this.text.setLayoutData((Object)new GridData(768));
            this.text.setMessage("Leistungstext");
            this.value = new Text(composite, 2052);
            this.value.setLayoutData((Object)new GridData(768));
            this.value.setMessage("Wert");
            SubDetailDialog.applyDialogFont((Control)composite);
            return composite;
        }
    }
}

