/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.data.ComplementaryLeistung;
import ch.elexis.views.ComplementarySubDetail;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ComplementaryDetailDisplay
implements IDetailDisplay {
    private ScrolledForm form;
    private FormToolkit toolkit = UiDesk.getToolkit();
    private Section infoSection;
    private ComplementaryLeistung complementary;
    private Text codeChapter;
    private Text codeCode;
    private Text codeText;
    private Text codeDescription;
    private Text codeFixedValue;
    private ComplementarySubDetail subDetail;

    public Composite createDisplay(Composite parent, IViewSite site) {
        this.form = this.toolkit.createScrolledForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        this.form.setText("Keine Leistung ausgew\u00e4hlt.");
        this.infoSection = this.toolkit.createSection(this.form.getBody(), 354);
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.infoSection.setLayoutData((Object)twd);
        this.infoSection.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        this.infoSection.setText("Details");
        Composite info = this.toolkit.createComposite((Composite)this.infoSection);
        twl = new TableWrapLayout();
        info.setLayout((Layout)twl);
        Label lbl = this.toolkit.createLabel(info, "Kapitel");
        FontData[] bfd = lbl.getFont().getFontData();
        bfd[0].setStyle(1);
        Font boldFont = new Font((Device)Display.getCurrent(), bfd[0]);
        lbl.setFont(boldFont);
        this.codeChapter = this.toolkit.createText(info, "");
        this.codeChapter.setEditable(false);
        this.codeChapter.setLayoutData((Object)new TableWrapData(256));
        lbl = this.toolkit.createLabel(info, "Code");
        lbl.setFont(boldFont);
        this.codeCode = this.toolkit.createText(info, "");
        this.codeCode.setEditable(false);
        twd = new TableWrapData(256);
        this.codeCode.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Text");
        lbl.setFont(boldFont);
        this.codeText = this.toolkit.createText(info, "");
        this.codeText.setEditable(false);
        twd = new TableWrapData(256);
        this.codeText.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Beschreibung");
        lbl.setFont(boldFont);
        this.codeDescription = this.toolkit.createText(info, "", 2);
        this.codeDescription.setEditable(false);
        twd = new TableWrapData(256);
        this.codeDescription.setLayoutData((Object)twd);
        lbl = this.toolkit.createLabel(info, "Pauschal Preis");
        lbl.setFont(boldFont);
        this.codeFixedValue = this.toolkit.createText(info, "", 2);
        twd = new TableWrapData(256);
        this.codeFixedValue.setLayoutData((Object)twd);
        this.codeFixedValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ComplementaryDetailDisplay.this.codeFixedValue.getText();
                if (ComplementaryDetailDisplay.this.complementary != null) {
                    if (text.isEmpty()) {
                        ComplementaryDetailDisplay.this.complementary.setFixedValue(-1);
                        return;
                    }
                    try {
                        int value = (int)(Float.parseFloat(text) * 100.0f);
                        ComplementaryDetailDisplay.this.complementary.setFixedValue(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        ControlDecoration deco = new ControlDecoration((Control)this.codeFixedValue, 16512);
        deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        deco.setDescriptionText("Hier kann ein pauschal Preis angegeben werden. Dieser wird dann anstelle des Stundensatz als Preis verwendet.");
        this.subDetail = new ComplementarySubDetail(info, 0);
        twd = new TableWrapData(256);
        this.subDetail.setLayoutData(twd);
        this.subDetail.hide();
        this.infoSection.setClient((Control)info);
        return this.form.getBody();
    }

    public Class getElementClass() {
        return ComplementaryLeistung.class;
    }

    public void display(Object obj) {
        if (obj instanceof ComplementaryLeistung) {
            this.complementary = (ComplementaryLeistung)((Object)obj);
            if (this.isSub(this.complementary)) {
                this.complementary = this.getParent(this.complementary);
            }
            if (this.complementary.getCode().equals("1302")) {
                this.subDetail.show(this.complementary);
            } else {
                this.subDetail.hide();
            }
            this.form.setText(this.complementary.getLabel());
            this.codeChapter.setText(this.complementary.get("chapter"));
            this.codeCode.setText(this.complementary.getCode());
            this.codeText.setText(this.complementary.getText());
            this.codeDescription.setText(this.complementary.get("description"));
            if (this.complementary.isFixedValueSet()) {
                this.codeFixedValue.setText(Double.toString((double)this.complementary.getFixedValue() / 100.0));
            } else {
                this.codeFixedValue.setText("");
            }
        } else {
            this.complementary = null;
            this.form.setText("Keine Leistung ausgew\u00e4hlt.");
            this.codeChapter.setText("");
            this.codeCode.setText("");
            this.codeText.setText("");
            this.codeDescription.setText("");
            this.codeFixedValue.setText("");
            this.subDetail.hide();
        }
        this.infoSection.layout();
        this.form.reflow(true);
    }

    private ComplementaryLeistung getParent(ComplementaryLeistung complementary) {
        String start = complementary.getId().substring(0, complementary.getId().indexOf("sub"));
        String end = complementary.getId().substring(complementary.getId().indexOf("-"));
        return ComplementaryLeistung.load(String.valueOf(start) + end);
    }

    private boolean isSub(ComplementaryLeistung complementary) {
        return complementary.getId().contains("sub");
    }

    public String getTitle() {
        return "Komplement\u00e4rmedizin";
    }

    private final class SectionExpansionHandler
    extends ExpansionAdapter {
        private SectionExpansionHandler() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            ComplementaryDetailDisplay.this.form.reflow(true);
        }
    }
}

