/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Person;
import ch.elexis.data.TrustCenters;
import ch.elexis.data.Xid;
import ch.elexis.tarmedprefs.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarmedRequirements {
    public static final String INSURANCE_NUMBER = Messages.TarmedRequirements_InsuranceNumberName;
    public static final String CASE_NUMBER = Messages.TarmedRequirements_CaseNumberName;
    public static final String INTERMEDIATE = Messages.TarmedRequirements_IntermediateName;
    public static final String ACCIDENT_NUMBER = Messages.TarmedRequirements_AccidentNumberName;
    public static final String SSN = Messages.TarmedRequirements_SSNName;
    public static final String EAN_PSEUDO = "2000000000000";
    public static final String EAN_PROVIDER = "ean_provider";
    public static final String EAN_RESPONSIBLE = "ean_responsible";
    public static final String EAN_PATTERN = "[0-9]{13}";
    public static final String ACCIDENT_DATE = Messages.TarmedRequirements_AccidentDate;
    public static final String CASE_LAW = Messages.TarmedRequirements_Law;
    public static final String BILLINGSYSTEM_NAME = "TarmedLeistung";
    public static final String OUTPUTTER_NAME = "Tarmed-Drucker";
    public static final String DOMAIN_KSK = "www.xid.ch/id/ksk";
    public static final String DOMAIN_NIF = "www.xid.ch/id/nif";
    public static final String DOMAIN_SUVA = "www.xid.ch/id/suva";
    public static final String RESPONSIBLE_INFO_KEY = "ch.elexis.tarmedprefs.responsible";
    private static Logger logger = LoggerFactory.getLogger(TarmedRequirements.class);

    static {
        Xid.localRegisterXIDDomainIfNotExists((String)DOMAIN_KSK, (String)Messages.TarmedRequirements_kskName, (int)2);
        Xid.localRegisterXIDDomainIfNotExists((String)DOMAIN_NIF, (String)Messages.TarmedRequirements_NifName, (int)2);
        Xid.localRegisterXIDDomainIfNotExists((String)"www.xid.ch/id/recipient_ean", (String)"rEAN", (int)2);
        Xid.localRegisterXIDDomainIfNotExists((String)DOMAIN_SUVA, (String)"Suva-Nr", (int)2);
    }

    public static String getEAN(Kontakt k) {
        if (k == null) {
            return null;
        }
        String ret = k.getXid("www.xid.ch/id/ean");
        if (ret.length() == 0 && (ret = k.getInfoString("EAN")).length() > 0) {
            TarmedRequirements.setEAN(k, ret);
        }
        if (ret.length() == 0) {
            ret = EAN_PSEUDO;
        }
        return ret.trim();
    }

    public static String getRecipientEAN(Kontakt k) {
        String ret = k.getXid("www.xid.ch/id/recipient_ean");
        if (ret.length() == 0) {
            ret = "unknown";
        }
        return ret.trim();
    }

    public static String getSuvaNr(Kontakt k) {
        String ret = k.getXid(DOMAIN_SUVA);
        return ret;
    }

    public static String getIntermediateEAN(Fall fall) {
        return fall.getRequiredString(INTERMEDIATE).trim();
    }

    public static String getProviderEAN(Fall fall) {
        String ean = fall.getRequiredString(EAN_PROVIDER).trim();
        if (!ean.matches("(20[0-9]{11}|76[0-9]{11}|unknown|[A-Z][0-9]{6})")) {
            return "unknown";
        }
        return ean;
    }

    public static String getResponsibleEAN(Fall fall) {
        String ean = fall.getRequiredString(EAN_RESPONSIBLE).trim();
        if (!ean.matches("(20[0-9]{11}|76[0-9]{11}|unknown|[A-Z][0-9]{6})")) {
            return "unknown";
        }
        return ean;
    }

    public static String normalizeKSK(String KSK, boolean bCompact) {
        if (!KSK.matches("[a-zA-Z] ?[0-9]{4,4}\\.?[0-9]{2,2}")) {
            return "invalid";
        }
        KSK = KSK.replaceAll("[^a-zA-Z0-9]", "");
        if (bCompact) {
            return KSK;
        }
        KSK = String.valueOf(KSK.substring(0, 1)) + " " + KSK.substring(1, 5) + "." + KSK.substring(5);
        return KSK.trim();
    }

    public static String getKSK(Kontakt k) {
        String ret = k.getXid(DOMAIN_KSK);
        if (ret.length() == 0 && (ret = k.getInfoString("KSK")).length() > 0) {
            TarmedRequirements.setKSK(k, ret);
        }
        return ret.replaceAll("[\\s\\.\\-]", "").trim();
    }

    public static String getNIF(Kontakt k) {
        String ret = k.getXid(DOMAIN_NIF);
        if (ret.length() == 0 && (ret = k.getInfoString("NIF")).length() > 0) {
            TarmedRequirements.setNIF(k, ret);
        }
        return ret.trim();
    }

    public static boolean setEAN(Kontakt k, String ean) {
        if (!ean.matches("[0-9]{13,13}")) {
            return false;
        }
        k.addXid("www.xid.ch/id/ean", ean, true);
        return true;
    }

    public static void setKSK(Kontakt k, String ksk) {
        k.addXid(DOMAIN_KSK, ksk, true);
    }

    public static void setNIF(Kontakt k, String nif) {
        k.addXid(DOMAIN_NIF, nif, true);
    }

    public static void setSuvaNr(Kontakt k, String SuvaNr) {
        k.addXid(DOMAIN_SUVA, SuvaNr, true);
    }

    public static String getAHV(Person p) {
        String ahv = p.getXid("www.ahv.ch/xid");
        if (ahv.length() == 0) {
            ahv = p.getInfoString(SSN);
            if (ahv.length() == 0) {
                ahv = p.getInfoString(INSURANCE_NUMBER);
            }
            if (ahv.length() > 0) {
                TarmedRequirements.setAHV(p, ahv);
            }
        }
        return ahv.trim();
    }

    public static void setAHV(Person p, String ahv) {
        p.addXid("www.ahv.ch/xid", ahv, true);
    }

    public static String getGesetz(Fall fall) {
        return fall.getConfiguredBillingSystemLaw().name();
    }

    public static String getTCName(Kontakt mandant) {
        String tc = mandant.getInfoString("TarmedTC");
        return tc;
    }

    public static String getTCCode(Kontakt mandant) {
        String tcname = TarmedRequirements.getTCName(mandant);
        Integer nr = TrustCenters.tc.get(tcname);
        if (nr == null) {
            return "00";
        }
        return Integer.toString(nr);
    }

    public static void setTC(Kontakt mandant, String tc) {
        mandant.setInfoElement("TarmedTC", (Object)tc);
    }

    public static boolean hasTCContract(Kontakt mandant) {
        String hc = (String)mandant.getInfoElement("TarmedUseTC");
        return "1".equals(hc);
    }
}

