/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktExtDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Organisation;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.TrustCenters;
import ch.elexis.tarmedprefs.Messages;
import ch.elexis.tarmedprefs.ResponsibleComposite;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RechnungsPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int FONT_MIN_INDEX = 0;
    private static final int FONT_NORMAL_INDEX = 1;
    private static final int FONT_BOLD_INDEX = 2;
    public static final String PREF_ADDCHILDREN = "tarmed/addchildrentp";
    Combo cbMands;
    HashMap<String, Mandant> hMandanten;
    Hyperlink hTreat;
    Hyperlink hPost;
    Hyperlink hBank;
    IHyperlinkListener hDetailListener;
    FocusListener focusListener;
    Text tTreat;
    Text tPost;
    Text tBank;
    Text tESRNormalFontName;
    Text tESRNormalFontSize;
    Text tESROCRFontName;
    Text tESROCRFontSize;
    Text tESRPrinterCorrectionX;
    Text tESRPrinterCorrectionY;
    Text tESRPrintCorrectionBaseX;
    Text tESRPrintCorrectionBaseY;
    Combo cbESROCRFontWeight;
    Button bPost;
    Button bBank;
    Mandant actMandant;
    Kontakt actBank;
    Button bUseTC;
    Combo cbTC;
    Button bBillsElec;
    private ResponsibleComposite responsible;
    private ComboViewer cvMandantType;
    static TarmedACL ta = TarmedACL.getInstance();
    static final String[] ExtFlds = new String[]{"Anrede=www.elexis.ch/xid/kontakt/anrede", "Kanton=www.elexis.ch/xid/kontakt/kanton", "EAN=www.xid.ch/id/ean", "NIF=www.xid.ch/id/nif", "KSK=www.xid.ch/id/ksk", RechnungsPrefs.ta.ESR5OR9, RechnungsPrefs.ta.ESRPLUS, RechnungsPrefs.ta.TIERS, RechnungsPrefs.ta.SPEC, RechnungsPrefs.ta.KANTON, RechnungsPrefs.ta.LOCAL, RechnungsPrefs.ta.DIAGSYS, "Rolle=www.elexis.ch/xid/kontakt/rolle"};

    public RechnungsPrefs() {
        super(Messages.RechnungsPrefs_BillPrefs);
    }

    public void dispose() {
    }

    protected Control createContents(Composite parent) {
        Color blau = UiDesk.getColor((String)"blau");
        this.hDetailListener = new DetailListener();
        this.focusListener = new TextListener();
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.hMandanten = new HashMap();
        this.cbMands = new Combo(ret, 8);
        this.cbMands.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbMands.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = RechnungsPrefs.this.cbMands.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                RechnungsPrefs.this.setMandant(RechnungsPrefs.this.hMandanten.get(RechnungsPrefs.this.cbMands.getItem(i)));
            }
        });
        Query qbe = new Query(Mandant.class);
        List list = qbe.execute();
        for (Mandant m : list) {
            this.cbMands.add(m.getLabel());
            this.hMandanten.put(m.getLabel(), m);
        }
        Group adrs = new Group(ret, 0);
        adrs.setLayout((Layout)new GridLayout(2, false));
        adrs.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        adrs.setText(Messages.RechnungsPrefs_BillDetails);
        this.hTreat = new Hyperlink((Composite)adrs, 0);
        this.hTreat.setText(Messages.RechnungsPrefs_Treator);
        this.hTreat.setForeground(blau);
        this.hTreat.addHyperlinkListener(this.hDetailListener);
        this.tTreat = new Text((Composite)adrs, 2056);
        this.tTreat.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Label lMandantType = new Label((Composite)adrs, 0);
        lMandantType.setText(Messages.RechnungsPrefs_MandantType);
        lMandantType.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cvMandantType = new ComboViewer((Composite)adrs);
        this.cvMandantType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cvMandantType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TarmedLeistung.MandantType) {
                    if (element == TarmedLeistung.MandantType.SPECIALIST) {
                        return Messages.RechnungsPrefs_MandantType_SPECIALIST;
                    }
                    if (element == TarmedLeistung.MandantType.PRACTITIONER) {
                        return Messages.RechnungsPrefs_MandantType_PRACTITIONER;
                    }
                }
                return element.toString();
            }
        });
        this.cvMandantType.setInput((Object)TarmedLeistung.MandantType.values());
        this.cvMandantType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty() && (element = ((StructuredSelection)selection).getFirstElement()) instanceof TarmedLeistung.MandantType && RechnungsPrefs.this.actMandant != null) {
                    TarmedLeistung.setMandantType(RechnungsPrefs.this.actMandant, (TarmedLeistung.MandantType)((Object)element));
                }
            }
        });
        this.cvMandantType.getCombo().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bBillsElec = new Button((Composite)adrs, 32);
        this.bBillsElec.setText("Bills electronically");
        if (this.actMandant != null) {
            this.bBillsElec.setSelection(CoreHub.getUserSetting((Kontakt)this.actMandant).get("TarmedBillElectronic", false));
        }
        this.bBillsElec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Settings settings = CoreHub.getUserSetting((Kontakt)RechnungsPrefs.this.actMandant);
                settings.set("TarmedBillElectronic", RechnungsPrefs.this.bBillsElec.getSelection());
                settings.flush();
            }
        });
        Composite cFinanzinstitut = new Composite((Composite)adrs, 0);
        cFinanzinstitut.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        cFinanzinstitut.setLayout((Layout)new GridLayout(2, false));
        Label lFinanzinstitut = new Label(cFinanzinstitut, 0);
        lFinanzinstitut.setText(Messages.RechnungsPrefs_Financeinst);
        lFinanzinstitut.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bPost = new Button(cFinanzinstitut, 16);
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        this.bPost.setLayoutData((Object)gd);
        this.bPost.setText(Messages.RechnungsPrefs_post);
        this.bPost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RechnungsPrefs.this.actBank != null && RechnungsPrefs.this.actBank.isValid()) {
                    RechnungsPrefs.this.actBank = null;
                    RechnungsPrefs.this.actMandant.setInfoElement(RechnungsPrefs.ta.RNBANK, (Object)"");
                    RechnungsPrefs.this.actMandant.setInfoElement(RechnungsPrefs.ta.ESRNUMBER, (Object)"");
                    RechnungsPrefs.this.actMandant.setInfoElement(RechnungsPrefs.ta.ESRSUB, (Object)Messages.RechnungsPrefs_13);
                    RechnungsPrefs.this.actMandant.setInfoElement(Messages.RechnungsPrefs_department, (Object)"");
                    RechnungsPrefs.this.actMandant.setInfoElement(Messages.RechnungsPrefs_POBox, (Object)"");
                }
                if (StringTool.isNothing((Object)RechnungsPrefs.this.actMandant.getInfoElement(RechnungsPrefs.ta.ESRNUMBER))) {
                    new PostDialog(RechnungsPrefs.this.getShell()).open();
                }
                RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            }
        });
        Composite cPost = new Composite(cFinanzinstitut, 0);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        cPost.setLayoutData((Object)gd);
        cPost.setLayout((Layout)new GridLayout(1, false));
        this.hPost = new Hyperlink(cPost, 0);
        this.hPost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.hPost.setText(Messages.RechnungsPrefs_POAccount);
        this.hPost.setForeground(blau);
        this.hPost.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new PostDialog(RechnungsPrefs.this.getShell()).open();
                RechnungsPrefs.this.setMandant(RechnungsPrefs.this.actMandant);
            }
        });
        this.tPost = new Text(cPost, 2056);
        this.tPost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bBank = new Button(cFinanzinstitut, 16);
        gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        this.bBank.setLayoutData((Object)gd);
        this.bBank.setText(Messages.RechnungsPrefs_bank);
        this.bBank.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RechnungsPrefs.this.actBank == null) {
                    RechnungsPrefs.this.actMandant.setInfoElement(RechnungsPrefs.ta.ESRNUMBER, (Object)"");
                    new BankLister(RechnungsPrefs.this.getShell()).open();
                }
            }
        });
        Composite cBank = new Composite(cFinanzinstitut, 0);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 128;
        cBank.setLayoutData((Object)gd);
        cBank.setLayout((Layout)new GridLayout(1, false));
        this.hBank = new Hyperlink(cBank, 0);
        this.hBank.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.hBank.setText(Messages.RechnungsPrefs_bankconnection);
        this.hBank.setForeground(blau);
        this.hBank.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BankLister dlg = new BankLister(RechnungsPrefs.this.getShell());
                dlg.open();
            }
        });
        this.tBank = new Text(cBank, 2056);
        this.tBank.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Group gTC = new Group(ret, 0);
        gTC.setText(Messages.RechnungsPrefs_trustcenter);
        gTC.setLayout((Layout)new GridLayout());
        gTC.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bUseTC = new Button((Composite)gTC, 32);
        this.bUseTC.setText(Messages.RechnungsPrefs_TrustCenterUsed);
        this.bUseTC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RechnungsPrefs.this.actMandant.setInfoElement("TarmedUseTC", (Object)(RechnungsPrefs.this.bUseTC.getSelection() ? "1" : "0"));
            }
        });
        this.cbTC = new Combo((Composite)gTC, 0);
        for (String k : TrustCenters.tc.keySet()) {
            this.cbTC.add(k);
        }
        this.cbTC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TarmedRequirements.setTC((Kontakt)RechnungsPrefs.this.actMandant, RechnungsPrefs.this.cbTC.getText());
            }
        });
        Group gResponsible = new Group(ret, 0);
        gResponsible.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gResponsible.setLayout((Layout)new FillLayout());
        gResponsible.setText("Responsible Doctor");
        this.responsible = new ResponsibleComposite((Composite)gResponsible, 0);
        this.addFontsGroup(ret);
        Group gAuto = new Group(ret, 0);
        gAuto.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        gAuto.setLayout((Layout)new FillLayout());
        final Button bAddChildren = new Button((Composite)gAuto, 32);
        bAddChildren.setText("Kinderzuschl\u00e4ge automatisch verrechnen");
        bAddChildren.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.mandantCfg.set(RechnungsPrefs.PREF_ADDCHILDREN, bAddChildren.getSelection());
            }
        });
        bAddChildren.setSelection(CoreHub.mandantCfg.get(PREF_ADDCHILDREN, false));
        this.cbMands.select(0);
        this.setMandant(this.hMandanten.get(this.cbMands.getItem(0)));
        return ret;
    }

    private void addFontsGroup(Composite ret) {
        Group fonts = new Group(ret, 0);
        fonts.setText(Messages.RechnungsPrefs_FontSlip);
        fonts.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        fonts.setLayout((Layout)new GridLayout(2, false));
        FontsTextListener fontsTextListener = new FontsTextListener();
        String warning = String.valueOf(Messages.RechnungsPrefs_FontWarning) + Messages.RechnungsPrefs_FontWarning2 + Messages.RechnungsPrefs_FontWarning3;
        Label lWarning = new Label((Composite)fonts, 0);
        lWarning.setText(warning);
        lWarning.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_Font);
        this.tESRNormalFontName = new Text((Composite)fonts, 2052);
        this.tESRNormalFontName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRNormalFontName.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_Size);
        this.tESRNormalFontSize = new Text((Composite)fonts, 2052);
        this.tESRNormalFontSize.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRNormalFontSize.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_fontCodingLine);
        this.tESROCRFontName = new Text((Composite)fonts, 2052);
        this.tESROCRFontName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESROCRFontName.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_SizeCondingLine);
        this.tESROCRFontSize = new Text((Composite)fonts, 2052);
        this.tESROCRFontSize.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESROCRFontSize.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_Weight);
        this.cbESROCRFontWeight = new Combo((Composite)fonts, 8);
        this.cbESROCRFontWeight.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        this.cbESROCRFontWeight.add(Messages.RechnungsPrefs_light);
        this.cbESROCRFontWeight.add(Messages.RechnungsPrefs_normal);
        this.cbESROCRFontWeight.add(Messages.RechnungsPrefs_bold);
        this.cbESROCRFontWeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RechnungsPrefs.this.storeFontsTextValues();
            }
        });
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_horzCorrCodingLine);
        this.tESRPrinterCorrectionX = new Text((Composite)fonts, 2052);
        this.tESRPrinterCorrectionX.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRPrinterCorrectionX.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_vertCorrCodingLine);
        this.tESRPrinterCorrectionY = new Text((Composite)fonts, 2052);
        this.tESRPrinterCorrectionY.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRPrinterCorrectionY.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungsPrefs_horrzBaseOffset);
        this.tESRPrintCorrectionBaseX = new Text((Composite)fonts, 2052);
        this.tESRPrintCorrectionBaseX.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRPrintCorrectionBaseX.addFocusListener((FocusListener)fontsTextListener);
        new Label((Composite)fonts, 0).setText(Messages.RechnungenPrefs_vertBaseOffset);
        this.tESRPrintCorrectionBaseY = new Text((Composite)fonts, 2052);
        this.tESRPrintCorrectionBaseY.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tESRPrintCorrectionBaseY.addFocusListener((FocusListener)fontsTextListener);
        this.setFontsTextValues();
    }

    public void init(IWorkbench workbench) {
    }

    void setMandant(Mandant m) {
        this.actMandant = m;
        this.tTreat.setText(this.actMandant.getLabel());
        this.cvMandantType.setSelection((ISelection)new StructuredSelection((Object)TarmedLeistung.getMandantType(this.actMandant)));
        this.actBank = Kontakt.load((String)this.actMandant.getInfoString(RechnungsPrefs.ta.RNBANK));
        if (this.actBank != null && this.actBank.isValid()) {
            this.tPost.setText("");
            this.tBank.setText(this.actBank.getLabel());
        } else {
            this.tPost.setText(this.actMandant.getInfoString(RechnungsPrefs.ta.ESRNUMBER));
            this.tBank.setText("");
            this.actBank = null;
        }
        this.bPost.setSelection(this.actBank == null);
        this.bBank.setSelection(this.actBank != null);
        this.bUseTC.setSelection(this.actMandant.getInfoString("TarmedUseTC").equals("1"));
        this.cbTC.setText(TarmedRequirements.getTCName((Kontakt)this.actMandant));
        this.bBillsElec.setSelection(CoreHub.getUserSetting((Kontakt)this.actMandant).get("TarmedBillElectronic", false));
        this.responsible.setMandant(m);
    }

    private void setFontsTextValues() {
        int index;
        String normalFontName = CoreHub.localCfg.get("esr/normalfontname", "OCR-B");
        int normalFontSize = CoreHub.localCfg.get("esr/normalfontsize", 9);
        String ocrFontName = CoreHub.localCfg.get("esr/ocrfontname", "OCR-B-10 BT");
        int ocrFontSize = CoreHub.localCfg.get("esr/ocrfontsize", 12);
        this.tESRNormalFontName.setText(normalFontName);
        this.tESRNormalFontSize.setText(new Integer(normalFontSize).toString());
        this.tESROCRFontName.setText(ocrFontName);
        this.tESROCRFontSize.setText(new Integer(ocrFontSize).toString());
        int ocrFontWeight = CoreHub.localCfg.get("esr/ocrfontweight", 128);
        switch (ocrFontWeight) {
            case 128: {
                index = 0;
                break;
            }
            case 0: {
                index = 1;
                break;
            }
            case 1: {
                index = 2;
                break;
            }
            default: {
                index = 1;
            }
        }
        this.cbESROCRFontWeight.select(index);
        int printerCorrectionX = CoreHub.localCfg.get("esr/printer_correction_x", 0);
        int printerCorrectionY = CoreHub.localCfg.get("esr/printer_correction_y", 0);
        int printerBaseCorrectionX = CoreHub.localCfg.get("esr/printer_base_x", 0);
        int printerBaseCorrectionY = CoreHub.localCfg.get("esr/printer_base_y", 0);
        this.tESRPrinterCorrectionX.setText(new Integer(printerCorrectionX).toString());
        this.tESRPrinterCorrectionY.setText(new Integer(printerCorrectionY).toString());
        this.tESRPrintCorrectionBaseX.setText(Integer.toString(printerBaseCorrectionX));
        this.tESRPrintCorrectionBaseY.setText(new Integer(printerBaseCorrectionY).toString());
    }

    void storeFontsTextValues() {
        int printerBaseCorrectionY;
        int printerBaseCorrectionX;
        int printerCorrectionY;
        int printerCorrectionX;
        int ocrFontWeight;
        int ocrFontSize;
        int normalFontSize;
        String normalFontName = this.tESRNormalFontName.getText().trim();
        if (StringTool.isNothing((Object)normalFontName)) {
            normalFontName = "OCR-B";
        }
        try {
            normalFontSize = Integer.parseInt(this.tESRNormalFontSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            normalFontSize = 9;
        }
        String ocrFontName = this.tESROCRFontName.getText().trim();
        if (StringTool.isNothing((Object)ocrFontName)) {
            ocrFontName = "OCR-B-10 BT";
        }
        try {
            ocrFontSize = Integer.parseInt(this.tESROCRFontSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            ocrFontSize = 12;
        }
        int index = this.cbESROCRFontWeight.getSelectionIndex();
        switch (index) {
            case 0: {
                ocrFontWeight = 128;
                break;
            }
            case 1: {
                ocrFontWeight = 0;
                break;
            }
            case 2: {
                ocrFontWeight = 1;
                break;
            }
            default: {
                ocrFontWeight = 0;
            }
        }
        try {
            printerCorrectionX = Integer.parseInt(this.tESRPrinterCorrectionX.getText().trim());
        }
        catch (NumberFormatException ex) {
            printerCorrectionX = 0;
        }
        try {
            printerCorrectionY = Integer.parseInt(this.tESRPrinterCorrectionY.getText().trim());
        }
        catch (NumberFormatException ex) {
            printerCorrectionY = 0;
        }
        try {
            printerBaseCorrectionX = Integer.parseInt(this.tESRPrintCorrectionBaseX.getText().trim());
        }
        catch (NumberFormatException ex) {
            printerBaseCorrectionX = 0;
        }
        try {
            printerBaseCorrectionY = Integer.parseInt(this.tESRPrintCorrectionBaseY.getText().trim());
        }
        catch (NumberFormatException ex) {
            printerBaseCorrectionY = 0;
        }
        CoreHub.localCfg.set("esr/normalfontname", normalFontName);
        CoreHub.localCfg.set("esr/normalfontsize", normalFontSize);
        CoreHub.localCfg.set("esr/ocrfontname", ocrFontName);
        CoreHub.localCfg.set("esr/ocrfontsize", ocrFontSize);
        CoreHub.localCfg.set("esr/ocrfontweight", ocrFontWeight);
        CoreHub.localCfg.set("esr/printer_correction_x", printerCorrectionX);
        CoreHub.localCfg.set("esr/printer_correction_y", printerCorrectionY);
        CoreHub.localCfg.set("esr/printer_base_x", printerBaseCorrectionX);
        CoreHub.localCfg.set("esr/printer_base_y", printerBaseCorrectionY);
    }

    class BankLister
    extends TitleAreaDialog {
        final String[] flds;
        Label banklabel;
        KontaktExtDialog.ExtInfoTable exTable;

        BankLister(Shell shell) {
            super(shell);
            this.flds = new String[]{Messages.RechnungsPrefs_department, Messages.RechnungsPrefs_POBox, RechnungsPrefs.ta.ESRNUMBER, RechnungsPrefs.ta.ESRSUB};
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(2, false));
            Hyperlink hb = UiDesk.getToolkit().createHyperlink(ret, Messages.RechnungsPrefs_FinanceInst, 0);
            hb.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    KontaktSelektor ksl = new KontaktSelektor(BankLister.this.getShell(), Organisation.class, Messages.RechnungsPrefs_paymentinst, Messages.RechnungsPrefs_PleseChooseBank, new String[]{"Bezeichnung1", "Bezeichnung2"});
                    if (ksl.open() == 0) {
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actBank = (Kontakt)ksl.getSelection();
                        ((BankLister)BankLister.this).RechnungsPrefs.this.actMandant.setInfoElement(RechnungsPrefs.ta.RNBANK, (Object)((BankLister)BankLister.this).RechnungsPrefs.this.actBank.getId());
                        RechnungsPrefs.this.setMandant(((BankLister)BankLister.this).RechnungsPrefs.this.actMandant);
                        BankLister.this.exTable.setKontakt((Kontakt)((BankLister)BankLister.this).RechnungsPrefs.this.actMandant);
                    }
                }
            });
            this.banklabel = new Label(ret, 0);
            this.banklabel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.exTable = new KontaktExtDialog.ExtInfoTable(parent, this.flds);
            this.exTable.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
            this.exTable.setKontakt((Kontakt)RechnungsPrefs.this.actMandant);
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.RechnungsPrefs_ChooseBank);
            this.setTitle(RechnungsPrefs.this.actMandant.getLabel());
            this.setMessage(Messages.RechnungsPrefs_ChosseInst);
        }

        protected void okPressed() {
            super.okPressed();
        }
    }

    class DetailListener
    extends HyperlinkAdapter {
        DetailListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            if (RechnungsPrefs.this.actMandant == null) {
                return;
            }
            KontaktExtDialog dlg = new KontaktExtDialog(RechnungsPrefs.this.getShell(), (Kontakt)RechnungsPrefs.this.actMandant, ExtFlds);
            dlg.create();
            dlg.setTitle(Messages.RechnungsPrefs_MandatorDetails);
            dlg.open();
        }
    }

    class FontsTextListener
    extends FocusAdapter {
        FontsTextListener() {
        }

        public void focusLost(FocusEvent e) {
            RechnungsPrefs.this.storeFontsTextValues();
        }
    }

    class PostDialog
    extends TitleAreaDialog {
        final String[] flds;
        KontaktExtDialog.ExtInfoTable exTable;

        PostDialog(Shell shell) {
            super(shell);
            this.flds = new String[]{RechnungsPrefs.ta.ESRNUMBER};
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(2, false));
            this.exTable = new KontaktExtDialog.ExtInfoTable(parent, this.flds);
            this.exTable.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
            this.exTable.setKontakt((Kontakt)RechnungsPrefs.this.actMandant);
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.RechnungsPrefs_postAccount);
            this.setTitle(RechnungsPrefs.this.actMandant.getLabel());
            this.setMessage(Messages.RechnungsPrefs_InfoPostAccount);
        }

        protected void okPressed() {
            super.okPressed();
        }
    }

    class TextListener
    extends FocusAdapter {
        TextListener() {
        }

        public void focusLost(FocusEvent e) {
            Text t = (Text)e.getSource();
            String fld = (String)t.getData();
            RechnungsPrefs.this.actMandant.setInfoElement(fld, (Object)t.getText());
        }
    }
}

