/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ComplementaryPrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected void createFieldEditors() {
        HourlyWageFieldEditor hourlyWageEditpor = new HourlyWageFieldEditor("arzttarife/complementary/hourlywage", "Stundensatz", this.getFieldEditorParent());
        this.addField((FieldEditor)hourlyWageEditpor);
        BooleanFieldEditor fixToVVG = new BooleanFieldEditor("arzttarife/complementary/fixtovvg", "Nur bei VVG verrechenbar", this.getFieldEditorParent());
        this.addField((FieldEditor)fixToVVG);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.mandantCfg));
        this.setTitle("Komplement\u00e4rmedizin");
    }

    private class HourlyWageFieldEditor
    extends StringFieldEditor {
        private float minValidValue = 0.0f;
        private float maxValidValue = Float.MAX_VALUE;
        private static final int DEFAULT_TEXT_LIMIT = 10;

        public HourlyWageFieldEditor(String name, String labelText, Composite parent) {
            this(name, labelText, parent, 10);
        }

        public HourlyWageFieldEditor(String name, String labelText, Composite parent, int textLimit) {
            this.init(name, labelText);
            this.setTextLimit(textLimit);
            this.setEmptyStringAllowed(true);
            this.setErrorMessage("Kein g\u00fcltiger Wert");
            this.createControl(parent);
        }

        protected boolean checkState() {
            block4: {
                Text text = this.getTextControl();
                if (text == null) {
                    return false;
                }
                String numberString = text.getText().replaceAll(",", ".");
                try {
                    float number = Float.valueOf(numberString).floatValue();
                    if (!(number >= this.minValidValue) || !(number <= this.maxValidValue)) break block4;
                    this.clearErrorMessage();
                    return true;
                }
                catch (NumberFormatException e1) {
                    this.showErrorMessage();
                    return false;
                }
            }
            this.showErrorMessage();
            return false;
        }

        protected void doLoad() {
            Text text = this.getTextControl();
            if (text != null) {
                int value = this.getPreferenceStore().getInt(this.getPreferenceName());
                text.setText("" + (float)value / 100.0f);
                this.oldValue = "" + value;
            }
        }

        protected void doLoadDefault() {
            Text text = this.getTextControl();
            if (text != null) {
                int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
                text.setText("" + (float)value / 100.0f);
            }
            this.valueChanged();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text != null) {
                Float f = Float.valueOf(text.getText().replaceAll(",", "."));
                f = Float.valueOf(f.floatValue() * 100.0f);
                this.getPreferenceStore().setValue(this.getPreferenceName(), f.intValue());
            }
        }
    }
}

