/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.HashSet;
import org.jdom.Document;
import org.jdom.Element;

public class XMLPrinterUtil {
    public static void updateContext(Rechnung rechnung, Fall fall, Patient patient, Mandant mandant, Rechnungssteller rechnungssteller, String paymentMode) {
        Kontakt zuweiser;
        ElexisEventDispatcher.fireSelectionEvents((PersistentObject[])new PersistentObject[]{rechnung, fall, patient, rechnungssteller});
        fall.setInfoString("payment", paymentMode);
        fall.setInfoString("Gesetz", TarmedRequirements.getGesetz(fall));
        mandant.setInfoElement("EAN", (Object)TarmedRequirements.getEAN((Kontakt)mandant));
        rechnungssteller.setInfoElement("EAN", (Object)TarmedRequirements.getEAN((Kontakt)rechnungssteller));
        mandant.setInfoElement("KSK", (Object)TarmedRequirements.getKSK((Kontakt)mandant));
        mandant.setInfoElement("NIF", (Object)TarmedRequirements.getNIF((Kontakt)mandant));
        if (!mandant.equals((Object)rechnungssteller)) {
            rechnungssteller.setInfoElement("EAN", (Object)TarmedRequirements.getEAN((Kontakt)rechnungssteller));
            rechnungssteller.setInfoElement("KSK", (Object)TarmedRequirements.getKSK((Kontakt)rechnungssteller));
            rechnungssteller.setInfoElement("NIF", (Object)TarmedRequirements.getNIF((Kontakt)rechnungssteller));
        }
        if ((zuweiser = fall.getRequiredContact("Zuweiser")) != null) {
            String zsr = (String)zuweiser.getExtInfoStoredObjectByKey((Object)"KSK/ZSR-Nr");
            if (StringTool.isNothing((Object)zsr)) {
                zsr = "X0000.00";
            }
            zuweiser.setExtInfoStoredObjectByKey((Object)"KSK", (Object)zsr);
        }
    }

    public static int guessVatCode(String vatRate) {
        if (vatRate != null && !vatRate.isEmpty()) {
            double scale = Double.parseDouble(vatRate);
            if (scale == 0.0) {
                return 0;
            }
            if (scale < 7.0) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static void insertPage(String templateName, int page, Kontakt adressat, Rechnung rn, Document xmlRn, String paymentMode, TextContainer text) {
        XMLPrinterUtil.createBrief(templateName, adressat, text);
        XMLPrinterUtil.replaceHeaderFields(text, rn, xmlRn, paymentMode);
        text.replace("\\[Seite\\]", StringTool.pad((int)1, (char)'0', (String)Integer.toString(page), (int)2));
    }

    public static Brief createBrief(String template, Kontakt adressat, TextContainer text) {
        return text.createFromTemplateName(null, template, "Rechnung", adressat, Messages.RnPrintView_tarmedBill);
    }

    public static boolean deleteBrief(Brief brief) {
        if (brief != null) {
            return brief.delete();
        }
        return true;
    }

    public static String getEANList(String[] eans) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < eans.length) {
            if (i > 0) {
                sb.append("  ");
            }
            sb.append(String.valueOf(Integer.toString(i + 1)) + "/" + eans[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String[] getEANArray(HashSet<String> responsibleEANs) {
        String[] eans = responsibleEANs.toArray(new String[responsibleEANs.size()]);
        return eans;
    }

    public static HashMap<String, String> getEANHashMap(String[] eans) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int i = 0;
        while (i < eans.length) {
            ret.put(eans[i], Integer.toString(i + 1));
            ++i;
        }
        return ret;
    }

    public static void replaceHeaderFields(TextContainer text, Rechnung rn, Document xmlRn, String paymentMode) {
        String titelMahnung;
        String titel;
        Fall fall = rn.getFall();
        Mandant m = rn.getMandant();
        if (XMLExporter.getXmlVersion(xmlRn.getRootElement()).equals("4.0")) {
            XMLPrinterUtil.replace40HeaderFields(text, rn, xmlRn);
        } else if (XMLExporter.getXmlVersion(xmlRn.getRootElement()).equals("4.4")) {
            XMLPrinterUtil.replace44HeaderFields(text, rn, xmlRn);
        }
        if (paymentMode.equals("TP")) {
            titel = Messages.RnPrintView_tbBill;
            switch (rn.getStatus()) {
                case 6: 
                case 7: {
                    titelMahnung = Messages.RnPrintView_firstM;
                    break;
                }
                case 8: 
                case 9: {
                    titelMahnung = Messages.RnPrintView_secondM;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    titelMahnung = Messages.RnPrintView_thirdM;
                    break;
                }
                default: {
                    titelMahnung = "";
                    break;
                }
            }
        } else {
            titel = Messages.RnPrintView_getback;
            titelMahnung = "";
        }
        text.replace("\\[Titel\\]", titel);
        text.replace("\\[TitelMahnung\\]", titelMahnung);
        if (fall.getAbrechnungsSystem().equals("IV")) {
            text.replace("\\[NIF\\]", TarmedRequirements.getNIF((Kontakt)m));
            String ahv = TarmedRequirements.getAHV((Person)fall.getPatient());
            if (StringTool.isNothing((Object)ahv)) {
                ahv = fall.getRequiredString("AHV-Nummer");
            }
            text.replace("\\[F60\\]", ahv);
        } else {
            text.replace("\\[NIF\\]", TarmedRequirements.getKSK((Kontakt)m));
            text.replace("\\[F60\\]", "");
        }
        text.replace("\\?\\?\\??[a-zA-Z0-9 \\.]+\\?\\?\\??", "");
    }

    private static void replace44HeaderFields(TextContainer text, Rechnung rn, Document xmlRn) {
        Element xmlPayload = xmlRn.getRootElement().getChild("payload", XMLExporter.nsinvoice);
        Element xmlInvoice = xmlPayload.getChild("invoice", XMLExporter.nsinvoice);
        if (xmlInvoice != null) {
            String requestId = xmlInvoice.getAttributeValue("request_id");
            String requestDate = xmlInvoice.getAttributeValue("request_date");
            TimeTool date = new TimeTool(requestDate);
            text.replace("\\[F1\\]", String.valueOf(requestId) + " - " + date.toString(4) + " " + date.toString(2));
        } else {
            text.replace("\\[F1\\]", rn.getRnId());
        }
    }

    private static void replace40HeaderFields(TextContainer text, Rechnung rn, Document xmlRn) {
        text.replace("\\[F1\\]", rn.getRnId());
    }

    public static String getValue(Element s, String field) {
        String ret = s.getAttributeValue(field);
        if (StringTool.isNothing((Object)ret)) {
            return " ";
        }
        return ret;
    }

    public static String getValue(Element s, String field, String defaultValue) {
        String ret = s.getAttributeValue(field);
        if (StringTool.isNothing((Object)ret)) {
            return defaultValue;
        }
        return ret;
    }

    public static Object print(Object cur, ITextPlugin p, int size, int align, boolean bold, String text) {
        if (bold) {
            p.setFont("Helvetica", 1, (float)size);
        } else {
            p.setFont("Helvetica", 0, (float)size);
        }
        return p.insertText(cur, text, align);
    }

    public static Object print(Object cur, ITextPlugin p, boolean small, String text) {
        if (small) {
            p.setFont("Helvetica", 1, 7.0f);
        } else {
            p.setFont("Helvetica", 0, 9.0f);
        }
        return p.insertText(cur, text, 16384);
    }
}

