/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import ch.fd.invoice440.request.RecordDRGType;
import ch.fd.invoice440.request.RecordDrugType;
import ch.fd.invoice440.request.RecordLabType;
import ch.fd.invoice440.request.RecordMigelType;
import ch.fd.invoice440.request.RecordOtherType;
import ch.fd.invoice440.request.RecordParamedType;
import ch.fd.invoice440.request.RecordTarmedType;
import ch.fd.invoice440.request.ServicesType;
import ch.rgw.tools.Money;
import java.util.List;

public class XML44Services {
    private ServicesType services;
    private Money tarmedMoney;
    private Money drugMoney;
    private Money drgMoney;
    private Money migelMoney;
    private Money labMoney;
    private Money paramedMoney;
    private Money otherMoney;
    private Money complementaryMoney;

    public XML44Services(ServicesType services) {
        this.services = services;
        this.tarmedMoney = new Money();
        this.drugMoney = new Money();
        this.drgMoney = new Money();
        this.migelMoney = new Money();
        this.labMoney = new Money();
        this.paramedMoney = new Money();
        this.otherMoney = new Money();
        this.complementaryMoney = new Money();
        this.initMoneyAmounts();
    }

    private void initMoneyAmounts() {
        List serviceRecords = this.services.getRecordTarmedOrRecordDrgOrRecordLab();
        for (Object rec : serviceRecords) {
            if (rec instanceof RecordTarmedType) {
                RecordTarmedType tarmed = (RecordTarmedType)rec;
                this.tarmedMoney.addAmount(tarmed.getAmount());
                continue;
            }
            if (rec instanceof RecordDrugType) {
                RecordDrugType drug = (RecordDrugType)rec;
                this.drugMoney.addAmount(drug.getAmount());
                continue;
            }
            if (rec instanceof RecordDRGType) {
                RecordDRGType drg = (RecordDRGType)rec;
                this.drgMoney.addAmount(drg.getAmount());
                continue;
            }
            if (rec instanceof RecordMigelType) {
                RecordMigelType migel = (RecordMigelType)rec;
                this.migelMoney.addAmount(migel.getAmount());
                continue;
            }
            if (rec instanceof RecordLabType) {
                RecordLabType lab = (RecordLabType)rec;
                this.labMoney.addAmount(lab.getAmount());
                continue;
            }
            if (rec instanceof RecordParamedType) {
                RecordParamedType param = (RecordParamedType)rec;
                this.paramedMoney.addAmount(param.getAmount());
                continue;
            }
            if (!(rec instanceof RecordOtherType)) continue;
            RecordOtherType other = (RecordOtherType)rec;
            String type = other.getTariffType();
            if (type.equals("590")) {
                this.complementaryMoney.addAmount(other.getAmount());
                continue;
            }
            this.otherMoney.addAmount(other.getAmount());
        }
    }

    public Money getTarmedMoney() {
        return this.tarmedMoney;
    }

    public Money getDrugMoney() {
        return this.drugMoney;
    }

    public Money getDrgMoney() {
        return this.drgMoney;
    }

    public Money getMigelMoney() {
        return this.migelMoney;
    }

    public Money getLabMoney() {
        return this.labMoney;
    }

    public Money getParamedMoney() {
        return this.paramedMoney;
    }

    public Money getOtherMoney() {
        return this.otherMoney;
    }

    public Money getComplementaryMoney() {
        return this.complementaryMoney;
    }
}

