/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporterTiers;
import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.tarmed.printer.EZPrinter;
import ch.elexis.tarmed.printer.Rn44Comparator;
import ch.elexis.tarmed.printer.XML44Services;
import ch.elexis.tarmed.printer.XMLPrinterUtil;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.fd.invoice440.request.BalanceType;
import ch.fd.invoice440.request.BodyType;
import ch.fd.invoice440.request.DiagnosisType;
import ch.fd.invoice440.request.GarantType;
import ch.fd.invoice440.request.RecordDRGType;
import ch.fd.invoice440.request.RecordDrugType;
import ch.fd.invoice440.request.RecordLabType;
import ch.fd.invoice440.request.RecordMigelType;
import ch.fd.invoice440.request.RecordOtherType;
import ch.fd.invoice440.request.RecordParamedType;
import ch.fd.invoice440.request.RecordServiceType;
import ch.fd.invoice440.request.RecordTarmedType;
import ch.fd.invoice440.request.ReminderType;
import ch.fd.invoice440.request.RequestType;
import ch.fd.invoice440.request.ServicesType;
import ch.fd.invoice440.request.TreatmentType;
import ch.fd.invoice440.request.VatRateType;
import ch.fd.invoice440.request.VatType;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jdom.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML44Printer {
    private static Logger logger = LoggerFactory.getLogger(XML44Printer.class);
    private static final String FREETEXT = "freetext";
    private static final String BY_CONTRACT = "by_contract";
    private static final String SPACE = " ";
    private static double cmPerLine = 0.67;
    private static double cmFirstPage = 12.0;
    private static double cmMiddlePage = 21.0;
    private static double cmFooter = 4.0;
    private double cmAvail = 21.4;
    private TextContainer text;
    private Brief actBrief;
    private String printer;
    private String tarmedTray;
    private TimeTool tTime;
    private double sideTotal;
    private Fall fall;
    private Patient pat;
    private Mandant rnMandant;
    private Rechnungssteller rnSteller;
    private RequestType request;
    private static DecimalFormat df = new DecimalFormat("0.00");

    public XML44Printer(TextContainer text) {
        this.text = text;
        this.tTime = new TimeTool();
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(custom);
    }

    private EZPrinter.EZPrinterData getEZPrintData(BalanceType balance, ServicesType services, BodyType body) {
        EZPrinter.EZPrinterData ret = new EZPrinter.EZPrinterData();
        XML44Services xmlServices = new XML44Services(services);
        ret.amountTarmed = xmlServices.getTarmedMoney();
        ret.amountDrug = xmlServices.getDrugMoney();
        ret.amountLab = xmlServices.getLabMoney();
        ret.amountMigel = xmlServices.getMigelMoney();
        ret.amountPhysio = xmlServices.getParamedMoney();
        ret.amountUnclassified = xmlServices.getOtherMoney();
        ret.due = new Money(balance.getAmountDue());
        double dReminder = balance.getAmountReminder();
        if (dReminder > 0.0) {
            ret.due.subtractMoney(new Money(dReminder));
        }
        ret.paid = new Money(balance.getAmountPrepaid());
        GarantType eTiers = body.getTiersGarant();
        if (eTiers == null) {
            ret.paymentMode = "TP";
        }
        return ret;
    }

    public boolean doPrint(Rechnung rn, Document xmlRn, IRnOutputter.TYPE rnType, String saveFile, boolean withESR, boolean withForms, boolean doVerify, IProgressMonitor monitor) {
        Mandant mSave = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        monitor.subTask(rn.getLabel());
        if (!this.initBasicInvoiceValues(rn, xmlRn)) {
            return false;
        }
        this.initPrinterSettings();
        BodyType body = this.request.getPayload().getBody();
        BalanceType balance = body.getBalance();
        ServicesType services = body.getServices();
        EZPrinter.EZPrinterData ezData = this.getEZPrintData(balance, services, body);
        String tcCode = null;
        if (TarmedRequirements.hasTCContract((Kontakt)this.rnSteller) && ezData.paymentMode.equals("TG")) {
            tcCode = TarmedRequirements.getTCCode((Kontakt)this.rnSteller);
        } else if (ezData.paymentMode.equals("TP")) {
            tcCode = "01";
        }
        XMLPrinterUtil.updateContext(rn, this.fall, this.pat, this.rnMandant, this.rnSteller, ezData.paymentMode);
        ESR esr = new ESR(this.rnSteller.getInfoString(TarmedACL.getInstance().ESRNUMBER), this.rnSteller.getInfoString(TarmedACL.getInstance().ESRSUB), rn.getRnId(), 27);
        if (withESR) {
            EZPrinter ezPrinter = new EZPrinter();
            this.actBrief = ezPrinter.doPrint(rn, ezData, this.text, esr, monitor);
        }
        if (!withForms) {
            XMLPrinterUtil.deleteBrief(this.actBrief);
            Hub.setMandant((Mandant)mSave);
            return true;
        }
        Kontakt adressat = this.getAddressat(ezData.paymentMode, this.fall);
        XMLPrinterUtil.createBrief("TR44_S1", adressat, this.text);
        if (this.request.getPayload().isCopy()) {
            this.text.replace("\\[F5\\]", Messages.RnPrintView_yes);
        } else {
            this.text.replace("\\[F5\\]", Messages.RnPrintView_no);
        }
        this.addFallSpecificLines();
        this.addDiagnoses(body.getTreatment());
        this.addRemarks(body.getRemark());
        this.addReminderFields(this.request.getPayload().getReminder(), rn.getNr());
        List serviceRecords = services.getRecordTarmedOrRecordDrgOrRecordLab();
        String[] eanArray = this.initEanArray(serviceRecords);
        HashMap<String, String> eanMap = XMLPrinterUtil.getEANHashMap(eanArray);
        this.text.replace("\\[F98\\]", XMLPrinterUtil.getEANList(eanArray));
        SortedList serviceRecordsSorted = new SortedList((Collection)serviceRecords, (Comparator)new Rn44Comparator());
        XMLPrinterUtil.replaceHeaderFields(this.text, rn, xmlRn, ezData.paymentMode);
        this.text.replace("\\[F.+\\]", "");
        Object cursor = this.text.getPlugin().insertText("[Rechnungszeilen]", "\n", 16384);
        int page = 1;
        this.sideTotal = 0.0;
        ITextPlugin tp = this.text.getPlugin();
        this.cmAvail = cmFirstPage;
        monitor.worked(2);
        StringBuilder sb = new StringBuilder();
        for (Object obj : serviceRecordsSorted) {
            tp.setFont("Helvetica", 0, 8.0f);
            sb.setLength(0);
            String recText = "";
            String name = "";
            if (obj instanceof RecordServiceType) {
                RecordServiceType rec = (RecordServiceType)obj;
                recText = this.getRecordServiceString(rec, sb, eanMap);
                name = rec.getName();
            } else if (obj instanceof RecordTarmedType) {
                RecordTarmedType tarmed = (RecordTarmedType)obj;
                recText = this.getTarmedRecordString(tarmed, sb, eanMap);
                name = tarmed.getName();
            }
            if (recText == null) continue;
            cursor = tp.insertText(cursor, recText, 16384);
            tp.setFont("Helvetica", 1, 7.0f);
            cursor = tp.insertText(cursor, "\t" + name + "\n", 16384);
            this.cmAvail -= cmPerLine;
            if (!(this.cmAvail <= cmPerLine)) continue;
            this.addSubTotalLine(cursor, tp, balance, tcCode, esr);
            this.addESRCodeLine(balance, tcCode, esr);
            if (this.needDeadLetterAvoidance(mSave)) {
                return false;
            }
            XMLPrinterUtil.insertPage("TR44_S2", ++page, adressat, rn, xmlRn, ezData.paymentMode, this.text);
            cursor = this.text.getPlugin().insertText("[Rechnungszeilen]", "\n", 16384);
            this.cmAvail = cmMiddlePage;
            monitor.worked(2);
        }
        this.addBalanceLines(cursor, tp, balance, ezData.paid);
        this.addESRCodeLine(balance, tcCode, esr);
        if (this.needDeadLetterAvoidance(mSave)) {
            return false;
        }
        monitor.worked(2);
        XMLPrinterUtil.deleteBrief(this.actBrief);
        Hub.setMandant((Mandant)mSave);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void addReminderFields(ReminderType reminder, String nr) {
        String reminderDate = "";
        String reminderNr = "";
        if (reminder != null) {
            String reminderLevel = reminder.getReminderLevel();
            reminderNr = String.valueOf(nr) + "_m" + reminderLevel;
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
            XMLGregorianCalendar date = reminder.getRequestDate();
            GregorianCalendar cal = date.toGregorianCalendar();
            reminderDate = df.format(cal.getTime());
        }
        this.text.replace("\\[F44.MDatum\\]", reminderDate);
        this.text.replace("\\[F44.MNr\\]", reminderNr);
    }

    private void initPrinterSettings() {
        this.printer = CoreHub.localCfg.get("Drucker/A4/Name", null);
        this.tarmedTray = CoreHub.localCfg.get("Drucker/A4/Schacht", null);
        if (StringTool.isNothing((Object)this.tarmedTray)) {
            this.tarmedTray = null;
        }
    }

    private void addSubTotalLine(Object cursor, ITextPlugin tp, BalanceType balance, String tcCode, ESR esr) {
        StringBuilder footer = new StringBuilder();
        int places = Double.toString(this.sideTotal).indexOf(46);
        if (places > 6) {
            footer.append("\t\t\t\t\t\t\t\t\t\t\t\t\tZwischentotal\t").append(df.format(this.sideTotal));
        } else if (places > 3) {
            footer.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\tZwischentotal\t").append(df.format(this.sideTotal));
        } else {
            footer.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tZwischentotal\t").append(df.format(this.sideTotal));
        }
        tp.setFont("Helvetica", 1, 7.0f);
        cursor = tp.insertText(cursor, footer.toString(), 16384);
        cursor = this.text.getPlugin().insertTextAt(0, 0, 0, 0, "", 16384);
        this.sideTotal = 0.0;
    }

    private void addFallSpecificLines() {
        BodyType body = this.request.getPayload().getBody();
        if (body != null) {
            String gesetzDatum = "Falldatum";
            String gesetzNummer = "Fall-Nr.";
            String gesetzZSRNIF = "ZSR-Nr.(P)";
            if (body.getUvg() != null) {
                gesetzDatum = "Unfalldatum";
                gesetzNummer = "Unfall-Nr.";
            }
            if (body.getIvg() != null) {
                gesetzDatum = "Verf\u00fcgungsdatum";
                gesetzNummer = "Verf\u00fcgungs-Nr.";
                gesetzZSRNIF = "NIF-Nr.(P)";
            }
            String vekaNumber = StringUtils.defaultIfBlank((String)((String)this.fall.getExtInfoStoredObjectByKey((Object)"VEKANr")), (String)"");
            this.text.replace("\\[F44.Datum\\]", gesetzDatum);
            this.text.replace("\\[F44.Nummer\\]", gesetzNummer);
            this.text.replace("\\[F44.FDatum\\]", this.getFDatum(body, this.fall));
            this.text.replace("\\[F44.FNummer\\]", this.getFNummer(body, this.fall));
            this.text.replace("\\[F44.ZSRNIF\\]", gesetzZSRNIF);
            this.text.replace("\\[F44.VEKANr\\]", vekaNumber);
        }
    }

    private String getFDatum(BodyType body, Fall fall) {
        String ret;
        if (body.getUvg() != null && (ret = fall.getInfoString("Unfalldatum")) != null && !ret.isEmpty()) {
            return ret;
        }
        if (body.getIvg() != null && (ret = fall.getInfoString("Verf\u00fcgungsdatum")) != null && !ret.isEmpty()) {
            return ret;
        }
        return fall.getBeginnDatum();
    }

    private String getFNummer(BodyType body, Fall fall) {
        String ret;
        if (body.getUvg() != null) {
            ret = fall.getInfoString("Unfall-Nr.");
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
            ret = fall.getInfoString("Unfallnummer");
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
        }
        if (body.getIvg() != null) {
            ret = fall.getInfoString("Verf\u00fcgungs-Nr.");
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
            ret = fall.getInfoString("Verf\u00fcgungsnummer");
            if (ret != null && !ret.isEmpty()) {
                return ret;
            }
        }
        return fall.getFallNummer();
    }

    private void addRemarks(final String remark) {
        if (remark != null && !remark.isEmpty()) {
            this.text.getPlugin().findOrReplace(Messages.RnPrintView_remark, new ReplaceCallback(){

                public String replace(String in) {
                    return String.valueOf(Messages.RnPrintView_remarksp) + remark;
                }
            });
        }
    }

    private void addESRCodeLine(BalanceType balance, String tcCode, ESR esr) {
        String offenRp = new Money(balance.getAmountDue()).getCentsAsString();
        if (tcCode != null) {
            esr.printESRCodeLine(this.text.getPlugin(), offenRp, tcCode);
        }
    }

    private boolean needDeadLetterAvoidance(Mandant mSave) {
        if (!this.text.getPlugin().print(this.printer, this.tarmedTray, false)) {
            XMLPrinterUtil.deleteBrief(this.actBrief);
            Hub.setMandant((Mandant)mSave);
            return true;
        }
        return false;
    }

    private boolean initBasicInvoiceValues(Rechnung rn, Document xmlRn) {
        this.fall = rn.getFall();
        this.rnMandant = rn.getMandant();
        if (this.fall == null || this.rnMandant == null) {
            logger.error("Fall and/or Mandant of invoice is null");
            return false;
        }
        this.pat = this.fall.getPatient();
        Hub.setMandant((Mandant)this.rnMandant);
        this.rnSteller = this.rnMandant.getRechnungssteller();
        if (this.pat == null || this.rnSteller == null) {
            logger.error("Patient and/or Rechnungssteller is null");
            return false;
        }
        this.request = TarmedJaxbUtil.unmarshalInvoiceRequest440((Document)xmlRn);
        if (this.request == null) {
            logger.error("Could not unmarshall xml document for invoice");
            return false;
        }
        return true;
    }

    private String[] initEanArray(List<Object> serviceRecords) {
        HashSet<String> eanUniqueSet = new HashSet<String>();
        for (Object record : serviceRecords) {
            String responsibleEAN = null;
            String providerEAN = null;
            if (record instanceof RecordServiceType) {
                RecordServiceType recService = (RecordServiceType)record;
                responsibleEAN = recService.getResponsibleId();
                providerEAN = recService.getProviderId();
            } else if (record instanceof RecordTarmedType) {
                RecordTarmedType recTarmed = (RecordTarmedType)record;
                responsibleEAN = recTarmed.getResponsibleId();
                providerEAN = recTarmed.getProviderId();
            }
            if (responsibleEAN != null && !responsibleEAN.isEmpty()) {
                eanUniqueSet.add(responsibleEAN);
            }
            if (providerEAN == null || providerEAN.isEmpty()) continue;
            eanUniqueSet.add(providerEAN);
        }
        return XMLPrinterUtil.getEANArray(eanUniqueSet);
    }

    private String getRecordServiceString(RecordServiceType rec, StringBuilder sb, HashMap<String, String> eanMap) {
        if (rec.getDateBegin() == null) {
            return null;
        }
        this.tTime.set(rec.getDateBegin().toGregorianCalendar());
        sb.append(this.tTime.toString(4)).append("\t");
        sb.append(this.getTarifType(rec)).append("\t");
        String code = rec.getCode();
        sb.append(code).append("\t");
        if (code.length() < 10) {
            String refCode = rec.getRefCode();
            if (refCode == null) {
                refCode = SPACE;
            }
            sb.append(refCode).append("\t");
        }
        sb.append(rec.getSession()).append("\t");
        sb.append(" \t");
        sb.append(rec.getQuantity()).append("\t");
        sb.append(SPACE).append("\t");
        sb.append(SPACE).append("\t");
        sb.append(SPACE).append("\t");
        sb.append(SPACE).append("\t");
        sb.append(SPACE).append("\t");
        sb.append(SPACE).append("\t");
        String providerEAN = rec.getProviderId();
        String responsibleEAN = rec.getResponsibleId();
        if (this.getTarifType(rec) != null) {
            if (providerEAN != null && !providerEAN.isEmpty()) {
                sb.append(String.valueOf(eanMap.get(providerEAN)) + "\t");
            }
            if (responsibleEAN != null && !responsibleEAN.isEmpty()) {
                sb.append(String.valueOf(eanMap.get(responsibleEAN)) + "\t");
            }
        } else {
            sb.append("\t\t");
        }
        if (rec.isObligation()) {
            sb.append("1\t");
        } else {
            sb.append("0\t");
        }
        double amount = rec.getAmount();
        double vatRate = rec.getVatRate();
        sb.append(Integer.toString(XMLPrinterUtil.guessVatCode(String.valueOf(vatRate)))).append("\t");
        sb.append(df.format(amount));
        this.sideTotal += amount;
        sb.append("\n");
        return sb.toString();
    }

    private String getTarmedRecordString(RecordTarmedType tarmed, StringBuilder sb, HashMap<String, String> eanMap) {
        if (tarmed.getDateBegin() == null) {
            return null;
        }
        this.tTime.set(tarmed.getDateBegin().toGregorianCalendar());
        sb.append(this.tTime.toString(4)).append("\t");
        sb.append(tarmed.getTariffType()).append("\t");
        sb.append(tarmed.getCode()).append("\t");
        String refCode = tarmed.getRefCode();
        if (refCode == null) {
            refCode = SPACE;
        }
        sb.append(refCode).append("\t");
        sb.append(tarmed.getSession()).append("\t");
        String bodyLocation = tarmed.getBodyLocation();
        if (bodyLocation.startsWith("l")) {
            sb.append("L\t");
        } else if (bodyLocation.startsWith("r")) {
            sb.append("R\t");
        } else {
            sb.append(" \t");
        }
        sb.append(tarmed.getQuantity()).append("\t");
        sb.append(tarmed.getUnitMt()).append("\t");
        sb.append(tarmed.getScaleFactorMt()).append("\t");
        sb.append(this.roundDouble(tarmed.getUnitFactorMt() * tarmed.getExternalFactorMt())).append("\t");
        sb.append(tarmed.getUnitTt()).append("\t");
        sb.append(tarmed.getScaleFactorTt()).append("\t");
        sb.append(tarmed.getUnitFactorTt()).append("\t");
        String providerEAN = tarmed.getProviderId();
        String responsibleEAN = tarmed.getResponsibleId();
        if (tarmed.getTariffType() != null) {
            if (providerEAN != null && !providerEAN.isEmpty()) {
                sb.append(String.valueOf(eanMap.get(providerEAN)) + "\t");
            }
            if (responsibleEAN != null && !responsibleEAN.isEmpty()) {
                sb.append(String.valueOf(eanMap.get(responsibleEAN)) + "\t");
            }
        } else {
            sb.append("\t\t");
        }
        if (tarmed.isObligation()) {
            sb.append("1\t");
        } else {
            sb.append("0\t");
        }
        double amount = tarmed.getAmount();
        double vatRate = tarmed.getVatRate();
        sb.append(Integer.toString(XMLPrinterUtil.guessVatCode(String.valueOf(vatRate)))).append("\t");
        sb.append(df.format(amount));
        this.sideTotal += amount;
        sb.append("\n");
        return sb.toString();
    }

    private double roundDouble(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    private void addBalanceLines(Object cursor, ITextPlugin tp, BalanceType balance, Money paid) {
        cursor = this.text.getPlugin().insertTextAt(0, 255, 190, 45, SPACE, 16384);
        String balanceHeaders = "Code\tSatz\tBetrag\tMWSt\tMWSt.-Nr.:\t";
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, true, balanceHeaders);
        VatType vat = balance.getVat();
        String vatNumber = vat.getVatNumber();
        vatNumber = vatNumber == null || vatNumber.equals(SPACE) ? "keine" : String.valueOf(vatNumber) + " MWST";
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, String.valueOf(vatNumber) + "\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, true, "Anzahlung:\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, String.valueOf(df.format(paid)) + "\t\t\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, true, "Gesamtbetrag:\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, false, String.valueOf(df.format(balance.getAmount())) + "\n");
        String secondLine = "0\t" + df.format(this.getVatRate(0, vat)) + "\t" + df.format(this.getVatAmount(0, vat)) + "\t" + df.format(this.getVatVat(0, vat)) + "\t";
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, secondLine);
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, true, "W\u00e4hrung:\t\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, "CHF\t");
        if (balance.getAmountReminder() > 0.0) {
            cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, true, "Mahngeb\u00fchr:\t");
            cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, String.valueOf(df.format(balance.getAmountReminder())) + "\t\t\t");
        } else {
            cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, "\t\t\t\t\t");
        }
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, true, "davon PFL:\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, false, String.valueOf(df.format(balance.getAmountObligations())) + "\n");
        String thirdLine = "1\t" + df.format(this.getVatRate(1, vat)) + "\t" + df.format(this.getVatAmount(1, vat)) + "\t" + df.format(this.getVatVat(1, vat)) + "\n";
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, thirdLine);
        String forthLine = "2\t" + df.format(this.getVatRate(2, vat)) + "\t" + df.format(this.getVatAmount(2, vat)) + "\t" + df.format(vat.getVat()) + "\t\t\t\t\t\t\t\t\t";
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 16384, false, forthLine);
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, true, "F\u00e4lliger Betrag:\t");
        cursor = XMLPrinterUtil.print(cursor, tp, 7, 131072, true, String.valueOf(df.format(balance.getAmountDue())) + "\n");
    }

    private void addDiagnoses(TreatmentType treatment) {
        if (treatment == null) {
            logger.debug("no treatments defined");
            return;
        }
        List diagnoses = treatment.getDiagnosis();
        if (diagnoses == null || diagnoses.isEmpty()) {
            logger.warn("No diagnoses found to print at the tarmed invoice request");
            return;
        }
        ArrayList<String> occuredCodes = new ArrayList<String>();
        String type = "";
        String freetext = "";
        StringBuilder dCodesBuilder = new StringBuilder();
        for (DiagnosisType diagnose : diagnoses) {
            String dType = diagnose.getType();
            if (dType.equals(FREETEXT)) {
                freetext = diagnose.getValue();
                continue;
            }
            if (type.isEmpty()) {
                type = dType;
                dCodesBuilder.append(diagnose.getCode());
                occuredCodes.add(diagnose.getCode());
                continue;
            }
            if (!type.equals(dType) || occuredCodes.contains(diagnose.getCode())) continue;
            dCodesBuilder.append("; ");
            dCodesBuilder.append(diagnose.getCode());
            occuredCodes.add(diagnose.getCode());
        }
        if (type.equals(BY_CONTRACT)) {
            type = "TI-Code";
        }
        this.text.replace("\\[F51\\]", type);
        this.text.replace("\\[F52\\]", dCodesBuilder.toString());
        this.text.replace("\\[F53\\]", freetext);
    }

    private String getTarifType(RecordServiceType rec) {
        if (rec instanceof RecordOtherType) {
            RecordOtherType other = (RecordOtherType)rec;
            return other.getTariffType();
        }
        if (rec instanceof RecordDrugType) {
            RecordDrugType drug = (RecordDrugType)rec;
            return drug.getTariffType();
        }
        if (rec instanceof RecordDRGType) {
            RecordDRGType drg = (RecordDRGType)rec;
            return drg.getTariffType();
        }
        if (rec instanceof RecordMigelType) {
            RecordMigelType migel = (RecordMigelType)rec;
            return migel.getTariffType();
        }
        if (rec instanceof RecordLabType) {
            RecordLabType lab = (RecordLabType)rec;
            return lab.getTariffType();
        }
        if (rec instanceof RecordParamedType) {
            RecordParamedType param = (RecordParamedType)rec;
            return param.getTariffType();
        }
        return "";
    }

    private double getVatAmount(int code, VatType vat) {
        VatRateType vatRate = this.getVatRateElement(code, vat);
        if (vatRate != null) {
            return vatRate.getAmount();
        }
        return 0.0;
    }

    private double getVatRate(int code, VatType vat) {
        VatRateType vatRate = this.getVatRateElement(code, vat);
        if (vatRate != null) {
            return vatRate.getVatRate();
        }
        return 0.0;
    }

    private double getVatVat(int code, VatType vat) {
        VatRateType vatRate = this.getVatRateElement(code, vat);
        if (vatRate != null) {
            return vatRate.getVat();
        }
        return 0.0;
    }

    private VatRateType getVatRateElement(int code, VatType vat) {
        List vatRates = vat.getVatRate();
        for (VatRateType vatRate : vatRates) {
            double rate = vatRate.getVatRate();
            int vatCode = XMLPrinterUtil.guessVatCode(String.valueOf(rate));
            if (vatCode != code) continue;
            return vatRate;
        }
        return null;
    }

    private Kontakt getAddressat(String paymentMode, Fall fall) {
        Fall.Tiers tiersType = fall.getTiersType();
        switch (tiersType) {
            case PAYANT: {
                return fall.getCostBearer();
            }
        }
        return XMLExporterTiers.getGuarantor("TG", fall.getPatient(), fall);
    }
}

