/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.tarmed.printer.EZPrinter;
import ch.elexis.tarmed.printer.RnComparator;
import ch.elexis.tarmed.printer.XMLPrinterUtil;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML40Printer {
    private static Logger logger = LoggerFactory.getLogger(XML40Printer.class);
    private static double cmPerLine = 0.67;
    private static double cmFirstPage = 13.0;
    private static double cmMiddlePage = 21.0;
    private static double cmFooter = 4.5;
    private TarmedACL ta = TarmedACL.getInstance();
    private TextContainer text;
    private Brief actBrief;
    private double cmAvail = 21.4;
    private String printer;
    private static DecimalFormat df = new DecimalFormat("0.00");
    private static Namespace namespace = Namespace.getNamespace((String)"http://www.xmlData.ch/xmlInvoice/XSD");

    public XML40Printer(TextContainer text) {
        this.text = text;
    }

    private EZPrinter.EZPrinterData getEZPrintData(Element balance, Element invoice) {
        EZPrinter.EZPrinterData ret = new EZPrinter.EZPrinterData();
        try {
            ret.amountTarmed = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_tarmed"));
            ret.amountDrug = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_drug"));
            ret.amountLab = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_lab"));
            ret.amountMigel = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_migel"));
            ret.amountPhysio = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_physio"));
            ret.amountUnclassified = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_unclassified"));
            ret.due = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_due"));
            ret.paid = XMLTool.xmlDoubleToMoney((String)balance.getAttributeValue("amount_prepaid"));
            Element eTiers = invoice.getChild("tiers_garant", namespace);
            if (eTiers == null) {
                ret.paymentMode = "TP";
            }
        }
        catch (NumberFormatException e) {
            logger.error("Getting data for EZ failed.", (Throwable)e);
        }
        return ret;
    }

    public boolean doPrint(Rechnung rn, Document xmlRn, IRnOutputter.TYPE rnType, String saveFile, boolean withESR, boolean withForms, boolean doVerify, IProgressMonitor monitor) {
        String ean;
        Mandant mSave = CoreHub.actMandant;
        monitor.subTask(rn.getLabel());
        Fall fall = rn.getFall();
        Mandant mnd = rn.getMandant();
        if (fall == null || mnd == null) {
            return false;
        }
        Patient pat = fall.getPatient();
        Hub.setMandant((Mandant)mnd);
        Rechnungssteller rs = mnd.getRechnungssteller();
        if (pat == null || rs == null) {
            return false;
        }
        Element invoice = xmlRn.getRootElement().getChild("invoice", namespace);
        Element balance = invoice.getChild("balance", namespace);
        EZPrinter.EZPrinterData ezData = this.getEZPrintData(balance, invoice);
        String tcCode = null;
        if (TarmedRequirements.hasTCContract((Kontakt)rs) && ezData.paymentMode.equals("TG")) {
            tcCode = TarmedRequirements.getTCCode((Kontakt)rs);
        } else if (ezData.paymentMode.equals("TP")) {
            tcCode = "01";
        }
        XMLPrinterUtil.updateContext(rn, fall, pat, mnd, rs, ezData.paymentMode);
        Object adressat = ezData.paymentMode.equals("TP") ? fall.getCostBearer() : fall.getGarant();
        Kontakt legalGuardian = pat.getLegalGuardian();
        if (adressat == null || !adressat.exists() || legalGuardian != null) {
            adressat = legalGuardian != null ? legalGuardian : pat;
        }
        adressat.getPostAnschrift(true);
        String offenRp = ezData.due.getCentsAsString();
        ESR esr = new ESR(rs.getInfoString(TarmedACL.getInstance().ESRNUMBER), rs.getInfoString(TarmedACL.getInstance().ESRSUB), rn.getRnId(), 27);
        if (withESR) {
            EZPrinter ezPrinter = new EZPrinter();
            this.actBrief = ezPrinter.doPrint(rn, ezData, this.text, esr, monitor);
        }
        if (!withForms) {
            XMLPrinterUtil.deleteBrief(this.actBrief);
            Hub.setMandant((Mandant)mSave);
            return true;
        }
        this.printer = CoreHub.localCfg.get("Drucker/A4/Name", null);
        String tarmedTray = CoreHub.localCfg.get("Drucker/A4/Schacht", null);
        if (StringTool.isNothing((Object)tarmedTray)) {
            tarmedTray = null;
        }
        XMLPrinterUtil.createBrief("Tarmedrechnung_S1", adressat, this.text);
        StringBuilder sb = new StringBuilder();
        Element root = xmlRn.getRootElement();
        Namespace ns = root.getNamespace();
        if (invoice.getAttributeValue("resend").equalsIgnoreCase("true")) {
            this.text.replace("\\[F5\\]", Messages.RnPrintView_yes);
        } else {
            this.text.replace("\\[F5\\]", Messages.RnPrintView_no);
        }
        if (fall.getAbrechnungsSystem().equals("UVG")) {
            this.text.replace("\\[F58\\]", fall.getBeginnDatum());
        } else {
            this.text.replace("\\[F58\\]", "");
        }
        Element detail = invoice.getChild("detail", ns);
        Element diagnosis = detail.getChild("diagnosis", ns);
        String type = diagnosis.getAttributeValue(Messages.RnPrintView_62);
        if (type.equals("by_contract")) {
            type = "TI-Code";
        }
        this.text.replace("\\[F51\\]", type);
        if (type.equals("freetext")) {
            this.text.replace("\\[F52\\]", "");
            this.text.replace("\\[F53\\]", diagnosis.getText());
        } else {
            this.text.replace("\\[F52\\]", diagnosis.getAttributeValue("code"));
            this.text.replace("\\[F53\\]", "");
        }
        HashSet<String> eanUniqueSet = new HashSet<String>();
        List allServices = detail.getChild("services", ns).getChildren();
        for (Object object : allServices) {
            String ean_provider;
            Element service;
            String tariftype;
            if (!(object instanceof Element) || (tariftype = (service = (Element)object).getAttributeValue("tariff_type")) == null || !tariftype.equals("001") && !tariftype.equals("311")) continue;
            String ean_responsible = service.getAttributeValue("ean_responsible");
            if (ean_responsible != null && !ean_responsible.isEmpty()) {
                eanUniqueSet.add(ean_responsible);
            }
            if ((ean_provider = service.getAttributeValue("ean_provider")) == null || ean_provider.isEmpty()) continue;
            eanUniqueSet.add(ean_provider);
        }
        String[] eanArray = XMLPrinterUtil.getEANArray(eanUniqueSet);
        HashMap<String, String> eanMap = XMLPrinterUtil.getEANHashMap(eanArray);
        this.text.replace("\\[F98\\]", XMLPrinterUtil.getEANList(eanArray));
        Kontakt zuweiser = fall.getRequiredContact("Zuweiser");
        if (zuweiser != null && (ean = TarmedRequirements.getEAN(zuweiser)) != null && !ean.equals("2000000000000")) {
            this.text.replace("\\[F23\\]", ean);
        }
        Element services = detail.getChild("services", ns);
        SortedList ls = new SortedList((Collection)services.getChildren(), (Comparator)new RnComparator());
        Element remark = invoice.getChild("remark");
        if (remark != null) {
            final String rem = remark.getText();
            this.text.getPlugin().findOrReplace(Messages.RnPrintView_remark, new ReplaceCallback(){

                public String replace(String in) {
                    return String.valueOf(Messages.RnPrintView_remarksp) + rem;
                }
            });
        }
        XMLPrinterUtil.replaceHeaderFields(this.text, rn, xmlRn, ezData.paymentMode);
        this.text.replace("\\[F.+\\]", "");
        Object cursor = this.text.getPlugin().insertText("[Rechnungszeilen]", "\n", 16384);
        TimeTool r = new TimeTool();
        int page = 1;
        double seitentotal = 0.0;
        double sumPfl = 0.0;
        double sumNpfl = 0.0;
        double sumTotal = 0.0;
        ITextPlugin tp = this.text.getPlugin();
        this.cmAvail = cmFirstPage;
        monitor.worked(2);
        for (Element s : ls) {
            double dLine;
            tp.setFont("Helvetica", 1, 7.0f);
            cursor = tp.insertText(cursor, "\t" + s.getText() + "\n", 16384);
            tp.setFont("Helvetica", 0, 8.0f);
            sb.setLength(0);
            if (!r.set(s.getAttributeValue("date_begin"))) continue;
            sb.append("\u25a0 ");
            sb.append(r.toString(4)).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "tariff_type")).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "code")).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "ref_code")).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "number")).append("\t");
            if (XMLPrinterUtil.getValue(s, "body_location").startsWith("l")) {
                sb.append("L\t");
            } else if (XMLPrinterUtil.getValue(s, "body_location").startsWith("r")) {
                sb.append("R\t");
            } else {
                sb.append(" \t");
            }
            sb.append(XMLPrinterUtil.getValue(s, "quantity")).append("\t");
            String val = s.getAttributeValue("unit.mt");
            if (StringTool.isNothing((Object)val) && StringTool.isNothing((Object)(val = s.getAttributeValue("unit")))) {
                val = "\t";
            }
            sb.append(val).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "scale_factor.mt")).append("\t");
            val = s.getAttributeValue("unit_factor.mt");
            if (StringTool.isNothing((Object)val) && StringTool.isNothing((Object)(val = s.getAttributeValue("unit_factor")))) {
                val = "\t";
            }
            sb.append(val).append("\t");
            sb.append(XMLPrinterUtil.getValue(s, "unit.tt")).append("\t\t");
            sb.append(XMLPrinterUtil.getValue(s, "unit_factor.tt")).append("\t");
            String tariftype = s.getAttributeValue("tariff_type");
            if (tariftype != null && (tariftype.equals("001") || tariftype.equals("311"))) {
                String ean_provider;
                String ean_responsible = s.getAttributeValue("ean_responsible");
                if (ean_responsible != null && !ean_responsible.isEmpty()) {
                    sb.append(String.valueOf(eanMap.get(ean_responsible)) + "\t");
                }
                if ((ean_provider = s.getAttributeValue("ean_provider")) != null && !ean_provider.isEmpty()) {
                    sb.append(String.valueOf(eanMap.get(ean_provider)) + "\t");
                }
            } else {
                sb.append("\t\t");
            }
            String pfl = s.getAttributeValue("obligation");
            String am = s.getAttributeValue("amount");
            try {
                dLine = XMLTool.xmlDoubleToMoney((String)am).getAmount();
            }
            catch (NumberFormatException ex) {
                XMLPrinterUtil.deleteBrief(this.actBrief);
                logger.error("Fehlerhaftes Format f\u00fcr amount bei " + sb.toString());
                Hub.setMandant((Mandant)mSave);
                return false;
            }
            sumTotal += dLine;
            if (pfl.equalsIgnoreCase("true")) {
                sb.append("0\t");
                sumPfl += dLine;
            } else {
                sb.append("1\t");
                sumNpfl += dLine;
            }
            sb.append(Integer.toString(XMLPrinterUtil.guessVatCode(XMLPrinterUtil.getValue(s, "vat_rate")))).append("\t");
            sb.append(am);
            seitentotal += dLine;
            sb.append("\n");
            cursor = tp.insertText(cursor, sb.toString(), 16384);
            this.cmAvail -= cmPerLine;
            if (!(this.cmAvail <= 0.0)) continue;
            StringBuilder footer = new StringBuilder();
            cursor = tp.insertText(cursor, "\n\n", 16384);
            footer.append("\u25a0 Zwischentotal\t\tCHF\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(df.format(seitentotal));
            tp.setFont("Helvetica", 1, 7.0f);
            cursor = tp.insertText(cursor, footer.toString(), 16384);
            seitentotal = 0.0;
            if (tcCode != null) {
                esr.printESRCodeLine(this.text.getPlugin(), offenRp, tcCode);
            }
            if (!this.text.getPlugin().print(this.printer, tarmedTray, false)) {
                XMLPrinterUtil.deleteBrief(this.actBrief);
                Hub.setMandant((Mandant)mSave);
                return false;
            }
            XMLPrinterUtil.insertPage("Tarmedrechnung_S2", ++page, adressat, rn, xmlRn, ezData.paymentMode, this.text);
            cursor = this.text.getPlugin().insertText("[Rechnungszeilen]", "\n", 16384);
            this.cmAvail = cmMiddlePage;
            monitor.worked(2);
        }
        cursor = tp.insertText(cursor, "\n", 16384);
        if (this.cmAvail < cmFooter) {
            if (tcCode != null) {
                esr.printESRCodeLine(this.text.getPlugin(), offenRp, tcCode);
            }
            if (!this.text.getPlugin().print(this.printer, tarmedTray, false)) {
                XMLPrinterUtil.deleteBrief(this.actBrief);
                Hub.setMandant((Mandant)mSave);
                return false;
            }
            XMLPrinterUtil.insertPage("Tarmedrechnung_S2", ++page, adressat, rn, xmlRn, ezData.paymentMode, this.text);
            cursor = this.text.getPlugin().insertText("[Rechnungszeilen]", "\n", 16384);
            monitor.worked(2);
        }
        StringBuilder footer = new StringBuilder(100);
        cursor = this.text.getPlugin().insertTextAt(0, 220, 190, 45, " ", 16384);
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\tTARMED AL \t");
        footer.append(balance.getAttributeValue("amount_tarmed.mt")).append("  (").append(balance.getAttributeValue("unit_tarmed.mt")).append(")\t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, footer.toString());
        cursor = XMLPrinterUtil.print(cursor, tp, true, "Physio \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_physio"));
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\tMiGeL \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_migel"));
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\t\u00dcbrige \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_unclassified"));
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\n\tTARMED TL \t");
        footer.setLength(0);
        footer.append(balance.getAttributeValue("amount_tarmed.tt")).append("  (").append(balance.getAttributeValue("unit_tarmed.tt")).append(")\t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, footer.toString());
        cursor = XMLPrinterUtil.print(cursor, tp, true, "Labor \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_lab"));
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\tMedi \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_drug"));
        cursor = XMLPrinterUtil.print(cursor, tp, true, "\tKantonal \t");
        cursor = XMLPrinterUtil.print(cursor, tp, false, XMLPrinterUtil.getValue(balance, "amount_cantonal"));
        footer.setLength(0);
        footer.append("\n\n").append("\u25a0 Gesamtbetrag\t\tCHF\t\t").append(df.format(sumTotal)).append("\tdavon PFL \t").append(df.format(sumPfl)).append("\tAnzahlung \t").append(ezData.paid.getAmountAsString()).append("\tF\u00e4lliger Betrag \t").append(ezData.due.getAmountAsString());
        Element vat = balance.getChild("vat", ns);
        String vatNumber = XMLPrinterUtil.getValue(vat, "vat_number");
        if (vatNumber.equals(" ")) {
            vatNumber = "keine";
        }
        footer.append("\n\n\u25a0 MwSt.Nr. \t\t");
        cursor = XMLPrinterUtil.print(cursor, tp, true, footer.toString());
        cursor = XMLPrinterUtil.print(cursor, tp, false, String.valueOf(vatNumber) + "\n\n");
        Boolean isVat = (Boolean)mnd.getRechnungssteller().getInfoElement("at.medevit.medelexis.vat_ch/IsMandantVat");
        if (isVat != null && isVat.booleanValue()) {
            cursor = XMLPrinterUtil.print(cursor, tp, true, "  Code\tSatz\t\tBetrag\t\tMwSt\n");
            tp.setFont("Helvetica", 0, 9.0f);
            footer.setLength(0);
            List rates = vat.getChildren();
            ArrayList<String> vatLines = new ArrayList<String>();
            for (Element rate : rates) {
                StringBuilder vatBuilder = new StringBuilder();
                int code = XMLPrinterUtil.guessVatCode(XMLPrinterUtil.getValue(rate, "vat_rate"));
                String amount = XMLPrinterUtil.getValue(rate, "amount");
                String tabs = "\t\t";
                if (amount.length() > 7) {
                    tabs = "\t";
                }
                vatBuilder.append("\u25a0 ").append(Integer.toString(code)).append("\t").append(XMLPrinterUtil.getValue(rate, "vat_rate")).append("\t\t").append(amount).append(tabs).append(XMLPrinterUtil.getValue(rate, "vat")).append("\n");
                if (code == 0) {
                    vatLines.add(0, vatBuilder.toString());
                    continue;
                }
                if (code == 1) {
                    if (vatLines.size() == 2) {
                        vatLines.add(1, vatBuilder.toString());
                        continue;
                    }
                    vatLines.add(vatBuilder.toString());
                    continue;
                }
                if (code != 2) continue;
                vatLines.add(vatBuilder.toString());
            }
            for (String string : vatLines) {
                footer.append(string);
            }
            cursor = XMLPrinterUtil.print(cursor, tp, false, footer.toString());
            cursor = XMLPrinterUtil.print(cursor, tp, true, "\n Total\t\t\t");
            String amount = ezData.due.getAmountAsString();
            String tabs = "\t\t";
            if (amount.length() > 8) {
                tabs = "\t";
            }
            footer.setLength(0);
            footer.append(amount).append(tabs).append(XMLPrinterUtil.getValue(vat, "vat"));
        } else {
            cursor = XMLPrinterUtil.print(cursor, tp, true, "\n Total\t\t");
            footer.setLength(0);
            footer.append(ezData.due.getAmountAsString());
        }
        tp.setFont("Helvetica", 1, 9.0f);
        tp.insertText(cursor, footer.toString(), 16384);
        if (tcCode != null) {
            esr.printESRCodeLine(this.text.getPlugin(), offenRp, tcCode);
        }
        if (!this.text.getPlugin().print(this.printer, tarmedTray, false)) {
            XMLPrinterUtil.deleteBrief(this.actBrief);
            Hub.setMandant((Mandant)mSave);
            return false;
        }
        monitor.worked(2);
        XMLPrinterUtil.deleteBrief(this.actBrief);
        Hub.setMandant((Mandant)mSave);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

