/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import ch.fd.invoice440.request.RecordDRGType;
import ch.fd.invoice440.request.RecordDrugType;
import ch.fd.invoice440.request.RecordLabType;
import ch.fd.invoice440.request.RecordMigelType;
import ch.fd.invoice440.request.RecordOtherType;
import ch.fd.invoice440.request.RecordParamedType;
import ch.fd.invoice440.request.RecordServiceType;
import ch.fd.invoice440.request.RecordTarmedType;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;

public class Rn44Comparator
implements Comparator<Object> {
    private static final String TARMED_TARIF = "001";
    TimeTool time1 = new TimeTool();
    TimeTool time2 = new TimeTool();
    private GregorianCalendar cal1;
    private GregorianCalendar cal2;
    private String tarifType1;
    private String tarifType2;
    private String code1;
    private String code2;
    private String name1;
    private String name2;

    @Override
    public int compare(Object o1, Object o2) {
        this.initRecordValues1(o1);
        this.initRecordValues2(o2);
        if (this.cal1 == null) {
            return 1;
        }
        if (this.cal2 == null) {
            return -1;
        }
        this.time1.set(this.cal1);
        this.time2.set(this.cal2);
        int dat = this.time1.compareTo((Calendar)this.time2);
        if (dat != 0) {
            return dat;
        }
        if (TARMED_TARIF.equals(this.tarifType1)) {
            if (TARMED_TARIF.equals(this.tarifType2)) {
                return this.code1.compareTo(this.code2);
            }
            return -1;
        }
        if (TARMED_TARIF.equals(this.tarifType2)) {
            return 1;
        }
        int diffc = this.tarifType1.compareTo(this.tarifType2);
        if (diffc == 0) {
            diffc = this.name1.compareToIgnoreCase(this.name2);
        }
        return diffc;
    }

    private void initRecordValues1(Object object) {
        this.clearValues();
        if (object instanceof RecordServiceType) {
            RecordServiceType rec = (RecordServiceType)object;
            if (rec.getDateBegin() != null) {
                this.cal1 = rec.getDateBegin().toGregorianCalendar();
            }
            this.tarifType1 = this.getTarifType(rec);
            this.code1 = rec.getCode();
            this.name1 = rec.getName();
        } else if (object instanceof RecordTarmedType) {
            RecordTarmedType tarmed = (RecordTarmedType)object;
            if (tarmed.getDateBegin() != null) {
                this.cal1 = tarmed.getDateBegin().toGregorianCalendar();
            }
            this.tarifType1 = tarmed.getTariffType();
            this.code1 = tarmed.getCode();
            this.name1 = tarmed.getName();
        }
    }

    private void clearValues() {
        this.cal1 = null;
        this.cal2 = null;
        this.tarifType1 = "";
        this.tarifType2 = "";
        this.code1 = "";
        this.code2 = "";
        this.name1 = "";
        this.name2 = "";
    }

    private void initRecordValues2(Object object) {
        if (object instanceof RecordServiceType) {
            RecordServiceType rec = (RecordServiceType)object;
            if (rec.getDateBegin() != null) {
                this.cal2 = rec.getDateBegin().toGregorianCalendar();
            }
            this.tarifType2 = this.getTarifType(rec);
            this.code2 = rec.getCode();
            this.name2 = rec.getName();
        } else if (object instanceof RecordTarmedType) {
            RecordTarmedType tarmed = (RecordTarmedType)object;
            if (tarmed.getDateBegin() != null) {
                this.cal2 = tarmed.getDateBegin().toGregorianCalendar();
            }
            this.tarifType2 = tarmed.getTariffType();
            this.code2 = tarmed.getCode();
            this.name2 = tarmed.getName();
        }
    }

    private String getTarifType(RecordServiceType rec) {
        if (rec instanceof RecordOtherType) {
            RecordOtherType other = (RecordOtherType)rec;
            return other.getTariffType();
        }
        if (rec instanceof RecordDrugType) {
            RecordDrugType drug = (RecordDrugType)rec;
            return drug.getTariffType();
        }
        if (rec instanceof RecordDRGType) {
            RecordDRGType drg = (RecordDRGType)rec;
            return drg.getTariffType();
        }
        if (rec instanceof RecordMigelType) {
            RecordMigelType migel = (RecordMigelType)rec;
            return migel.getTariffType();
        }
        if (rec instanceof RecordLabType) {
            RecordLabType lab = (RecordLabType)rec;
            return lab.getTariffType();
        }
        if (rec instanceof RecordParamedType) {
            RecordParamedType param = (RecordParamedType)rec;
            return param.getTariffType();
        }
        return "";
    }
}

