/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmed.printer;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.Zahlung;
import ch.elexis.tarmed.printer.XMLPrinterUtil;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComplementaryEZPrinter {
    private String printer;

    private Kontakt getAddressee(String paymentMode, Fall fall, Patient patient) {
        Kontakt legalGuardian;
        Kontakt invoiceReceiver;
        Object addressee = paymentMode.equals("TP") ? fall.getCostBearer() : (paymentMode.equals("TG") ? ((invoiceReceiver = fall.getGarant()).equals((Object)patient) ? ((legalGuardian = patient.getLegalGuardian()) != null ? legalGuardian : patient) : invoiceReceiver) : fall.getGarant());
        addressee.getPostAnschrift(true);
        return addressee;
    }

    public Brief doPrint(Rechnung rn, EZPrinterData ezData, TextContainer text, ESR esr, IProgressMonitor monitor) {
        Money mEZDue = new Money(ezData.due);
        mEZDue.addMoney(ezData.paid);
        Fall fall = rn.getFall();
        Patient pat = fall.getPatient();
        Mandant mnd = rn.getMandant();
        Rechnungssteller rs = mnd.getRechnungssteller();
        Kontakt addressee = this.getAddressee(ezData.paymentMode, fall, pat);
        String tmpl = "TR59_EZ";
        Brief actBrief = XMLPrinterUtil.createBrief(tmpl, addressee, text);
        List extra = rn.getZahlungen();
        Kontakt bank = Kontakt.load((String)rs.getInfoString(TarmedACL.getInstance().RNBANK));
        StringBuilder sb = new StringBuilder();
        sb.append("Komplement\u00e4r-Leistungen:\t").append(ezData.amountComplementary.getAmountAsString()).append("\n");
        sb.append(Messages.RnPrintView_otherpoints).append(ezData.amountUnclassified.getAmountAsString()).append("\n");
        for (Zahlung z : extra) {
            Money betrag = new Money(z.getBetrag()).multiply(-1.0);
            if (betrag.isNegative()) continue;
            sb.append(z.getBemerkung()).append(":\t").append(betrag.getAmountAsString()).append("\n");
            mEZDue.addMoney(betrag);
        }
        sb.append("--------------------------------------").append("\n");
        sb.append(Messages.RnPrintView_sum).append(mEZDue);
        if (!ezData.paid.isZero()) {
            sb.append(Messages.RnPrintView_prepaid).append(ezData.paid.getAmountAsString()).append("\n");
            sb.append(Messages.RnPrintView_topay).append(mEZDue.subtractMoney(ezData.paid).roundTo5().getAmountAsString()).append("\n");
        }
        text.getPlugin().setFont("Serif", 0, 9.0f);
        text.replace("\\[Leistungen\\]", sb.toString());
        if (!esr.printBESR(bank, addressee, (Kontakt)rs, mEZDue.roundTo5().getCentsAsString(), text)) {
            return actBrief;
        }
        this.printer = CoreHub.localCfg.get("Drucker/A4ESR/Name", null);
        String esrTray = CoreHub.localCfg.get("Drucker/A4ESR/Schacht", null);
        if (StringTool.isNothing((Object)esrTray)) {
            esrTray = null;
        }
        if (!text.getPlugin().print(this.printer, esrTray, false)) {
            SWTHelper.showError((String)"Fehler beim Drucken", (String)"Konnte den Drucker nicht starten");
            rn.addTrace("Zur\u00fcckgewiesen", "Druckerfehler");
            return actBrief;
        }
        monitor.worked(2);
        return actBrief;
    }

    public static class EZPrinterData {
        Money amountComplementary;
        Money amountUnclassified;
        Money due = new Money();
        Money paid = new Money();
        String paymentMode = "TG";
    }
}

