/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.importer.div.importers.AccessWrapper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.importer.BlockImporter;
import ch.elexis.data.importer.ChapterImporter;
import ch.elexis.data.importer.DefinitionImport;
import ch.elexis.data.importer.DeleteOldData;
import ch.elexis.data.importer.GroupImporter;
import ch.elexis.data.importer.IdsUpdater;
import ch.elexis.data.importer.ServiceImporter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarmedReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static final Logger logger = LoggerFactory.getLogger(TarmedReferenceDataImporter.class);
    public static final String CFG_REFERENCEINFO_AVAILABLE = "ch.elexis.data.importer.TarmedReferenceDataImporter/referenceinfoavailable";
    public static final String ImportPrefix = "TARMED_IMPORT_";
    protected JdbcLink cacheDb = null;
    protected String lang;
    private AccessWrapper aw;
    private String mdbFilename;
    private Set<String> cachedDbTables = null;
    protected boolean updateIDs = false;
    protected boolean showRestartDialog = true;
    protected int chapterCount;
    protected int servicesCount;

    public void suppressRestartDialog() {
        this.showRestartDialog = false;
    }

    @NonNull
    public Class<?> getReferenceDataTypeResponsibleFor() {
        return TarmedLeistung.class;
    }

    public int getCurrentVersion() {
        return TarmedLeistung.getCurrentVersion(this.getLaw());
    }

    public IStatus performImport(@Nullable IProgressMonitor ipm, InputStream input, @Nullable Integer version) {
        if (ipm == null) {
            ipm = new NullProgressMonitor();
        }
        this.cacheDb = new JdbcLink("org.h2.Driver", "jdbc:h2:mem:tarmed_import", "h2");
        this.cacheDb.connect("", "");
        if (this.openAccessDatabase(input) != Status.OK_STATUS || this.deleteCachedAccessTables() != Status.OK_STATUS || this.importAllAccessTables() != Status.OK_STATUS) {
            this.cachedDbTables = null;
            return Status.CANCEL_STATUS;
        }
        ipm.beginTask(Messages.TarmedImporter_importLstg, this.chapterCount + this.servicesCount);
        this.lang = JdbcLink.wrap((String)CoreHub.localCfg.get("ablauf/sprache", "d").toUpperCase());
        ipm.subTask(Messages.TarmedImporter_connecting);
        TarmedLeistung leistung = TarmedLeistung.load("00.0010");
        if (leistung.exists()) {
            this.updateIDs = true;
        }
        IStatus ret = Status.OK_STATUS;
        try {
            try {
                DefinitionImport definitionImport;
                DeleteOldData deleteOldData = this.getDeleteOldData();
                ret = deleteOldData.delete(ipm);
                if (ret.isOK() && (ret = (definitionImport = this.getDefinitionImport()).doImport(ipm)).isOK()) {
                    GroupImporter groupImporter;
                    ChapterImporter chapterImporter = this.getChapterImporter();
                    chapterImporter.setChapterCount(this.chapterCount);
                    ret = chapterImporter.doImport(ipm);
                    if (ret.isOK() && (ret = (groupImporter = this.getGroupImporter()).doImport(ipm)).isOK()) {
                        BlockImporter blockImporter = this.getBlockImporter();
                        blockImporter.doImport(ipm);
                        if (ret.isOK()) {
                            ServiceImporter serviceImporter = this.getServiceImporter(chapterImporter);
                            serviceImporter.setServiceCount(this.servicesCount);
                            ret = serviceImporter.doImport(ipm);
                            if (ret.isOK()) {
                                IStatus updateVerrechnetResult = Status.OK_STATUS;
                                IStatus updateBlockResult = Status.OK_STATUS;
                                IStatus updateStatistics = Status.OK_STATUS;
                                if (this.updateIDs) {
                                    IdsUpdater idsUpdater = new IdsUpdater(this.getLaw());
                                    updateVerrechnetResult = idsUpdater.updateVerrechnet(ipm);
                                    updateBlockResult = idsUpdater.udpateLeistungsBlock(ipm);
                                    updateStatistics = idsUpdater.updateStatistics(ipm);
                                }
                                if (version == null) {
                                    TarmedLeistung.setVersion(new TimeTool().toString(9), this.getLaw());
                                } else {
                                    TarmedLeistung.setVersion(version.toString(), this.getLaw());
                                }
                                CoreHub.globalCfg.set(CFG_REFERENCEINFO_AVAILABLE, true);
                                ipm.done();
                                String message = Messages.TarmedImporter_successMessage;
                                if (!updateBlockResult.isOK()) {
                                    message = String.valueOf(message) + "\n" + Messages.TarmedImporter_updateBlockWarning;
                                }
                                if (this.showRestartDialog) {
                                    SWTHelper.showInfo((String)Messages.TarmedImporter_successTitle, (String)message);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Error importing tarmed", (Throwable)ex);
                if (this.deleteCachedAccessTables() != Status.OK_STATUS) {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        finally {
            if (this.deleteCachedAccessTables() != Status.OK_STATUS) {
                return Status.CANCEL_STATUS;
            }
        }
        return ret;
    }

    protected BlockImporter getBlockImporter() {
        return new BlockImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected GroupImporter getGroupImporter() {
        return new GroupImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected ServiceImporter getServiceImporter(ChapterImporter chapterImporter) {
        return new ServiceImporter(this.cacheDb, chapterImporter, this.lang, this.getLaw());
    }

    protected ChapterImporter getChapterImporter() {
        return new ChapterImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected DefinitionImport getDefinitionImport() {
        return new DefinitionImport(this.cacheDb, this.lang, this.getLaw());
    }

    protected DeleteOldData getDeleteOldData() {
        return new DeleteOldData(this.getLaw());
    }

    protected String getLaw() {
        return "";
    }

    private IStatus importAllAccessTables() {
        String tablename2 = "";
        try {
            this.chapterCount = this.aw.getDatabase().getTable("KAPITEL_TEXT").getRowCount();
            this.servicesCount = this.aw.getDatabase().getTable("LEISTUNG").getRowCount();
            for (String tablename2 : this.cachedDbTables) {
                try {
                    this.aw.convertTable(tablename2, this.cacheDb);
                    this.createIndexForTable(tablename2, this.cacheDb);
                }
                catch (SQLException e) {
                    logger.error("Failed to import table " + tablename2, (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            logger.error("Failed to process access file " + this.mdbFilename, (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    private void createIndexForTable(String tablename, JdbcLink cacheDb) {
        String cacheTableName = ImportPrefix + tablename;
        if ("LEISTUNG_TEXT".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
            this.createIndexOn(cacheTableName, "_IDX2", "SPRACHE");
        } else if ("LEISTUNG_DIGNIQUALI".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_HIERARCHIE".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        } else if ("LEISTUNG_GRUPPEN".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_BLOECKE".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_KOMBINATION".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        } else if ("LEISTUNG_MENGEN_ZEIT".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_KUMULATION".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        }
    }

    private void createIndexOn(String tablename, String indexPrefix, String columnName) {
        JdbcLink.Stm stm = this.cacheDb.getStatement();
        try {
            stm.exec("CREATE INDEX " + tablename + indexPrefix + " on " + tablename + " (" + columnName + ");");
        }
        finally {
            this.cacheDb.releaseStatement(stm);
        }
        logger.debug("Created cache db index [" + tablename + indexPrefix + "] on [" + columnName + "]");
    }

    private IStatus openAccessDatabase(InputStream inputStream) {
        File file = this.convertInputStreamToFile(inputStream);
        if (this.mdbFilename == null) {
            this.mdbFilename = file.getName();
        }
        try {
            this.aw = new AccessWrapper(file);
            this.aw.setPrefixForImportedTableNames(ImportPrefix);
            this.cachedDbTables = this.aw.getDatabase().getTableNames();
        }
        catch (IOException e) {
            logger.error("Failed to open access file " + file, (Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus deleteCachedAccessTables() {
        String tablename2 = "";
        for (String tablename2 : this.cachedDbTables) {
            this.cacheDb.exec("DROP TABLE IF EXISTS " + tablename2);
        }
        return Status.OK_STATUS;
    }

    private File convertInputStreamToFile(InputStream input) {
        String prefix = "tarmed_db";
        String suffix = "tmp";
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(prefix, suffix);
            tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tmpFile);
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error("Error reading input stream ...", (Throwable)e);
        }
        return tmpFile;
    }
}

