/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TarmedLeistungAge {
    private LocalDate validFromDate;
    private LocalDate validToDate;
    private long fromDays;
    private long toDays;
    private String fromText;
    private String toText;

    private TarmedLeistungAge(String datesString, String ageString, LocalDateTime consDate) {
        this.parseDatesString(datesString);
        this.parseAgeString(ageString, consDate);
    }

    private void parseAgeString(String ageString, LocalDateTime consDate) {
        String[] parts = ageString.split("\\|");
        if (parts.length == 5) {
            this.fromDays = this.getAsDays(parts[0], parts[1], parts[4], consDate, false);
            this.fromText = this.getAsText(parts[0], parts[1], parts[4]);
            this.toDays = this.getAsDays(parts[2], parts[3], parts[4], consDate, true);
            this.toText = this.getAsText(parts[2], parts[3], parts[4]);
        } else {
            this.fromDays = -1L;
            this.toDays = -1L;
        }
    }

    private String getAsText(String age, String tolerance, String unit) {
        if (age.equals("-1")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            int ageInt = Integer.parseInt(age);
            if (unit.equals("26")) {
                sb.append(ageInt).append(" Jahre");
            } else if (unit.equals("23")) {
                sb.append(ageInt).append(" Monate");
            }
            int toleanceInt = Integer.parseInt(tolerance);
            sb.append(", ").append(toleanceInt).append(" Tage Toleranz");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sb.toString();
    }

    private long getAsDays(String age, String tolerance, String unit, LocalDateTime consDate, boolean positiveTolerance) {
        if (age.equals("-1")) {
            return -1L;
        }
        try {
            LocalDateTime beforeCons;
            int ageInt = Integer.parseInt(age);
            if (unit.equals("26")) {
                beforeCons = consDate.minus(ageInt, ChronoUnit.YEARS);
                ageInt = (int)ChronoUnit.DAYS.between(beforeCons, consDate);
            } else if (unit.equals("23")) {
                beforeCons = consDate.minus(ageInt, ChronoUnit.MONTHS);
                ageInt = (int)ChronoUnit.DAYS.between(beforeCons, consDate);
            }
            int toleanceInt = Integer.parseInt(tolerance);
            if (positiveTolerance) {
                return ageInt + toleanceInt;
            }
            return ageInt - toleanceInt;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private void parseDatesString(String datesString) {
        String[] parts = datesString.split("\\|");
        if (parts.length == 2) {
            this.validFromDate = LocalDate.parse(parts[0]);
            this.validToDate = LocalDate.parse(parts[1]);
        }
    }

    public boolean isValid() {
        return this.fromDays != -1L || this.toDays != -1L;
    }

    public boolean isValidOn(LocalDate localDate) {
        return !(!this.validFromDate.isBefore(localDate) && !this.validFromDate.isEqual(localDate) || !this.validToDate.isAfter(localDate) && !this.validToDate.isEqual(localDate));
    }

    public static List<TarmedLeistungAge> of(String ages, LocalDateTime consDate) {
        ArrayList<TarmedLeistungAge> ret = new ArrayList<TarmedLeistungAge>();
        if (ages != null && !ages.isEmpty()) {
            String[] singleAge;
            String[] stringArray = singleAge = ages.split(", ");
            int n = singleAge.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] validParts = TarmedLeistungAge.isValidAgeString(string);
                if (validParts != null && validParts.length == 2) {
                    ret.add(new TarmedLeistungAge(validParts[0], validParts[1], consDate));
                } else {
                    LoggerFactory.getLogger(TarmedLeistungAge.class).warn("Could not parse age string [" + string + "]");
                }
                ++n2;
            }
        }
        return ret;
    }

    private static String[] isValidAgeString(String ageDefinition) {
        int dateStart = ageDefinition.indexOf(91);
        String datesString = ageDefinition.substring(dateStart + 1, ageDefinition.length() - 1);
        String ageString = ageDefinition.substring(0, dateStart);
        if (datesString != null && !datesString.isEmpty() && ageString != null && !ageString.isEmpty()) {
            return new String[]{datesString, ageString};
        }
        return null;
    }

    public long getFromDays() {
        return this.fromDays;
    }

    public long getToDays() {
        return this.toDays;
    }

    public String getFromText() {
        return this.fromText;
    }

    public String getToText() {
        return this.toText;
    }

    public String getText() {
        return "ab " + this.getFromText() + " bis " + this.getToText();
    }
}

