/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class ImporterUtil {
    private static DateTimeFormatter tarmedFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss.S");

    public static LocalDate getLocalDate(ResultSet res, String name) throws SQLException {
        return LocalDate.parse(res.getString(name), tarmedFormatter);
    }

    public static LocalDate getLocalDate(Map<String, String> map, String name) {
        return LocalDate.parse(map.get(name), tarmedFormatter);
    }

    public static String getAsString(ResultSet res, String field) throws SQLException, IOException {
        String ret = res.getString(field);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public static List<Map<String, String>> getValidValueMaps(ResultSet input, TimeTool validFrom) throws SQLException, IOException {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        ArrayList<String> headers = new ArrayList<String>();
        ResultSetMetaData meta = input.getMetaData();
        int metaLength = meta.getColumnCount();
        int i = 1;
        while (i <= metaLength) {
            headers.add(meta.getColumnName(i));
            ++i;
        }
        TimeTool from = new TimeTool();
        TimeTool to = new TimeTool();
        while (input.next()) {
            from.set(input.getString("GUELTIG_VON"));
            to.set(input.getString("GUELTIG_BIS"));
            if (!validFrom.isAfterOrEqual(from) || !validFrom.isBeforeOrEqual(to)) continue;
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            for (String columnName : headers) {
                String value = input.getString(columnName);
                valuesMap.put(columnName, value);
            }
            ret.add(valuesMap);
        }
        return ret;
    }

    public static List<Map<String, String>> getAllValueMaps(ResultSet input) throws SQLException, IOException {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        ArrayList<String> headers = new ArrayList<String>();
        ResultSetMetaData meta = input.getMetaData();
        int metaLength = meta.getColumnCount();
        int i = 1;
        while (i <= metaLength) {
            headers.add(meta.getColumnName(i));
            ++i;
        }
        while (input.next()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            for (String columnName : headers) {
                String value = input.getString(columnName);
                valuesMap.put(columnName, value);
            }
            ret.add(valuesMap);
        }
        return ret;
    }

    public static Map<String, String> getLatestMap(List<Map<String, String>> list) {
        TimeTool currFrom = new TimeTool("19000101");
        TimeTool from = new TimeTool();
        Map<String, String> ret = null;
        for (Map<String, String> map : list) {
            from.set(map.get("GUELTIG_VON"));
            if (!from.isAfter(currFrom)) continue;
            currFrom.set(from);
            ret = map;
        }
        return ret;
    }

    public static void putResultSetToMap(Hashtable<String, String> map, ResultSet resultSet, String ... keys) throws SQLException {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String val = resultSet.getString(key);
            if (val != null) {
                map.put(key, val);
            }
            ++n2;
        }
    }
}

