/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.LoggerFactory;

public class IdsUpdater {
    private String law;
    private JdbcLink jdbcLink;

    public IdsUpdater(String law) {
        this.law = law;
        this.jdbcLink = PersistentObject.getDefaultConnection().getJdbcLink();
    }

    public IStatus updateVerrechnet(IProgressMonitor ipm) {
        PreparedStatement ps = null;
        try {
            try {
                ps = this.jdbcLink.getPreparedStatement("UPDATE LEISTUNGEN SET leistg_code=? WHERE id=?");
                Query vQuery = new Query(Verrechnet.class);
                vQuery.add("Klasse", "=", TarmedLeistung.class.getName());
                List verrechnete = vQuery.execute();
                for (Verrechnet verrechnet : verrechnete) {
                    String code = verrechnet.get("Leistg_code");
                    TimeTool date = null;
                    Konsultation kons = verrechnet.getKons();
                    if (kons != null && kons.getDatum() != null) {
                        date = new TimeTool(kons.getDatum());
                    }
                    if (code == null || date == null) continue;
                    ipm.subTask(String.valueOf(Messages.TarmedImporter_updateVerrechnet) + " " + code + " " + date.toString(9));
                    TarmedLeistung leistung = (TarmedLeistung)TarmedLeistung.getFromCode(code, date);
                    if (leistung == null) continue;
                    ps.setString(1, leistung.getId());
                    ps.setString(2, verrechnet.getId());
                    ps.execute();
                }
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error updating ids", (Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                if (ps != null) {
                    this.jdbcLink.releasePreparedStatement(ps);
                }
                return iStatus;
            }
        }
        finally {
            if (ps != null) {
                this.jdbcLink.releasePreparedStatement(ps);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus updateStatistics(IProgressMonitor ipm) {
        Query kQuery = new Query(Kontakt.class);
        List kontakte = kQuery.execute();
        for (Kontakt kontakt : kontakte) {
            String typ;
            Map exi = kontakt.getMap("ExtInfo");
            List l = (List)exi.get(typ = TarmedLeistung.class.getName());
            if (l == null) continue;
            l.clear();
            exi.put(typ, l);
            kontakt.setMap("ExtInfo", exi);
        }
        return Status.OK_STATUS;
    }

    public IStatus udpateLeistungsBlock(IProgressMonitor ipm) {
        IStatus ret = Status.OK_STATUS;
        try {
            Query lQuery = new Query(Leistungsblock.class);
            List blocks = lQuery.execute();
            for (Leistungsblock block : blocks) {
                StringBuilder newCodes = new StringBuilder();
                byte[] compressed = this.getBinaryRaw("Leistungen", "LEISTUNGSBLOCK", block.getId());
                if (compressed == null) continue;
                String storable = new String(CompEx.expand((byte[])compressed), "UTF-8");
                String[] stringArray = storable.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (p != null && !p.isEmpty()) {
                        String[] parts = p.split("::");
                        if (parts[0].equals(TarmedLeistung.class.getName())) {
                            ipm.subTask(String.valueOf(Messages.TarmedImporter_updateBlock) + " " + parts[1]);
                            TarmedLeistung leistung = (TarmedLeistung)TarmedLeistung.getFromCode(parts[1]);
                            if (leistung != null) {
                                if (newCodes.length() > 0) {
                                    newCodes.append(",");
                                }
                                newCodes.append(leistung.storeToString());
                            } else {
                                ret = new Status(2, "", "Update block warning");
                                if (newCodes.length() > 0) {
                                    newCodes.append(",");
                                }
                                newCodes.append(p);
                            }
                        } else {
                            if (newCodes.length() > 0) {
                                newCodes.append(",");
                            }
                            newCodes.append(p);
                        }
                    }
                    ++n2;
                }
                this.setBinaryRaw("Leistungen", "LEISTUNGSBLOCK", block.getId(), CompEx.Compress((String)newCodes.toString(), (int)-1610612736));
            }
        }
        catch (UnsupportedEncodingException e) {
            return Status.CANCEL_STATUS;
        }
        return ret;
    }

    private byte[] getBinaryRaw(String field, String tablename, String id) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(field).append(" FROM ").append(tablename).append(" WHERE ID='").append(id).append("'");
        JdbcLink.Stm stm = null;
        try {
            stm = this.jdbcLink.getStatement();
            ResultSet res = stm.query(sql.toString());
            if (res != null && res.next()) {
                byte[] byArray = res.getBytes(field);
                return byArray;
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting binary", (Throwable)ex);
        }
        finally {
            if (stm != null) {
                this.jdbcLink.releaseStatement(stm);
            }
        }
        return null;
    }

    private void setBinaryRaw(String field, String tablename, String id, byte[] value) {
        StringBuilder sql = new StringBuilder(1000);
        sql.append("UPDATE ").append(tablename).append(" SET ").append(field).append("=?").append(" WHERE ID='").append(id).append("'");
        String cmd = sql.toString();
        PreparedStatement stm = this.jdbcLink.getPreparedStatement(cmd);
        try {
            try {
                stm.setBytes(1, value);
                stm.executeUpdate();
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Error setting binary", (Throwable)ex);
                this.jdbcLink.releasePreparedStatement(stm);
            }
        }
        finally {
            this.jdbcLink.releasePreparedStatement(stm);
        }
    }
}

