/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.importer.ImporterUtil;
import ch.elexis.data.importer.ServiceImporter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupImporter {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;
    private TimeTool validFrom;
    private TimeTool validTo;
    private HashMap<String, TransientTarmedGroup> loadedGroups;

    public GroupImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
        this.validFrom = new TimeTool();
        this.validTo = new TimeTool();
        this.loadedGroups = new HashMap();
    }

    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        JdbcLink.Stm servicesStm = null;
        try {
            ipm.subTask("Importiere Gruppen");
            servicesStm = this.cacheDb.getStatement();
            ResultSet res = servicesStm.query(String.format("SELECT * FROM %sLEISTUNG_GRUPPEN", "TARMED_IMPORT_"));
            while (res.next()) {
                String groupName = res.getString("GRUPPE");
                String serviceCode = res.getString("LNR");
                this.initValidTime(res);
                String id = this.getIdString(groupName, this.law);
                TransientTarmedGroup transientGroup = this.loadedGroups.get(id);
                if (transientGroup == null) {
                    transientGroup = new TransientTarmedGroup(id, groupName, this.law, this.validFrom, this.validTo, this);
                    this.loadedGroups.put(id, transientGroup);
                }
                transientGroup.addService(serviceCode);
            }
            for (String key : this.loadedGroups.keySet()) {
                TransientTarmedGroup transientGroup = this.loadedGroups.get(key);
                TarmedGroup group = transientGroup.persist();
                logger.debug("Imported " + group.getLabel());
            }
        }
        finally {
            if (servicesStm != null) {
                this.cacheDb.releaseStatement(servicesStm);
            }
        }
        return Status.OK_STATUS;
    }

    private void initValidTime(ResultSet res) throws SQLException {
        this.validFrom.set(res.getString("GUELTIG_VON"));
        this.validTo.set(res.getString("GUELTIG_BIS"));
    }

    private String getIdString(String groupName, String law) {
        return "GRP" + groupName + "-" + this.validFrom.toString(9) + this.getLawIdExtension();
    }

    private String getLawIdExtension() {
        if (this.law != null && !this.law.isEmpty()) {
            return "-" + this.law;
        }
        return "";
    }

    private static class TransientTarmedGroup {
        private String id;
        private String code;
        private String law;
        private StringBuilder services;
        private String validFrom;
        private String validTo;
        private GroupImporter importer;

        public TransientTarmedGroup(String id, String groupName, String law, TimeTool validFrom, TimeTool validTo, GroupImporter importer) {
            this.id = id;
            this.code = groupName;
            this.law = law;
            this.validFrom = validFrom.toString(9);
            this.validTo = validTo.toString(9);
            this.services = new StringBuilder();
            this.importer = importer;
        }

        public TarmedGroup persist() throws SQLException, IOException {
            TarmedGroup persistent = new TarmedGroup(this.id, this.code, this.law, this.validFrom, this.validTo, this.services.toString());
            Hashtable<String, String> extensionMap = persistent.loadExtension();
            String limits = this.getLimits(this.code);
            extensionMap.put("limits", limits);
            this.importKumulations(this.code);
            persistent.setExtension(extensionMap);
            return persistent;
        }

        public void addService(String serviceCode) {
            if (this.services.length() > 0) {
                this.services.append(TarmedGroup.SERVICES_SEPARATOR);
            }
            this.services.append(serviceCode);
        }

        private String getLimits(String groupName) throws SQLException, IOException {
            StringBuilder sb = new StringBuilder();
            JdbcLink.Stm subStm = this.importer.cacheDb.getStatement();
            try {
                ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_MENGEN_ZEIT WHERE LNR=%s AND ART='G'", "TARMED_IMPORT_", JdbcLink.wrap((String)groupName)));
                List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, new TimeTool(this.validFrom));
                if (!validResults.isEmpty()) {
                    for (Map<String, String> map : validResults) {
                        sb.append(map.get("OPERATOR")).append(",");
                        sb.append(map.get("MENGE")).append(",");
                        sb.append(map.get("ZR_ANZAHL")).append(",");
                        sb.append(map.get("PRO_NACH")).append(",");
                        sb.append(map.get("ZR_EINHEIT")).append(",");
                        sb.append(map.get("REGEL_EL_ABR")).append("#");
                    }
                }
                rsub.close();
            }
            finally {
                if (subStm != null) {
                    this.importer.cacheDb.releaseStatement(subStm);
                }
            }
            return sb.toString();
        }

        private void importKumulations(String groupName) throws SQLException {
            JdbcLink.Stm subStm = this.importer.cacheDb.getStatement();
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ResultSet res = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KUMULATION WHERE LNR_MASTER=%s AND ART_MASTER='G'", "TARMED_IMPORT_", JdbcLink.wrap((String)groupName)));){
                    TimeTool fromTime = new TimeTool();
                    TimeTool toTime = new TimeTool();
                    while (res != null && res.next()) {
                        fromTime.set(res.getString("GUELTIG_VON"));
                        toTime.set(res.getString("GUELTIG_BIS"));
                        new TarmedKumulation(groupName, res.getString("ART_MASTER"), res.getString("LNR_SLAVE"), res.getString("ART_SLAVE"), res.getString("TYP"), res.getString("ANZEIGE"), res.getString("GUELTIG_SEITE"), fromTime.toString(9), toTime.toString(9), this.law);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (subStm != null) {
                    this.importer.cacheDb.releaseStatement(subStm);
                }
            }
        }
    }
}

