/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.ComplementaryLeistung;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplementaryReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static final Logger logger = LoggerFactory.getLogger(ComplementaryReferenceDataImporter.class);
    private int chapternr_index = 4;
    private int chaptertext_index = 5;
    private int code_index = 8;
    private int codetext_index = 9;
    private int description_index = 12;
    private int validfrom_index = 15;
    private int validto_index = 16;
    private DateTimeFormatter csvDateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private DateTimeFormatter elexisDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public Class<?> getReferenceDataTypeResponsibleFor() {
        return ComplementaryLeistung.class;
    }

    public IStatus performImport(@Nullable IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CSVReader reader = new CSVReader((Reader)new InputStreamReader(input, "ISO-8859-1"), ';');
            monitor.beginTask("Import Complementary", -1);
            if (PersistentObject.tableExists((String)"CH_ELEXIS_ARZTTARIFE_CH_COMPLEMENTARY")) {
                JdbcLink.Stm statement = null;
                try {
                    statement = PersistentObject.getDefaultConnection().getJdbcLink().getStatement();
                    statement.exec("DELETE FROM CH_ELEXIS_ARZTTARIFE_CH_COMPLEMENTARY WHERE ID NOT LIKE '%sub%'");
                }
                finally {
                    if (statement != null) {
                        PersistentObject.getDefaultConnection().getJdbcLink().releaseStatement(statement);
                    }
                }
            }
            try {
                this.updateIndexForLang();
                String[] line = reader.readNext();
                while ((line = reader.readNext()) != null) {
                    if (line.length < this.validto_index + 1 || line[0] == null || line[0].isEmpty() || !"590".equals(line[0])) continue;
                    monitor.subTask(line[this.codetext_index]);
                    String validFromString = this.getValidDateString(line[this.validfrom_index]);
                    String validToString = this.getValidDateString(line[this.validto_index]);
                    String chapterString = String.valueOf(line[this.chapternr_index]) + " " + line[this.chaptertext_index];
                    String id = String.valueOf(line[this.code_index]) + "-" + validFromString;
                    new ComplementaryLeistung(id, chapterString, line[this.code_index], line[this.codetext_index], line[this.description_index], validFromString, validToString);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (IOException ioe) {
                logger.error("Could not import complementary tarif", (Throwable)ioe);
                return Status.CANCEL_STATUS;
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not import complementary tarif", (Throwable)uee);
            return Status.CANCEL_STATUS;
        }
    }

    private String getValidDateString(String string) {
        LocalDate date = LocalDate.parse(string, this.csvDateTimeFormatter);
        return this.elexisDateTimeFormatter.format(date);
    }

    private void updateIndexForLang() {
        String lang = JdbcLink.wrap((String)CoreHub.localCfg.get("ablauf/sprache", "d").toUpperCase());
        int offset = 0;
        if ("I".equals(lang)) {
            offset = 2;
        } else if ("F".equals(lang)) {
            offset = 1;
        }
        this.codetext_index += offset;
        this.chaptertext_index += offset;
        this.description_index += offset;
    }

    public int getCurrentVersion() {
        return 0;
    }
}

