/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.importer.ImporterUtil;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChapterImporter {
    private static final Logger logger = LoggerFactory.getLogger(ChapterImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;
    private int chapterCount;
    private HashMap<String, List<TarmedLeistung>> importedChapters;
    private TimeTool validFrom;
    private TimeTool validTo;

    public ChapterImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
        this.importedChapters = new HashMap();
        this.validFrom = new TimeTool();
        this.validTo = new TimeTool();
    }

    public void setChapterCount(int count) {
        this.chapterCount = count;
    }

    /*
     * Unable to fully structure code
     */
    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        source = null;
        try {
            ipm.subTask(Messages.TarmedImporter_chapter);
            source = this.cacheDb.getStatement();
            var3_3 = null;
            var4_5 = null;
            try {
                res = source.query(String.format("SELECT * FROM %sKAPITEL_TEXT WHERE SPRACHE=%s", new Object[]{"TARMED_IMPORT_", this.lang}));
                try {
                    count = 0;
                    while (res != null && res.next()) {
                        code = res.getString("KNR");
                        if (code.trim().equals("I")) continue;
                        this.validFrom.set(res.getString("GUELTIG_VON"));
                        this.validTo.set(res.getString("GUELTIG_BIS"));
                        subcap = code.lastIndexOf(46);
                        parentId = "NIL";
                        if (subcap != -1) {
                            parentCode = code.substring(0, subcap);
                            parentId = this.getParentId(parentCode);
                        }
                        id = this.getId(res);
                        tl = new TarmedLeistung(id, code, parentId, "", "", "", true);
                        text = ImporterUtil.getAsString(res, "BEZ_255");
                        tl.set(new String[]{"Text", "GueltigVon", "GueltigBis", "Law"}, new String[]{text, this.validFrom.toString(9), this.validTo.toString(9), this.law});
                        ipm.subTask(String.valueOf(Messages.TarmedImporter_chapter) + " (" + count++ + "/" + this.chapterCount + ")");
                        this.addToImportedChapters(tl);
                        ipm.worked(1);
                        if (!ipm.isCanceled()) continue;
                        var14_15 = Status.CANCEL_STATUS;
                        while (true) {
                            if (source != null) {
                                this.cacheDb.releaseStatement(source);
                            }
                            return var14_15;
                        }
                    }
                }
                finally {
                    if (res == null) ** continue;
                    res.close();
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                throw var3_3;
            }
        }
        finally {
            if (source != null) {
                this.cacheDb.releaseStatement(source);
            }
        }
        return Status.OK_STATUS;
    }

    private void addToImportedChapters(TarmedLeistung tl) {
        String code = tl.getCode();
        List<TarmedLeistung> list = this.importedChapters.get(code);
        if (list == null) {
            list = new ArrayList<TarmedLeistung>();
        }
        list.add(tl);
        list.sort((l, r) -> l.getGueltigVon().compareTo((Calendar)r.getGueltigVon()));
        this.importedChapters.put(code, list);
        logger.debug("Imported " + tl.getLabel());
    }

    private String getParentId(String parentCode) throws SQLException {
        JdbcLink.Stm source = null;
        ArrayList<TimeTool> parentValidFroms = new ArrayList<TimeTool>();
        try {
            source = this.cacheDb.getStatement();
            Throwable throwable = null;
            Object var5_6 = null;
            try (ResultSet res = source.query(String.format("SELECT * FROM %sKAPITEL_TEXT WHERE SPRACHE=%s AND KNR=%s", "TARMED_IMPORT_", this.lang, JdbcLink.wrap((String)parentCode)));){
                while (res != null && res.next()) {
                    String code = res.getString("KNR");
                    if (code.trim().equals("I")) continue;
                    parentValidFroms.add(new TimeTool(res.getString("GUELTIG_VON")));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (source != null) {
                this.cacheDb.releaseStatement(source);
            }
        }
        if (parentValidFroms.isEmpty()) {
            throw new IllegalStateException("No parent valid from found for " + parentCode);
        }
        TimeTool latestParentValidFrom = null;
        for (TimeTool parentValidFrom : parentValidFroms) {
            if (latestParentValidFrom == null && parentValidFrom.isBeforeOrEqual(this.validFrom)) {
                latestParentValidFrom = parentValidFrom;
                continue;
            }
            if (!parentValidFrom.isBeforeOrEqual(this.validTo) || !parentValidFrom.isAfter(latestParentValidFrom)) continue;
            latestParentValidFrom = parentValidFrom;
        }
        if (latestParentValidFrom == null) {
            throw new IllegalStateException("No parent valid from found for " + parentCode + " in " + parentValidFroms.size() + " values");
        }
        return String.valueOf(parentCode) + "-" + latestParentValidFrom.toString(9) + this.getLawIdExtension();
    }

    private String getId(ResultSet res) throws SQLException {
        return String.valueOf(res.getString("KNR")) + "-" + this.validFrom.toString(9) + this.getLawIdExtension();
    }

    private String getLawIdExtension() {
        if (this.law != null && !this.law.isEmpty()) {
            return "-" + this.law;
        }
        return "";
    }

    public String getIdForCode(String lookupCode, TimeTool lookupValidFrom, String lookupLaw) {
        List<TarmedLeistung> list = this.importedChapters.get(lookupCode);
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                return list.get(0).getId();
            }
            for (TarmedLeistung tarmedLeistung : list) {
                String currLaw = tarmedLeistung.get("Law");
                TimeTool currValidFrom = tarmedLeistung.getGueltigVon();
                if (!currValidFrom.isAfterOrEqual(lookupValidFrom) || !currLaw.equals(lookupLaw)) continue;
                return tarmedLeistung.getId();
            }
            TarmedLeistung latestLeistung = list.get(list.size() - 1);
            String latestLaw = latestLeistung.get("Law");
            if (latestLaw.equals(lookupLaw)) {
                return latestLeistung.getId();
            }
        }
        return null;
    }
}

