/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.importer;

import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.importer.ServiceImporter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockImporter {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;

    public BlockImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
    }

    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        JdbcLink.Stm servicesStm = null;
        try {
            ipm.subTask("Importiere Bl\u00f6cke");
            servicesStm = this.cacheDb.getStatement();
            ResultSet res = servicesStm.query(String.format("SELECT DISTINCT BLOCK FROM %sLEISTUNG_BLOECKE", "TARMED_IMPORT_"));
            while (res.next()) {
                String blockName = res.getString("BLOCK");
                this.importKumulations(blockName);
                logger.debug("Imported block " + blockName);
            }
        }
        finally {
            if (servicesStm != null) {
                this.cacheDb.releaseStatement(servicesStm);
            }
        }
        return Status.OK_STATUS;
    }

    private void importKumulations(String blockName) throws SQLException {
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet res = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KUMULATION WHERE LNR_MASTER=%s AND ART_MASTER='B'", "TARMED_IMPORT_", JdbcLink.wrap((String)blockName)));){
                TimeTool fromTime = new TimeTool();
                TimeTool toTime = new TimeTool();
                while (res != null && res.next()) {
                    fromTime.set(res.getString("GUELTIG_VON"));
                    toTime.set(res.getString("GUELTIG_BIS"));
                    new TarmedKumulation(blockName, res.getString("ART_MASTER"), res.getString("LNR_SLAVE"), res.getString("ART_SLAVE"), res.getString("TYP"), res.getString("ANZEIGE"), res.getString("GUELTIG_SEITE"), fromTime.toString(9), toTime.toString(9), this.law);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
    }
}

