/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.TarmedExclusion;
import ch.elexis.data.TarmedExclusive;
import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.TarmedLimitation;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.importer.TarmedLeistungAge;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class TarmedOptifier
implements IOptifier {
    private static final String TL = "TL";
    private static final String AL = "AL";
    private static final String AL_NOTSCALED = "AL_NOTSCALED";
    private static final String AL_SCALINGFACTOR = "AL_SCALINGFACTOR";
    public static final int OK = 0;
    public static final int PREISAENDERUNG = 1;
    public static final int KUMULATION = 2;
    public static final int KOMBINATION = 3;
    public static final int EXKLUSION = 4;
    public static final int INKLUSION = 5;
    public static final int LEISTUNGSTYP = 6;
    public static final int NOTYETVALID = 7;
    public static final int NOMOREVALID = 8;
    public static final int PATIENTAGE = 9;
    public static final int EXKLUSIVE = 10;
    public static final int EXKLUSIONSIDE = 11;
    private static final String CHAPTER_XRAY = "39.02";
    private static final String DEFAULT_TAX_XRAY_ROOM = "39.2000";
    boolean bOptify = true;
    private Verrechnet newVerrechnet;
    private String newVerrechnetSide;
    private Map<String, Object> contextMap;

    public Result<Object> optify(Konsultation kons) {
        LinkedList<TarmedLeistung> postponed = new LinkedList<TarmedLeistung>();
        for (Verrechnet vv : kons.getLeistungen()) {
            TarmedLeistung tl;
            String tcid;
            IVerrechenbar iv = vv.getVerrechenbar();
            if (!(iv instanceof TarmedLeistung) || !(tcid = (tl = (TarmedLeistung)iv).getCode()).equals("35.0020") && !tcid.equals("04.1930") && !tcid.startsWith("00.25")) continue;
            postponed.add(tl);
        }
        return null;
    }

    public synchronized void putContext(String key, Object value) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap<String, Object>();
        }
        this.contextMap.put(key, value);
    }

    public void clearContext() {
        if (this.contextMap != null) {
            this.contextMap.clear();
        }
    }

    public Result<IVerrechenbar> add(IVerrechenbar code, Konsultation kons) {
        String tlc;
        TarmedLeistung tl;
        Result<IVerrechenbar> limitResult;
        if (!(code instanceof TarmedLeistung)) {
            return new Result(Result.SEVERITY.ERROR, 6, Messages.TarmedOptifier_BadType, null, true);
        }
        this.bOptify = CoreHub.userCfg.get("billing/optify", true);
        TarmedLeistung tc = (TarmedLeistung)code;
        List lst = kons.getLeistungen();
        Hashtable<String, String> ext = tc.loadExtension();
        if (this.bOptify) {
            Object errorMessage;
            TimeTool tBis;
            TimeTool tVon;
            TimeTool date = new TimeTool(kons.getDatum());
            String dVon = ((TarmedLeistung)code).get("GueltigVon");
            if (!StringTool.isNothing((Object)dVon) && date.isBefore(tVon = new TimeTool(dVon))) {
                return new Result(Result.SEVERITY.WARNING, 7, String.valueOf(code.getCode()) + Messages.TarmedOptifier_NotYetValid, null, false);
            }
            String dBis = ((TarmedLeistung)code).get("GueltigBis");
            if (!StringTool.isNothing((Object)dBis) && date.isAfter(tBis = new TimeTool(dBis))) {
                return new Result(Result.SEVERITY.WARNING, 8, String.valueOf(code.getCode()) + Messages.TarmedOptifier_NoMoreValid, null, false);
            }
            String ageLimits = ext.get("ServiceAge");
            if (ageLimits != null && !ageLimits.isEmpty() && (errorMessage = this.checkAge(ageLimits, kons)) != null) {
                return new Result(Result.SEVERITY.WARNING, 9, (String)errorMessage, null, false);
            }
        }
        this.newVerrechnet = null;
        this.newVerrechnetSide = null;
        if (tc.getCode().matches("39.002[01]") || tc.getCode().matches("39.001[0156]")) {
            String gesetz = kons.getFall().getConfiguredBillingSystemLaw().name();
            if (gesetz == null || gesetz.isEmpty()) {
                gesetz = kons.getFall().getAbrechnungsSystem();
            }
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0011")) {
                return this.add(this.getKonsVerrechenbar("39.0010", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0010")) {
                return this.add(this.getKonsVerrechenbar("39.0011", kons), kons);
            }
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0016")) {
                return this.add(this.getKonsVerrechenbar("39.0015", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0015")) {
                return this.add(this.getKonsVerrechenbar("39.0016", kons), kons);
            }
            if (gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0021")) {
                return this.add(this.getKonsVerrechenbar("39.0020", kons), kons);
            }
            if (!gesetz.equalsIgnoreCase("KVG") && tc.getCode().matches("39.0020")) {
                return this.add(this.getKonsVerrechenbar("39.0021", kons), kons);
            }
        }
        if (tc.getCode().matches("35.0020")) {
            Object opReduction;
            List<Verrechnet> opCodes = this.getOPList(lst);
            List<Verrechnet> availableCodes = this.updateOPReductions(opCodes, (List<Verrechnet>)(opReduction = this.getVerrechnetMatchingCode(lst, "35.0020")));
            if (availableCodes.isEmpty()) {
                return new Result(Result.SEVERITY.WARNING, 3, code.getCode(), null, false);
            }
            for (Verrechnet verrechnet : availableCodes) {
                this.newVerrechnet = new Verrechnet((IVerrechenbar)tc, kons, 1);
                this.mapOpReduction(verrechnet, this.newVerrechnet);
            }
            return new Result(null);
        }
        for (Verrechnet v : lst) {
            if (!v.isInstance(code) || tc.requiresSide()) continue;
            this.newVerrechnet = v;
            this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() + 1);
            break;
        }
        if (tc.requiresSide()) {
            this.newVerrechnetSide = this.getNewVerrechnetSideOrIncrement(code, lst);
        }
        if (this.newVerrechnet == null) {
            this.newVerrechnet = new Verrechnet(code, kons, 1);
            if (tc.requiresSide()) {
                this.newVerrechnet.setDetail("Seite", this.newVerrechnetSide);
            }
            if (this.bOptify) {
                TarmedLeistung newTarmed = (TarmedLeistung)code;
                for (Verrechnet v : lst) {
                    Object tarmed;
                    if (!(v.getVerrechenbar() instanceof TarmedLeistung) || (tarmed = (TarmedLeistung)v.getVerrechenbar()) == null || !tarmed.exists()) continue;
                    Iterator<Verrechnet> resCompatible = this.isCompatible(v, (TarmedLeistung)((Object)tarmed), this.newVerrechnet, newTarmed, kons);
                    if (resCompatible.isOK()) {
                        resCompatible = this.isCompatible(this.newVerrechnet, newTarmed, v, (TarmedLeistung)((Object)tarmed), kons);
                    }
                    if (resCompatible.isOK()) continue;
                    this.newVerrechnet.delete();
                    return resCompatible;
                }
                if (this.newVerrechnet.getCode().equals("00.0750") || this.newVerrechnet.getCode().equals("00.0010")) {
                    String excludeCode = null;
                    excludeCode = this.newVerrechnet.getCode().equals("00.0010") ? "00.0750" : "00.0010";
                    for (Verrechnet v : lst) {
                        if (!v.getCode().equals(excludeCode)) continue;
                        this.newVerrechnet.delete();
                        return new Result(Result.SEVERITY.WARNING, 4, "00.0750 ist nicht im Rahmen einer \u00e4rztlichen Beratung 00.0010 verrechnenbar.", null, false);
                    }
                }
            }
            this.newVerrechnet.setDetail(AL, Integer.toString(tc.getAL(kons.getMandant())));
            this.setALScalingInfo(tc, this.newVerrechnet, kons.getMandant(), false);
            this.newVerrechnet.setDetail(TL, Integer.toString(tc.getTL()));
            lst.add(this.newVerrechnet);
        }
        if (this.isReferenceInfoAvailable() && this.shouldDetermineReference(tc)) {
            List<Verrechnet> masters = this.getPossibleMasters(this.newVerrechnet, lst);
            if (masters.isEmpty()) {
                this.decrementOrDelete(this.newVerrechnet);
                return new Result(Result.SEVERITY.WARNING, 3, "F\u00fcr die Zuschlagsleistung " + code.getCode() + " konnte keine passende Hauptleistung gefunden werden.", null, false);
            }
            if (!masters.isEmpty()) {
                String bezug = this.newVerrechnet.getDetail("Bezug");
                if (bezug == null) {
                    this.newVerrechnet.setDetail("Bezug", masters.get(0).getCode());
                } else {
                    boolean found = false;
                    for (Verrechnet mVerr : masters) {
                        if (!mVerr.getCode().equals(bezug)) continue;
                        found = true;
                    }
                    if (!found) {
                        this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() - 1);
                        this.newVerrechnet = new Verrechnet(code, kons, 1);
                        this.newVerrechnet.setDetail("Bezug", masters.get(0).getCode());
                    }
                }
            }
        }
        if (!(limitResult = this.checkLimitations(kons, tc, this.newVerrechnet)).isOK()) {
            this.decrementOrDelete(this.newVerrechnet);
            return limitResult;
        }
        String tcid = code.getCode();
        if (!tc.getCode().equals(DEFAULT_TAX_XRAY_ROOM) && !tc.getCode().matches("39.002[01]") && tc.getParent().startsWith(CHAPTER_XRAY)) {
            if (CoreHub.userCfg.get("billing/optify/XRAY", true)) {
                this.add(this.getKonsVerrechenbar(DEFAULT_TAX_XRAY_ROOM, kons), kons);
                this.add(this.getKonsVerrechenbar("39.0020", kons), kons);
            }
        } else if (tcid.equals("29.2090")) {
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (Verrechnet v : lst) {
                if (!(v.getVerrechenbar() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getVerrechenbar();
                tlc = tl.getCode();
                double z = v.getZahl();
                if (!tlc.matches("29.20[12345678]0") && !tlc.equals("29.2200")) continue;
                sumAL += z * (double)tl.getAL(kons.getMandant()) / 2.0;
                sumTL += z * (double)tl.getTL() / 4.0;
            }
            this.newVerrechnet.setTP(sumAL + sumTL);
            this.newVerrechnet.setDetail(AL, Double.toString(sumAL));
            this.newVerrechnet.setDetail(TL, Double.toString(sumTL));
        } else if (tcid.equals("00.0010") || tcid.equals("00.0060")) {
            String alter;
            Patient p;
            Fall f;
            if (CoreHub.mandantCfg != null && CoreHub.mandantCfg.get("tarmed/addchildrentp", false) && (f = kons.getFall()) != null && (p = f.getPatient()) != null && Integer.parseInt(alter = p.getAlter()) < 6) {
                TarmedLeistung tl2 = (TarmedLeistung)this.getKonsVerrechenbar("00.0040", kons);
                this.add((IVerrechenbar)tl2, kons);
            }
        } else if (tcid.equals("04.1930")) {
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (Verrechnet v : lst) {
                if (!(v.getVerrechenbar() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getVerrechenbar();
                tlc = tl.getCode();
                int z = v.getZahl();
                if (!tlc.equals("04.1910") && !tlc.equals("04.1920") && !tlc.equals("04.1940") && !tlc.equals("04.1950")) continue;
                sumAL += (double)(tl.getAL(kons.getMandant()) * z);
                sumTL += (double)(tl.getTL() * z);
            }
            this.newVerrechnet.setTP(sumAL + sumTL);
            this.newVerrechnet.setDetail(AL, Double.toString(sumAL));
            this.newVerrechnet.setDetail(TL, Double.toString(sumTL));
            this.newVerrechnet.setPrimaryScaleFactor(0.5);
        } else if (tcid.equals("04.0620")) {
            double sumAL = 0.0;
            double sumTL = 0.0;
            for (Verrechnet v : lst) {
                if (!(v.getVerrechenbar() instanceof TarmedLeistung)) continue;
                tl = (TarmedLeistung)v.getVerrechenbar();
                tlc = tl.getCode();
                int z = v.getZahl();
                if (!tlc.equals("04.0610") && !tlc.equals("04.0630") && !tlc.equals("04.0640")) continue;
                sumAL += (double)(tl.getAL(kons.getMandant()) * z);
                sumTL += (double)(tl.getTL() * z);
            }
            this.newVerrechnet.setTP(sumAL + sumTL);
            this.newVerrechnet.setDetail(AL, Double.toString(sumAL));
            this.newVerrechnet.setDetail(TL, Double.toString(sumTL));
            this.newVerrechnet.setPrimaryScaleFactor(0.7);
        }
        if (tcid.startsWith("00.25")) {
            double sum = 0.0;
            int subcode = Integer.parseInt(tcid.substring(5));
            switch (subcode) {
                case 10: {
                    break;
                }
                case 20: {
                    break;
                }
                case 30: 
                case 70: {
                    TarmedLeistung tl3;
                    for (Verrechnet v : lst) {
                        if (!(v.getVerrechenbar() instanceof TarmedLeistung) || (tl3 = (TarmedLeistung)v.getVerrechenbar()).getCode().startsWith("00.25")) continue;
                        sum += (double)(tl3.getAL(kons.getMandant()) * v.getZahl());
                    }
                    this.newVerrechnet.setTP(sum);
                    this.newVerrechnet.setDetail(AL, Double.toString(sum));
                    this.newVerrechnet.setPrimaryScaleFactor(0.25);
                    break;
                }
                case 40: {
                    break;
                }
                case 50: 
                case 90: {
                    TarmedLeistung tl3;
                    for (Verrechnet v : lst) {
                        if (!(v.getVerrechenbar() instanceof TarmedLeistung) || (tl3 = (TarmedLeistung)v.getVerrechenbar()).getCode().startsWith("00.25")) continue;
                        sum += (double)(tl3.getAL(kons.getMandant()) * v.getZahl());
                    }
                    this.newVerrechnet.setTP(sum);
                    this.newVerrechnet.setDetail(AL, Double.toString(sum));
                    this.newVerrechnet.setPrimaryScaleFactor(0.5);
                    break;
                }
                case 60: {
                    break;
                }
            }
            return new Result(Result.SEVERITY.OK, 1, "Preis", null, false);
        }
        return new Result(null);
    }

    private void decrementOrDelete(Verrechnet verrechnet) {
        int zahl = verrechnet.getZahl();
        if (zahl > 1) {
            verrechnet.setZahl(zahl - 1);
        } else {
            verrechnet.delete();
        }
    }

    private boolean isContext(String key) {
        return this.getContextValue(key) != null;
    }

    private Object getContextValue(String key) {
        if (this.contextMap != null) {
            return this.contextMap.get(key);
        }
        return null;
    }

    private void setALScalingInfo(TarmedLeistung tarmed, Verrechnet verrechnet, Mandant mandant, boolean isComposite) {
        double scaling = tarmed.getALScaling(mandant);
        if (scaling != 100.0) {
            this.newVerrechnet.setDetail(AL_NOTSCALED, Integer.toString(tarmed.getAL()));
            this.newVerrechnet.setDetail(AL_SCALINGFACTOR, Double.toString(scaling / 100.0));
        }
    }

    private int doubleToInt(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(0, RoundingMode.HALF_UP);
        return bd.intValue();
    }

    private Result<IVerrechenbar> checkLimitations(Konsultation kons, TarmedLeistung tarmedLeistung, Verrechnet newVerrechnet) {
        if (this.bOptify) {
            List<TarmedLimitation> limitations = tarmedLeistung.getLimitations();
            for (TarmedLimitation tarmedLimitation : limitations) {
                Result<IVerrechenbar> result;
                if (!tarmedLimitation.isTestable() || (result = tarmedLimitation.test(kons, newVerrechnet)).isOK()) continue;
                return result;
            }
            TimeTool date = new TimeTool(kons.getDatum());
            List<String> groups = tarmedLeistung.getServiceGroups(date);
            for (String groupName : groups) {
                Optional<TarmedGroup> group = TarmedGroup.find(groupName, tarmedLeistung.get("Law"), date);
                if (!group.isPresent()) continue;
                limitations = group.get().getLimitations();
                for (TarmedLimitation tarmedLimitation : limitations) {
                    Result<IVerrechenbar> result;
                    if (!tarmedLimitation.isTestable() || (result = tarmedLimitation.test(kons, newVerrechnet)).isOK()) continue;
                    return result;
                }
            }
        }
        return new Result(null);
    }

    private String checkAge(String limitsString, Konsultation kons) {
        LocalDateTime consDate = new TimeTool(kons.getDatum()).toLocalDateTime();
        Patient patient = kons.getFall().getPatient();
        String geburtsdatum = patient.getGeburtsdatum();
        if (StringUtils.isEmpty((String)geburtsdatum)) {
            return "Patienten Alter nicht ok, kein Geburtsdatum angegeben";
        }
        long patientAgeDays = patient.getAgeAt(consDate, ChronoUnit.DAYS);
        List<TarmedLeistungAge> ageLimits = TarmedLeistungAge.of(limitsString, consDate);
        for (TarmedLeistungAge tarmedLeistungAge : ageLimits) {
            if (!tarmedLeistungAge.isValidOn(consDate.toLocalDate())) continue;
            if (tarmedLeistungAge.getFromDays() >= 0L && tarmedLeistungAge.getToDays() < 0L) {
                if (patientAgeDays >= tarmedLeistungAge.getFromDays()) continue;
                return "Patient ist zu jung, verrechenbar ab " + tarmedLeistungAge.getFromText();
            }
            if (tarmedLeistungAge.getToDays() >= 0L && tarmedLeistungAge.getFromDays() < 0L) {
                if (patientAgeDays <= tarmedLeistungAge.getToDays()) continue;
                return "Patient ist zu alt, verrechenbar bis " + tarmedLeistungAge.getToText();
            }
            if (tarmedLeistungAge.getToDays() < 0L || tarmedLeistungAge.getFromDays() < 0L || !(tarmedLeistungAge.getToDays() < tarmedLeistungAge.getFromDays() ? patientAgeDays > tarmedLeistungAge.getToDays() && patientAgeDays < tarmedLeistungAge.getFromDays() : patientAgeDays > tarmedLeistungAge.getToDays() || patientAgeDays < tarmedLeistungAge.getFromDays())) continue;
            return "Patienten Alter nicht ok, verrechenbar " + tarmedLeistungAge.getText();
        }
        return null;
    }

    private IVerrechenbar getKonsVerrechenbar(String code, Konsultation kons) {
        TimeTool date = new TimeTool(kons.getDatum());
        if (kons.getFall() != null) {
            String law = kons.getFall().getConfiguredBillingSystemLaw().name();
            return TarmedLeistung.getFromCode(code, date, law);
        }
        return null;
    }

    private boolean isReferenceInfoAvailable() {
        return CoreHub.globalCfg.get("ch.elexis.data.importer.TarmedReferenceDataImporter/referenceinfoavailable", false);
    }

    private boolean shouldDetermineReference(TarmedLeistung tc) {
        boolean becauseOfType;
        String typ = tc.getServiceTyp();
        boolean bl = becauseOfType = typ != null && typ.equals("Z");
        if (becauseOfType) {
            String text = tc.getText();
            return text.startsWith("+") || text.startsWith("-");
        }
        return false;
    }

    private List<Verrechnet> getAvailableMasters(TarmedLeistung slave, List<Verrechnet> lst) {
        LinkedList<Verrechnet> ret = new LinkedList<Verrechnet>();
        TimeTool konsDate = null;
        for (Verrechnet v : lst) {
            TarmedLeistung tl;
            if (konsDate == null) {
                konsDate = new TimeTool(v.getKons().getDatum());
            }
            if (!(v.getVerrechenbar() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getVerrechenbar()).getHierarchy(konsDate).contains(slave.getCode())) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<Verrechnet> getPossibleMasters(Verrechnet newSlave, List<Verrechnet> lst) {
        TarmedLeistung slaveTarmed = (TarmedLeistung)newSlave.getVerrechenbar();
        List<Verrechnet> masters = this.getAvailableMasters(slaveTarmed, lst);
        int maxPerMaster = this.getMaxPerMaster(slaveTarmed);
        if (maxPerMaster > 0) {
            Map<Verrechnet, List<Verrechnet>> masterSlavesMap = this.getMasterToSlavesMap(newSlave, lst);
            for (Verrechnet master : masterSlavesMap.keySet()) {
                int masterCount = master.getZahl();
                int slaveCount = 0;
                for (Verrechnet slave : masterSlavesMap.get(master)) {
                    slaveCount += slave.getZahl();
                    if (!slave.equals((Object)newSlave)) continue;
                    --slaveCount;
                }
                if (masterCount > slaveCount * maxPerMaster) continue;
                masters.remove(master);
            }
        }
        return masters;
    }

    private Map<Verrechnet, List<Verrechnet>> getMasterToSlavesMap(Verrechnet newSlave, List<Verrechnet> lst) {
        HashMap<Verrechnet, List<Verrechnet>> ret = new HashMap<Verrechnet, List<Verrechnet>>();
        TarmedLeistung slaveTarmed = (TarmedLeistung)newSlave.getVerrechenbar();
        List<Verrechnet> masters = this.getAvailableMasters(slaveTarmed, lst);
        for (Verrechnet verrechnet : masters) {
            ret.put(verrechnet, new ArrayList());
        }
        List<Verrechnet> slaves = this.getVerrechnetMatchingCode(lst, newSlave.getCode());
        for (Verrechnet slave : slaves) {
            String bezug = slave.getDetail("Bezug");
            if (bezug == null || bezug.isEmpty()) continue;
            for (Verrechnet master : ret.keySet()) {
                if (!master.getCode().equals(bezug)) continue;
                ((List)ret.get(master)).add(slave);
            }
        }
        return ret;
    }

    private int getMaxPerMaster(TarmedLeistung slave) {
        List<TarmedLimitation> limits = slave.getLimitations();
        for (TarmedLimitation limit : limits) {
            if (limit.getLimitationUnit() != TarmedLimitation.LimitationUnit.MAINSERVICE) continue;
            return limit.getAmount();
        }
        return -1;
    }

    private void mapOpReduction(Verrechnet opVerrechnet, Verrechnet reductionVerrechnet) {
        TarmedLeistung opVerrechenbar = (TarmedLeistung)opVerrechnet.getVerrechenbar();
        reductionVerrechnet.setZahl(opVerrechnet.getZahl());
        reductionVerrechnet.setDetail(TL, Double.toString(opVerrechenbar.getTL()));
        reductionVerrechnet.setDetail(AL, Double.toString(0.0));
        reductionVerrechnet.setTP((double)opVerrechenbar.getTL());
        reductionVerrechnet.setPrimaryScaleFactor(-0.4);
        reductionVerrechnet.setDetail("Bezug", opVerrechenbar.getCode());
    }

    private List<Verrechnet> updateOPReductions(List<Verrechnet> opCodes, List<Verrechnet> opReduction) {
        ArrayList<Verrechnet> notMappedCodes = new ArrayList<Verrechnet>();
        notMappedCodes.addAll(opCodes);
        for (Verrechnet reductionVerrechnet : opReduction) {
            boolean isMapped = false;
            String bezug = reductionVerrechnet.getDetail("Bezug");
            if (bezug != null && !bezug.isEmpty()) {
                for (Verrechnet opVerrechnet : opCodes) {
                    TarmedLeistung opVerrechenbar = (TarmedLeistung)opVerrechnet.getVerrechenbar();
                    String opCodeString = opVerrechenbar.getCode();
                    if (!bezug.equals(opCodeString)) continue;
                    reductionVerrechnet.setZahl(opVerrechnet.getZahl());
                    reductionVerrechnet.setDetail(TL, Double.toString(opVerrechenbar.getTL()));
                    reductionVerrechnet.setDetail(AL, Double.toString(0.0));
                    reductionVerrechnet.setPrimaryScaleFactor(-0.4);
                    notMappedCodes.remove(opVerrechnet);
                    isMapped = true;
                    break;
                }
            }
            if (isMapped) continue;
            reductionVerrechnet.setZahl(0);
            reductionVerrechnet.setDetail("Bezug", "");
        }
        return notMappedCodes;
    }

    private List<Verrechnet> getOPList(List<Verrechnet> lst) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        for (Verrechnet v : lst) {
            TarmedLeistung tl;
            if (!(v.getVerrechenbar() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getVerrechenbar()).getSparteAsText().equals("OP I")) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<Verrechnet> getVerrechnetMatchingCode(List<Verrechnet> lst, String code) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        for (Verrechnet v : lst) {
            TarmedLeistung tl;
            if (!(v.getVerrechenbar() instanceof TarmedLeistung) || !(tl = (TarmedLeistung)v.getVerrechenbar()).getCode().equals(code)) continue;
            ret.add(v);
        }
        return ret;
    }

    private List<Verrechnet> getVerrechnetWithBezugMatchingCode(List<Verrechnet> lst, String code) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        for (Verrechnet v : lst) {
            if (!(v.getVerrechenbar() instanceof TarmedLeistung) || !code.equals(v.getDetail("Bezug"))) continue;
            ret.add(v);
        }
        return ret;
    }

    private String getNewVerrechnetSideOrIncrement(IVerrechenbar code, List<Verrechnet> lst) {
        int countSideLeft = 0;
        Verrechnet leftVerrechnet = null;
        int countSideRight = 0;
        Verrechnet rightVerrechnet = null;
        for (Verrechnet v : lst) {
            if (!v.isInstance(code)) continue;
            String side = v.getDetail("Seite");
            if (side.equals("l")) {
                countSideLeft += v.getZahl();
                leftVerrechnet = v;
                continue;
            }
            countSideRight += v.getZahl();
            rightVerrechnet = v;
        }
        if (this.isContext("Seite")) {
            String side = (String)this.getContextValue("Seite");
            if ("l".equals(side) && countSideLeft > 0) {
                this.newVerrechnet = leftVerrechnet;
                this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() + 1);
            } else if ("r".equals(side) && countSideRight > 0) {
                this.newVerrechnet = rightVerrechnet;
                this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() + 1);
            }
            return side;
        }
        if (countSideLeft > 0 || countSideRight > 0) {
            if (countSideLeft > countSideRight && rightVerrechnet != null) {
                this.newVerrechnet = rightVerrechnet;
                this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() + 1);
            } else if (countSideLeft <= countSideRight && leftVerrechnet != null) {
                this.newVerrechnet = leftVerrechnet;
                this.newVerrechnet.setZahl(this.newVerrechnet.getZahl() + 1);
            } else if (countSideLeft > countSideRight && rightVerrechnet == null) {
                return "r";
            }
        }
        return "l";
    }

    public Result<IVerrechenbar> isCompatible(TarmedLeistung tarmedCode, TarmedLeistung tarmed, Konsultation kons) {
        return this.isCompatible(null, tarmedCode, null, tarmed, kons);
    }

    public Result<IVerrechenbar> isCompatible(Verrechnet tarmedCodeVerrechnet, TarmedLeistung tarmedCode, Verrechnet tarmedVerrechnet, TarmedLeistung tarmed, Konsultation kons) {
        TimeTool date = new TimeTool(kons.getDatum());
        List<TarmedExclusion> exclusions = tarmed.getExclusions(kons);
        for (TarmedExclusion tarmedExclusion : exclusions) {
            if (!tarmedExclusion.isMatching(tarmedCode, date)) continue;
            if (tarmedExclusion.isValidSide() && tarmedCodeVerrechnet != null && tarmedVerrechnet != null) {
                String tarmedCodeSide = tarmedCodeVerrechnet.getDetail("Seite");
                String tarmedSide = tarmedVerrechnet.getDetail("Seite");
                if (tarmedSide != null && tarmedCodeSide != null) {
                    if (!tarmedSide.equals(tarmedCodeSide)) continue;
                    return new Result(Result.SEVERITY.WARNING, 11, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString() + " auf der selben Seite", null, false);
                }
            }
            return new Result(Result.SEVERITY.WARNING, 4, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString(), null, false);
        }
        if (!tarmedCode.getCode().equals(tarmed.getCode())) {
            List<String> groups = tarmed.getServiceGroups(date);
            for (String groupName : groups) {
                Optional<TarmedGroup> group = TarmedGroup.find(groupName, tarmed.get("Law"), date);
                if (!group.isPresent() || tarmedCode.getServiceTyp().equals("Z")) continue;
                List<TarmedExclusion> groupExclusions = group.get().getExclusions(kons);
                for (TarmedExclusion tarmedExclusion : groupExclusions) {
                    if (!tarmedExclusion.isMatching(tarmedCode, date)) continue;
                    return new Result(Result.SEVERITY.WARNING, 4, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedExclusion.toString(), null, false);
                }
            }
        }
        List<String> blocks = tarmed.getServiceBlocks(date);
        for (String blockName : blocks) {
            List<TarmedExclusive> exclusives;
            if (this.skipBlockExclusives(blockName) || !this.canHandleAllExculives(exclusives = TarmedKumulation.getExclusives(blockName, TarmedKumulation.TarmedKumulationType.BLOCK, date, tarmed.get("Law"))) || this.isMatchingHierarchy(tarmedCode, tarmed, date) || tarmedCode.getServiceTyp().equals("Z")) continue;
            boolean included = false;
            for (TarmedExclusive tarmedExclusive : exclusives) {
                if (!tarmedExclusive.isMatching(tarmedCode, date)) continue;
                included = true;
            }
            if (included) continue;
            return new Result(Result.SEVERITY.WARNING, 10, String.valueOf(tarmed.getCode()) + " nicht kombinierbar mit " + tarmedCode.getCode() + ", wegen Block Kumulation", null, false);
        }
        return new Result(Result.SEVERITY.OK, 0, "compatible", null, false);
    }

    private boolean skipBlockExclusives(String blockName) {
        try {
            Integer blockNumber = Integer.valueOf(blockName);
            if (blockNumber > 50 && blockNumber < 60) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private boolean isMatchingHierarchy(TarmedLeistung tarmedCode, TarmedLeistung tarmed, TimeTool date) {
        return tarmed.getHierarchy(date).contains(tarmedCode.getCode());
    }

    private boolean canHandleAllExculives(List<TarmedExclusive> exclusives) {
        for (TarmedExclusive tarmedExclusive : exclusives) {
            if (tarmedExclusive.getSlaveType() == TarmedKumulation.TarmedKumulationType.BLOCK || tarmedExclusive.getSlaveType() == TarmedKumulation.TarmedKumulationType.CHAPTER || tarmedExclusive.getSlaveType() == TarmedKumulation.TarmedKumulationType.SERVICE) continue;
            return false;
        }
        return true;
    }

    public Result<Verrechnet> remove(Verrechnet code, Konsultation kons) {
        List l = kons.getLeistungen();
        l.remove(code);
        code.delete();
        List<Verrechnet> left = this.getVerrechnetMatchingCode(l, code.getCode());
        if (left.isEmpty()) {
            List<Verrechnet> verrechnetWithBezug = this.getVerrechnetWithBezugMatchingCode(kons.getLeistungen(), code.getCode());
            for (Verrechnet verrechnet : verrechnetWithBezug) {
                this.remove(verrechnet, kons);
            }
        }
        return new Result((Object)code);
    }

    public Verrechnet getCreatedVerrechnet() {
        return this.newVerrechnet;
    }
}

