/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class TarmedLimitation {
    private int amount;
    private String per;
    private String operator;
    private LimitationUnit limitationUnit;
    private int limitationAmount;
    private int electronicBilling;
    private boolean skip = false;
    private TarmedLeistung tarmedLeistung;
    private TarmedGroup tarmedGroup;
    private static final String VERRECHNET_BYPATIENT_ANDCODE = "SELECT leistungen.ID FROM leistungen, behandlungen, faelle WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TarmedLeistung' AND faelle.ID = behandlungen.fallID AND faelle.PatientID = ? AND leistungen.LEISTG_CODE like ? ORDER BY behandlungen.Datum ASC";
    private static final String VERRECHNET_BYMANDANT_ANDCODE_DURING = "SELECT leistungen.ID FROM leistungen, behandlungen, faelle WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TarmedLeistung' AND faelle.ID = behandlungen.fallID AND faelle.PatientID = ? AND leistungen.LEISTG_CODE like ? AND behandlungen.Datum >= ? AND behandlungen.MandantID = ?";
    private static final String VERRECHNET_BYCOVERAGE_ANDCODE = "SELECT leistungen.ID FROM leistungen, behandlungen WHERE leistungen.deleted = '0' AND leistungen.deleted = behandlungen.deleted AND leistungen.BEHANDLUNG = behandlungen.ID AND leistungen.KLASSE = 'ch.elexis.data.TarmedLeistung' AND leistungen.LEISTG_CODE like ? AND behandlungen.FallID = ?";

    public static TarmedLimitation of(String limitation) {
        TarmedLimitation ret = new TarmedLimitation();
        String[] parts = limitation.split(",");
        if (parts.length >= 5) {
            if (parts[0] != null && !parts[0].isEmpty()) {
                ret.operator = parts[0].trim();
            }
            if (parts[1] != null && !parts[1].isEmpty()) {
                ret.amount = Float.valueOf(parts[1].trim()).intValue();
            }
            if (parts[2] != null && !parts[2].isEmpty()) {
                ret.limitationAmount = Float.valueOf(parts[2].trim()).intValue();
            }
            if (parts[3] != null && !parts[3].isEmpty()) {
                ret.per = parts[3].trim();
            }
            if (parts[4] != null && !parts[4].isEmpty()) {
                ret.limitationUnit = LimitationUnit.from(Float.valueOf(parts[4].trim()).intValue());
            }
        }
        if (parts.length >= 6) {
            if (parts[5] != null && !parts[5].isEmpty()) {
                ret.electronicBilling = Float.valueOf(parts[5].trim()).intValue();
            }
        } else {
            ret.electronicBilling = 0;
        }
        return ret;
    }

    public TarmedLimitation setTarmedLeistung(TarmedLeistung tarmedLeistung) {
        this.tarmedLeistung = tarmedLeistung;
        return this;
    }

    public TarmedLimitation setTarmedGroup(TarmedGroup tarmedGroup) {
        this.tarmedGroup = tarmedGroup;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.limitationUnit == LimitationUnit.SESSION) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perSession);
        } else if (this.limitationUnit == LimitationUnit.SIDE) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perSide);
        } else if (this.limitationUnit == LimitationUnit.DAY) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perDay);
        } else if (this.limitationUnit == LimitationUnit.WEEK) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perWeeks, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perWeeks, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.MONTH) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perMonth, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perMonth, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.YEAR) {
            if (this.tarmedGroup != null) {
                sb.append(String.valueOf(String.format(Messages.TarmedOptifier_groupmax, this.tarmedGroup.getCode())) + this.amount + String.format(Messages.TarmedOptifier_perYears, this.limitationAmount));
            } else {
                sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + String.format(Messages.TarmedOptifier_perYears, this.limitationAmount));
            }
        } else if (this.limitationUnit == LimitationUnit.COVERAGE) {
            sb.append(String.valueOf(Messages.TarmedOptifier_codemax) + this.amount + Messages.TarmedOptifier_perCoverage);
        } else {
            sb.append("amount " + this.amount + "x unit " + this.limitationAmount + "x" + (Object)((Object)this.limitationUnit));
        }
        return sb.toString();
    }

    public boolean isTestable() {
        return this.limitationUnit == LimitationUnit.SIDE || this.limitationUnit == LimitationUnit.SESSION || this.limitationUnit == LimitationUnit.DAY || this.limitationUnit == LimitationUnit.WEEK || this.limitationUnit == LimitationUnit.MONTH || this.limitationUnit == LimitationUnit.YEAR || this.limitationUnit == LimitationUnit.COVERAGE;
    }

    public Result<IVerrechenbar> test(Konsultation kons, Verrechnet newVerrechnet) {
        if (this.limitationUnit == LimitationUnit.SIDE || this.limitationUnit == LimitationUnit.SESSION) {
            return this.testSideOrSession(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.DAY) {
            return this.testDay(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.WEEK || this.limitationUnit == LimitationUnit.MONTH || this.limitationUnit == LimitationUnit.YEAR) {
            return this.testDuration(kons, newVerrechnet);
        }
        if (this.limitationUnit == LimitationUnit.COVERAGE) {
            return this.testCoverage(kons, newVerrechnet);
        }
        return new Result(null);
    }

    private Result<IVerrechenbar> testCoverage(Konsultation kons, Verrechnet verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.operator.equals("<=")) {
            if (this.tarmedGroup == null) {
                List<Verrechnet> verrechnetByCoverage = this.getVerrechnetByCoverageAndCode(kons, this.tarmedLeistung.getCode());
                if (this.getVerrechnetCount(verrechnetByCoverage = this.filterWithSameCode(verrechnet, verrechnetByCoverage)) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            } else {
                ArrayList<Verrechnet> allVerrechnetOfGroup = new ArrayList<Verrechnet>();
                List<String> serviceCodes = this.tarmedGroup.getServices();
                for (String code : serviceCodes) {
                    allVerrechnetOfGroup.addAll(this.getVerrechnetByCoverageAndCode(kons, code));
                }
                if (this.getVerrechnetCount(allVerrechnetOfGroup) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            }
        }
        return ret;
    }

    private Result<IVerrechenbar> testDuration(Konsultation kons, Verrechnet verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.operator.equals("<=")) {
            if (this.tarmedGroup == null) {
                List<Verrechnet> verrechnetByMandant = this.getVerrechnetByRechnungsstellerAndCodeDuringPeriod(kons, verrechnet.getVerrechenbar().getCode());
                if (this.getVerrechnetCount(verrechnetByMandant) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            } else {
                ArrayList<Verrechnet> allVerrechnetOfGroup = new ArrayList<Verrechnet>();
                List<String> serviceCodes = this.tarmedGroup.getServices();
                for (String code : serviceCodes) {
                    allVerrechnetOfGroup.addAll(this.getVerrechnetByRechnungsstellerAndCodeDuringPeriod(kons, code));
                }
                if (this.getVerrechnetCount(allVerrechnetOfGroup) > this.amount) {
                    ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
                }
            }
        }
        return ret;
    }

    private int getVerrechnetCount(List<Verrechnet> verrechnete) {
        int ret = 0;
        for (Verrechnet verrechnet : verrechnete) {
            ret += verrechnet.getZahl();
        }
        return ret;
    }

    private List<Verrechnet> getVerrechnetByRechnungsstellerAndCodeDuringPeriod(Konsultation kons, String code) {
        Rechnungssteller rechnungssteller = kons.getMandant().getRechnungssteller();
        ArrayList<Verrechnet> all = new ArrayList();
        if (rechnungssteller != null) {
            block8: {
                PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement(VERRECHNET_BYPATIENT_ANDCODE);
                try {
                    try {
                        pstm.setString(1, kons.getFall().getPatient().getId());
                        pstm.setString(2, String.valueOf(code) + "%");
                        ResultSet resultSet = pstm.executeQuery();
                        while (resultSet.next()) {
                            all.add(Verrechnet.load((String)resultSet.getString(1)));
                        }
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error during lookup", (Throwable)e);
                        PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
                    throw throwable;
                }
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
            all = all.parallelStream().filter(v -> v.getKons().getMandant().getRechnungssteller().equals((Object)rechnungssteller)).collect(Collectors.toList());
            all = this.filterValidCodeForKonsultation(code, kons, all);
            LocalDate konsDate = new TimeTool(kons.getDatum()).toLocalDate();
            List<VerrechnetPeriod> grouped = this.getGroupedByPeriod(all);
            for (VerrechnetPeriod verrechnetPeriod : grouped) {
                if (!verrechnetPeriod.isDateInPeriod(konsDate)) continue;
                return verrechnetPeriod.getVerrechnete();
            }
        }
        return Collections.emptyList();
    }

    private List<VerrechnetPeriod> getGroupedByPeriod(List<Verrechnet> verrechnete) {
        if (!verrechnete.isEmpty()) {
            ArrayList<VerrechnetPeriod> ret = new ArrayList<VerrechnetPeriod>();
            for (Verrechnet verrechnet : verrechnete) {
                if (ret.isEmpty()) {
                    ret.add(new VerrechnetPeriod(verrechnet));
                    continue;
                }
                boolean added = false;
                for (VerrechnetPeriod verrechnetPeriod : ret) {
                    if (!verrechnetPeriod.isInPeriod(verrechnet)) continue;
                    verrechnetPeriod.addVerrechnet(verrechnet);
                    added = true;
                    break;
                }
                if (added) continue;
                ret.add(new VerrechnetPeriod(verrechnet));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private List<Verrechnet> getVerrechnetByMandantAndCodeDuring(Konsultation kons, String code) {
        LocalDate fromDate = this.getDuringStartDate(kons);
        Mandant mandant = kons.getMandant();
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        if (fromDate != null && mandant != null) {
            PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement(VERRECHNET_BYMANDANT_ANDCODE_DURING);
            try {
                try {
                    pstm.setString(1, kons.getFall().getPatient().getId());
                    pstm.setString(2, String.valueOf(code) + "%");
                    pstm.setString(3, fromDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                    pstm.setString(4, mandant.getId());
                    ResultSet resultSet = pstm.executeQuery();
                    while (resultSet.next()) {
                        ret.add(Verrechnet.load((String)resultSet.getString(1)));
                    }
                    resultSet.close();
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error during lookup", (Throwable)e);
                    PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
                }
            }
            finally {
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
        }
        return ret;
    }

    private List<Verrechnet> getVerrechnetByCoverageAndCode(Konsultation kons, String code) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        if (kons != null && kons.getFall() != null) {
            PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement(VERRECHNET_BYCOVERAGE_ANDCODE);
            try {
                try {
                    pstm.setString(1, String.valueOf(code) + "%");
                    pstm.setString(2, kons.getFall().getId());
                    ResultSet resultSet = pstm.executeQuery();
                    while (resultSet.next()) {
                        ret.add(Verrechnet.load((String)resultSet.getString(1)));
                    }
                    resultSet.close();
                }
                catch (SQLException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error during lookup", (Throwable)e);
                    PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
                }
            }
            finally {
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
        }
        return ret;
    }

    private LocalDate getDuringStartDate(Konsultation kons) {
        LocalDate leistungDate;
        LocalDate konsDate = new TimeTool(kons.getDatum()).toLocalDate();
        LocalDate ret = null;
        if (this.limitationUnit == LimitationUnit.WEEK) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.WEEKS);
        } else if (this.limitationUnit == LimitationUnit.MONTH) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.MONTHS);
        } else if (this.limitationUnit == LimitationUnit.YEAR) {
            ret = konsDate.minus(this.limitationAmount, ChronoUnit.YEARS);
        }
        if (this.tarmedLeistung != null && ret != null && ret.isBefore(leistungDate = this.tarmedLeistung.getGueltigVon().toLocalDate())) {
            ret = leistungDate;
        }
        return ret;
    }

    private List<Verrechnet> filterWithSameCode(Verrechnet verrechnet, List<Verrechnet> list) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        String matchCode = verrechnet.get("Leistg_code");
        if (matchCode != null && !matchCode.isEmpty()) {
            for (Verrechnet element : list) {
                if (!matchCode.equals(element.get("Leistg_code"))) continue;
                ret.add(element);
            }
        }
        return ret;
    }

    private List<Verrechnet> filterValidCodeForKonsultation(String code, Konsultation kons, List<Verrechnet> list) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        BillingLaw law = kons.getFall().getConfiguredBillingSystemLaw();
        IVerrechenbar validForKons = TarmedLeistung.getFromCode(code, new TimeTool(kons.getDatum()), law.name());
        if (validForKons != null) {
            String matchCode = validForKons.getId();
            if (matchCode != null && !matchCode.isEmpty()) {
                for (Verrechnet element : list) {
                    if (!matchCode.equals(element.get("Leistg_code"))) continue;
                    ret.add(element);
                }
            }
        } else {
            ret.addAll(list);
        }
        return ret;
    }

    private Result<IVerrechenbar> testDay(Konsultation kons, Verrechnet verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.limitationAmount == 1 && this.operator.equals("<=") && this.getVerrechnetAmount(verrechnet) > this.amount) {
            ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
        }
        return ret;
    }

    private Result<IVerrechenbar> testSideOrSession(Konsultation kons, Verrechnet verrechnet) {
        Result ret = new Result(null);
        if (this.shouldSkipTest()) {
            return ret;
        }
        if (this.limitationAmount == 1 && this.operator.equals("<=") && this.getVerrechnetAmount(verrechnet) > this.amount) {
            if (this.limitationUnit == LimitationUnit.SESSION) {
                ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
            } else if (this.limitationUnit == LimitationUnit.SIDE) {
                ret = new Result(Result.SEVERITY.WARNING, 2, this.toString(), null, false);
            }
        }
        return ret;
    }

    private List<Verrechnet> getSameVerrechnetOfKons(Verrechnet verrechnet) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        String verrechnetClass = verrechnet.get("Klasse");
        String verrechnetCode = verrechnet.getCode();
        if (verrechnetClass != null && verrechnetCode != null) {
            Konsultation kons = verrechnet.getKons();
            for (Verrechnet leistung : kons.getLeistungen()) {
                if (!verrechnetClass.equals(verrechnet.get("Klasse")) || !verrechnetCode.equals(leistung.getCode())) continue;
                if (this.limitationUnit == LimitationUnit.SIDE) {
                    if (!TarmedLeistung.getSide(verrechnet).equals(TarmedLeistung.getSide(leistung))) continue;
                    ret.add(leistung);
                    continue;
                }
                ret.add(leistung);
            }
        }
        return ret;
    }

    private int getVerrechnetAmount(Verrechnet verrechnet) {
        List<Verrechnet> sameVerrechnet = this.getSameVerrechnetOfKons(verrechnet);
        return this.getVerrechnetCount(sameVerrechnet);
    }

    private boolean shouldSkipTest() {
        if (this.skip) {
            return this.skip;
        }
        return this.shouldSkipElectronicBilling();
    }

    private boolean shouldSkipElectronicBilling() {
        return this.electronicBilling > 0 && CoreHub.mandantCfg != null && CoreHub.mandantCfg.get("TarmedBillElectronic", false);
    }

    public LimitationUnit getLimitationUnit() {
        return this.limitationUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setSkip(boolean value) {
        this.skip = true;
    }

    public static enum LimitationUnit {
        LOCATION_SESSION,
        SIDE,
        SESSION,
        PATIENT_SESSION,
        COVERAGE,
        STAY,
        TESTSERIES,
        PREGNANCY,
        BIRTH,
        RADIANTEXPOSURE,
        TRANSMITTAL,
        AUTOPSY,
        EXPERTISE,
        INTERVENTION_SESSION,
        CATEGORY_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        JOINTREGION,
        REGION_SIDE,
        JOINTREGION_SIDE,
        MAINSERVICE,
        SESSION_YEAR,
        SESSION_COVERAGE,
        SESSION_PATIENT;


        public static LimitationUnit from(int parseInt) {
            switch (parseInt) {
                case 6: {
                    return LOCATION_SESSION;
                }
                case 7: {
                    return SESSION;
                }
                case 8: {
                    return COVERAGE;
                }
                case 9: {
                    return PATIENT_SESSION;
                }
                case 10: {
                    return SIDE;
                }
                case 11: {
                    return STAY;
                }
                case 12: {
                    return TESTSERIES;
                }
                case 13: {
                    return PREGNANCY;
                }
                case 14: {
                    return BIRTH;
                }
                case 15: 
                case 31: {
                    return RADIANTEXPOSURE;
                }
                case 16: {
                    return TRANSMITTAL;
                }
                case 17: {
                    return AUTOPSY;
                }
                case 18: {
                    return EXPERTISE;
                }
                case 19: {
                    return INTERVENTION_SESSION;
                }
                case 20: {
                    return CATEGORY_DAY;
                }
                case 21: {
                    return DAY;
                }
                case 22: {
                    return WEEK;
                }
                case 23: {
                    return MONTH;
                }
                case 26: {
                    return YEAR;
                }
                case 40: {
                    return JOINTREGION;
                }
                case 41: {
                    return REGION_SIDE;
                }
                case 42: {
                    return JOINTREGION_SIDE;
                }
                case 45: {
                    return MAINSERVICE;
                }
                case 51: {
                    return SESSION_YEAR;
                }
                case 52: {
                    return SESSION_COVERAGE;
                }
                case 53: 
                case 54: {
                    return SESSION_PATIENT;
                }
            }
            return null;
        }
    }

    private class VerrechnetPeriod {
        private LocalDate start;
        private LocalDate end;
        private List<Verrechnet> verrechnete;

        private VerrechnetPeriod(Verrechnet verrechnet) {
            this.start = new TimeTool(verrechnet.getKons().getDatum()).toLocalDate();
            if (TarmedLimitation.this.limitationUnit == LimitationUnit.WEEK) {
                this.end = this.start.plus(TarmedLimitation.this.limitationAmount, ChronoUnit.WEEKS);
            } else if (TarmedLimitation.this.limitationUnit == LimitationUnit.MONTH) {
                this.end = this.start.plus(TarmedLimitation.this.limitationAmount, ChronoUnit.MONTHS);
            } else if (TarmedLimitation.this.limitationUnit == LimitationUnit.YEAR) {
                this.end = this.start.plus(TarmedLimitation.this.limitationAmount, ChronoUnit.YEARS);
            }
            this.verrechnete = new ArrayList<Verrechnet>();
            this.verrechnete.add(verrechnet);
        }

        public List<Verrechnet> getVerrechnete() {
            return this.verrechnete;
        }

        private boolean isInPeriod(Verrechnet verrechnet) {
            LocalDate matchDate = new TimeTool(verrechnet.getKons().getDatum()).toLocalDate();
            return this.isDateInPeriod(matchDate);
        }

        private boolean isDateInPeriod(LocalDate date) {
            return !(!date.isAfter(this.start) && !date.isEqual(this.start) || !date.isBefore(this.end) && !date.isEqual(this.end));
        }

        private void addVerrechnet(Verrechnet verrechnet) {
            this.verrechnete.add(verrechnet);
        }
    }
}

