/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiVerrechenbarAdapter;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedDefinitionen;
import ch.elexis.data.TarmedExclusion;
import ch.elexis.data.TarmedExtension;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLimitation;
import ch.elexis.data.TarmedOptifier;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.Xid;
import ch.elexis.views.TarmedDetailDialog;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.slf4j.LoggerFactory;

public class TarmedLeistung
extends UiVerrechenbarAdapter {
    private static String MANDANT_TYPE_EXTINFO_KEY = "ch.elexis.data.tarmed.mandant.type";
    public static final String TABLENAME = "TARMED";
    public static final String FLD_CODE = "code";
    public static final String FLD_GUELTIG_BIS = "GueltigBis";
    public static final String FLD_GUELTIG_VON = "GueltigVon";
    public static final String FLD_SPARTE = "Sparte";
    public static final String FLD_DIGNI_QUANTI = "DigniQuanti";
    public static final String FLD_DIGNI_QUALI = "DigniQuali";
    public static final String FLD_TEXT = "Text";
    public static final String FLD_NICK = "Nickname";
    public static final String FLD_PARENT = "Parent";
    public static final String FLD_LAW = "Law";
    public static final String FLD_ISCHAPTER = "ischapter";
    public static final String EXT_FLD_TP_TL = "TP_TL";
    public static final String EXT_FLD_TP_AL = "TP_AL";
    public static final String EXT_FLD_F_AL_R = "F_AL_R";
    public static final String EXT_FLD_HIERARCHY_SLAVES = "HierarchySlaves";
    public static final String EXT_FLD_SERVICE_GROUPS = "ServiceGroups";
    public static final String EXT_FLD_SERVICE_BLOCKS = "ServiceBlocks";
    public static final String EXT_FLD_SERVICE_AGE = "ServiceAge";
    private static final String EXT_VERRRECHNET_TL = "TL";
    private static final String EXT_VERRRECHNET_AL = "AL";
    public static final String XIDDOMAIN = "www.xid.ch/id/tarmedsuisse";
    public static final String SIDE = "Seite";
    public static final String SIDE_L = "l";
    public static final String SIDE_R = "r";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String PFLICHTLEISTUNG = "obligation";
    public static final TarmedComparator tarmedComparator;
    public static final TarmedOptifier tarmedOptifier;
    public static final TimeTool INFINITE;
    public static TimeTool curTimeHelper;
    private static final String VERSION = "1.3.0";
    private static final String VERSION_110 = "1.1.0";
    private static final String VERSION_111 = "1.1.1";
    private static final String VERSION_120 = "1.2.0";
    private static final String VERSION_130 = "1.3.0";
    public static final String ROW_VERSION = "Version";
    public static final String CODESYSTEM_NAME = "Tarmed";
    private TarmedExtension extension;
    private static final String upd110 = "ALTER TABLE TARMED ADD lastupdate BIGINT";
    private static final String upd120 = "ALTER TABLE TARMED ADD code VARCHAR(25); ALTER TABLE TARMED MODIFY ID VARCHAR(25); ALTER TABLE TARMED_EXTENSION MODIFY CODE VARCHAR(25);";
    private static final String upd130 = " ALTER TABLE TARMED MODIFY Parent VARCHAR(32); ALTER TABLE TARMED MODIFY ID VARCHAR(32); ALTER TABLE TARMED ADD PRIMARY KEY (id); ALTER TABLE TARMED ADD Law VARCHAR(3); ALTER TABLE TARMED ADD ischapter CHAR(1) default '0';";
    public static final String createDB;
    private static final String DATASET_VERSION_SEPARATOR = "|";
    private static final String DATASET_LAW_SEPARATOR = ":=:";
    private static List<String> availableLawsCache;

    static {
        INFINITE = new TimeTool("19991231");
        curTimeHelper = new TimeTool();
        createDB = "CREATE TABLE TARMED (ID \t\t\t\t\tVARCHAR(32) primary key,lastupdate \t\t\tBIGINT,deleted \t\t\t\tCHAR(1) default '0',Parent\t\t\t\tVARCHAR(32),DigniQuanti \t\t\tCHAR(5),DigniQuali \t\t\tCHAR(4),Sparte\t\t\t\tCHAR(4),GueltigVon\t\t\tCHAR(8),GueltigBis\t\t\tCHAR(8),Nickname\t\t\t\tVARCHAR(25),tx255\t\t\t\tVARCHAR(255),code \t\t\t\tVARCHAR(25),Law\t\t\t\t\tVARCHAR(3),ischapter\t\t\tCHAR(1));CREATE INDEX tarmed_id on TARMED (id);CREATE INDEX tarmed2 on TARMED (Parent);CREATE INDEX tarmed3 on TARMED (Law);INSERT INTO TARMED (id, Nickname) VALUES (" + JdbcLink.wrap((String)ROW_VERSION) + ", " + JdbcLink.wrap((String)"1.3.0") + ");";
        TarmedLeistung.addMapping((String)TABLENAME, (String[])new String[]{"Ziffer=code", FLD_CODE, FLD_PARENT, FLD_DIGNI_QUALI, FLD_DIGNI_QUANTI, FLD_SPARTE, "Text=tx255", "Name=tx255", FLD_NICK, "GueltigVon=S:D:GueltigVon", "GueltigBis=S:D:GueltigBis", "deleted", FLD_LAW, FLD_ISCHAPTER});
        if (!TarmedLeistung.tableExists((String)TABLENAME)) {
            TarmedLeistung.createOrModifyTable((String)createDB);
        } else {
            TarmedLeistung version = TarmedLeistung.load(ROW_VERSION);
            VersionInfo vi = new VersionInfo(version.get(FLD_NICK));
            if (vi.isOlder(VERSION_110)) {
                TarmedLeistung.createOrModifyTable((String)upd110);
                version.set(FLD_NICK, VERSION_110);
            }
            if (vi.isOlder(VERSION_111)) {
                TarmedLeistung.createOrModifyTable((String)"Update TARMED set gueltigbis='20993112' where id='39.0305'");
                version.set(FLD_NICK, VERSION_111);
            }
            if (vi.isOlder(VERSION_120)) {
                TarmedLeistung.createOrModifyTable((String)upd120);
                version.set(FLD_NICK, VERSION_120);
            }
            if (vi.isOlder("1.3.0")) {
                TarmedLeistung.createOrModifyTable((String)upd130);
                version.set(FLD_NICK, "1.3.0");
            }
        }
        tarmedComparator = new TarmedComparator();
        tarmedOptifier = new TarmedOptifier();
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)CODESYSTEM_NAME, (int)1);
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public static String getTextForDigniQuali(String kuerzel) {
        return TarmedDefinitionen.getTitle("DIGNI_QUALI", kuerzel);
    }

    public static String getCodeForDigniQuali(String titel) {
        return TarmedDefinitionen.getKuerzel("DIGNI_QUALI", titel);
    }

    public static String getTextForDigniQuanti(String kuerzel) {
        return TarmedDefinitionen.getTitle("DIGNI_QUALI", kuerzel);
    }

    public static String getTextForSparte(String kuerzel) {
        return TarmedDefinitionen.getTitle("SPARTE", kuerzel);
    }

    public static String getTextForRisikoKlasse(String kuerzel) {
        return TarmedDefinitionen.getTitle("ANAESTHESIE", kuerzel);
    }

    public static String getTextForZR_Einheit(String kuerzel) {
        return TarmedDefinitionen.getTitle("ZR_EINHEIT", kuerzel);
    }

    public static String[] getDigniQuantiCodes() {
        return null;
    }

    public TarmedLeistung(String id, String code, String parent, String DigniQuali, String DigniQuanti, String sparte, boolean isChapter) {
        this.create(id, new String[]{FLD_CODE, FLD_PARENT, FLD_DIGNI_QUALI, FLD_DIGNI_QUANTI, FLD_SPARTE, FLD_ISCHAPTER}, new String[]{code, parent, DigniQuali, DigniQuanti, sparte, isChapter ? "1" : "0"});
        this.extension = new TarmedExtension(this);
    }

    public boolean isChapter() {
        return this.get(FLD_ISCHAPTER).equals("1");
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_CODE, FLD_TEXT, FLD_LAW});
        if (vals[0].isEmpty()) {
            vals[0] = this.getId();
        }
        return String.valueOf(vals[0]) + " " + vals[1] + (vals[2] != null && !vals[2].isEmpty() ? " (" + vals[2] + ")" : "");
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCode() {
        String code = this.get(FLD_CODE);
        if (code != null && !code.isEmpty()) {
            return code;
        }
        return this.getId();
    }

    public String getText() {
        return this.get(FLD_TEXT);
    }

    public void setText(String tx) {
        this.set(FLD_TEXT, tx);
    }

    public Hashtable<String, String> loadExtension() {
        if (this.getExtension() != null) {
            return (Hashtable)this.extension.getMap("limits");
        }
        return new Hashtable<String, String>();
    }

    public void setExtension(Hashtable<? extends Object, ? extends Object> map) {
        if (this.getExtension() == null) {
            throw new IllegalStateException("No Extension available for tarmed [" + this.getId() + "]");
        }
        this.extension.setMap("limits", map);
    }

    public String getMedInterpretation() {
        if (this.getExtension() != null) {
            return this.extension.get("med_interpret");
        }
        return "";
    }

    public void setMedInterpretation(String text) {
        if (this.getExtension() != null) {
            this.extension.set("med_interpret", text);
        }
        throw new IllegalStateException("No Extension available for tarmed [" + this.getId() + "]");
    }

    public String getTechInterpretation() {
        if (this.getExtension() != null) {
            return this.extension.get("tech_interpret");
        }
        return "";
    }

    public void setTechInterpretation(String text) {
        if (this.getExtension() != null) {
            this.extension.set("tech_interpret", text);
        }
        throw new IllegalStateException("No Extension available for tarmed [" + this.getId() + "]");
    }

    public String getDigniQuali() {
        return TarmedLeistung.checkNull((Object)this.get(FLD_DIGNI_QUALI));
    }

    public String getDigniQualiAsText() {
        return TarmedLeistung.checkNull((Object)TarmedLeistung.getTextForDigniQuali(this.get(FLD_DIGNI_QUALI)));
    }

    public void setDigniQuali(String dql) {
        this.set(FLD_DIGNI_QUALI, dql);
    }

    public String getDigniQuanti() {
        return TarmedLeistung.checkNull((Object)this.get(FLD_DIGNI_QUANTI));
    }

    public String getDigniQuantiAsText() {
        return TarmedLeistung.checkNull((Object)TarmedLeistung.getTextForDigniQuanti(this.get(FLD_DIGNI_QUANTI)));
    }

    public String getSparte() {
        return TarmedLeistung.checkNull((Object)this.get(FLD_SPARTE));
    }

    public String getSparteAsText() {
        return TarmedLeistung.checkNull((Object)TarmedLeistung.getTextForSparte(this.get(FLD_SPARTE)));
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    protected TarmedLeistung(String id) {
        super(id);
    }

    public TarmedLeistung() {
    }

    public static TarmedLeistung load(String id) {
        return new TarmedLeistung(id);
    }

    public static IVerrechenbar getFromCode(String code) {
        return TarmedLeistung.getFromCode(code, new TimeTool());
    }

    public static IVerrechenbar getFromCode(String code, TimeTool date) {
        return TarmedLeistung.getFromCode(code, date, "");
    }

    public static IVerrechenbar getFromCode(@NonNull String code, @NonNull TimeTool date, @Nullable String law) {
        if (availableLawsCache == null) {
            availableLawsCache = TarmedLeistung.getAvailableLaws();
        }
        Query query = new Query(TarmedLeistung.class, FLD_CODE, code, TABLENAME, new String[]{FLD_GUELTIG_VON, FLD_GUELTIG_BIS, FLD_LAW, FLD_ISCHAPTER});
        if (law != null) {
            if (!TarmedLeistung.isAvailableLaw(law)) {
                query.startGroup();
                query.add(FLD_LAW, "=", "");
                query.or();
                query.add(FLD_LAW, "=", null);
                query.endGroup();
            } else {
                query.add(FLD_LAW, "=", law, true);
            }
        }
        List leistungen = query.execute();
        for (TarmedLeistung tarmedLeistung : leistungen) {
            TimeTool validFrom = tarmedLeistung.getGueltigVon();
            TimeTool validTo = tarmedLeistung.getGueltigBis();
            if (!date.isAfterOrEqual(validFrom) || !date.isBeforeOrEqual(validTo)) continue;
            return tarmedLeistung;
        }
        return null;
    }

    public IOptifier getOptifier() {
        return tarmedOptifier;
    }

    public Comparator getComparator() {
        return tarmedComparator;
    }

    public IFilter getFilter(Mandant m) {
        return new MandantFilter(m);
    }

    public boolean isDragOK() {
        return !this.isChapter();
    }

    public int getAL() {
        Hashtable<String, String> map = this.loadExtension();
        return (int)Math.round(TarmedLeistung.checkZeroDouble((String)map.get(EXT_FLD_TP_AL)) * 100.0);
    }

    public int getAL(Mandant mandant) {
        Hashtable<String, String> map = this.loadExtension();
        return (int)Math.round(TarmedLeistung.checkZeroDouble((String)map.get(EXT_FLD_TP_AL)) * this.getALScaling(mandant));
    }

    public double getALScaling(Mandant mandant) {
        double alScaling;
        MandantType type;
        Hashtable<String, String> map = this.loadExtension();
        double scaling = 100.0;
        if (mandant != null && (type = TarmedLeistung.getMandantType(mandant)) == MandantType.PRACTITIONER && (alScaling = TarmedLeistung.checkZeroDouble((String)map.get(EXT_FLD_F_AL_R))) > 0.1) {
            scaling *= alScaling;
        }
        return scaling;
    }

    public static int getAL(Verrechnet verrechnet) {
        IVerrechenbar verrechenbar;
        String alString;
        String tpString;
        boolean changedPrice = verrechnet.isChangedPrice();
        if (changedPrice && (tpString = verrechnet.get("VK_TP")) != null) {
            try {
                return (int)Double.parseDouble(tpString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((alString = verrechnet.getDetail(EXT_VERRRECHNET_AL)) != null) {
            try {
                return (int)Double.parseDouble(alString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((verrechenbar = verrechnet.getVerrechenbar()) instanceof TarmedLeistung) {
            Konsultation kons = verrechnet.getKons();
            return kons != null ? ((TarmedLeistung)verrechenbar).getAL(kons.getMandant()) : ((TarmedLeistung)verrechenbar).getAL();
        }
        return 0;
    }

    public static int getTL(Verrechnet verrechnet) {
        IVerrechenbar verrechenbar;
        String tlString = verrechnet.getDetail(EXT_VERRRECHNET_TL);
        if (tlString != null) {
            try {
                return (int)Double.parseDouble(tlString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((verrechenbar = verrechnet.getVerrechenbar()) instanceof TarmedLeistung) {
            return ((TarmedLeistung)verrechenbar).getTL();
        }
        return 0;
    }

    public static MandantType getMandantType(Mandant mandant) {
        Object typeObj = mandant.getExtInfoStoredObjectByKey((Object)MANDANT_TYPE_EXTINFO_KEY);
        if (typeObj instanceof String) {
            return MandantType.valueOf((String)typeObj);
        }
        return MandantType.SPECIALIST;
    }

    public static void setMandantType(Mandant mandant, MandantType type) {
        mandant.setExtInfoStoredObjectByKey((Object)MANDANT_TYPE_EXTINFO_KEY, (Object)type.name());
    }

    public int getTL() {
        Hashtable<String, String> map = this.loadExtension();
        return (int)Math.round(TarmedLeistung.checkZeroDouble((String)map.get(EXT_FLD_TP_TL)) * 100.0);
    }

    public int getMinutes() {
        Hashtable<String, String> map = this.loadExtension();
        double min = TarmedLeistung.checkZeroDouble((String)map.get("LSTGIMES_MIN"));
        min += TarmedLeistung.checkZeroDouble((String)map.get("VBNB_MIN"));
        min += TarmedLeistung.checkZeroDouble((String)map.get("BEFUND_MIN"));
        return (int)Math.round(min += TarmedLeistung.checkZeroDouble((String)map.get("WECHSEL_MIN")));
    }

    public String getExclusion() {
        curTimeHelper.setTime(new Date());
        return this.getExclusion(curTimeHelper);
    }

    public List<TarmedExclusion> getExclusions(Konsultation kons) {
        if (kons == null) {
            curTimeHelper.setTime(new Date());
        } else {
            curTimeHelper.set(kons.getDatum());
        }
        return this.getExclusions(curTimeHelper);
    }

    public String getExclusion(TimeTool date) {
        String exclusions = TarmedKumulation.getExclusions(this.getCode(), date);
        if (exclusions == null) {
            Hashtable<String, String> map = this.loadExtension();
            if (map == null) {
                return "";
            }
            return TarmedLeistung.checkNull((Object)map.get("exclusion"));
        }
        return TarmedLeistung.checkNull((Object)exclusions);
    }

    public List<TarmedExclusion> getExclusions(TimeTool date) {
        return TarmedKumulation.getExclusions(this.getCode(), this.isChapter() ? TarmedKumulation.TarmedKumulationType.CHAPTER : TarmedKumulation.TarmedKumulationType.SERVICE, date, this.get(FLD_LAW));
    }

    public int getTP(TimeTool date, IFall fall) {
        return this.getTL() + this.getAL();
    }

    public int getTP(TimeTool date, Konsultation kons) {
        if (kons != null) {
            return this.getTL() + this.getAL(kons.getMandant());
        }
        return this.getTL() + this.getAL();
    }

    public double getFactor(TimeTool date, IFall fall) {
        return this.getVKMultiplikator(date, fall);
    }

    public TimeTool getGueltigVon() {
        String value = this.get(FLD_GUELTIG_VON);
        if (!StringTool.isNothing((Object)value)) {
            return new TimeTool(value);
        }
        return null;
    }

    public TimeTool getGueltigBis() {
        String value = this.get(FLD_GUELTIG_BIS);
        if (!StringTool.isNothing((Object)value)) {
            TimeTool res = new TimeTool(value);
            res.set(11, 23);
            res.set(12, 59);
            res.set(13, 59);
            return res;
        }
        return null;
    }

    public List<Object> getActions(final Object kontext) {
        List ret = super.getActions((Object)((Verrechnet)kontext));
        if (kontext != null) {
            ret.add(new Action("Details"){

                public void run() {
                    new TarmedDetailDialog(UiDesk.getTopShell(), (Verrechnet)kontext).open();
                }
            });
        }
        return ret;
    }

    public static boolean isObligation(Verrechnet v) {
        String obli;
        IVerrechenbar vv = v.getVerrechenbar();
        return vv instanceof TarmedLeistung && ((obli = v.getDetail(PFLICHTLEISTUNG)) == null || Boolean.parseBoolean(obli));
    }

    public static String getSide(Verrechnet v) {
        IVerrechenbar vv = v.getVerrechenbar();
        if (vv instanceof TarmedLeistung) {
            String side = v.getDetail(SIDE);
            if (SIDE_L.equalsIgnoreCase(side)) {
                return LEFT;
            }
            if (SIDE_R.equalsIgnoreCase(side)) {
                return RIGHT;
            }
        }
        return "none";
    }

    public boolean requiresSide() {
        Hashtable<String, String> map = this.loadExtension();
        return TarmedLeistung.checkZero((Object)map.get(SIDE.toUpperCase())) == 1;
    }

    public String getParent() {
        return this.get(FLD_PARENT);
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        return IVerrechenbar.VatInfo.VAT_CH_ISTREATMENT;
    }

    public static int getCurrentVersion() {
        return TarmedLeistung.getCurrentVersion("");
    }

    public static int getCurrentVersion(String law) {
        String[] parts;
        TarmedLeistung version = TarmedLeistung.load(ROW_VERSION);
        if (law == null || law.isEmpty()) {
            String versionVal = version.get(FLD_CODE);
            return TarmedLeistung.getVersionAsInt(versionVal);
        }
        String versionVal = version.get(FLD_TEXT);
        String[] stringArray = parts = versionVal.split("\\|");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] subParts = part.split(DATASET_LAW_SEPARATOR);
            if (subParts.length == 2 && law.equals(subParts[0])) {
                return TarmedLeistung.getVersionAsInt(subParts[1]);
            }
            ++n2;
        }
        return -1;
    }

    private static int getVersionAsInt(String versionVal) {
        try {
            return Integer.parseInt(versionVal);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static void setVersion(String versionVal) {
        TarmedLeistung.setVersion(versionVal, "");
    }

    public static void setVersion(String versionVal, String law) {
        TarmedLeistung version = TarmedLeistung.load(ROW_VERSION);
        if (law == null || law.isEmpty()) {
            if (!version.exists()) {
                version = new TarmedLeistung();
                version.create(ROW_VERSION);
                version.set(FLD_NICK, "1.3.0");
            }
            version.set(FLD_CODE, versionVal);
        } else {
            String[] parts;
            boolean found = false;
            StringBuilder sb = new StringBuilder();
            String oldVersions = version.get(FLD_TEXT);
            String[] stringArray = parts = oldVersions.split("\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] subParts = part.split(DATASET_LAW_SEPARATOR);
                if (subParts.length == 2) {
                    if (sb.length() > 0) {
                        sb.append(DATASET_VERSION_SEPARATOR);
                    }
                    sb.append(subParts[0]);
                    if (law.equals(subParts[0])) {
                        sb.append(DATASET_LAW_SEPARATOR).append(versionVal);
                        found = true;
                    } else {
                        sb.append(DATASET_LAW_SEPARATOR).append(subParts[1]);
                    }
                }
                ++n2;
            }
            if (!found) {
                if (sb.length() > 0) {
                    sb.append(DATASET_VERSION_SEPARATOR);
                }
                sb.append(law).append(DATASET_LAW_SEPARATOR).append(versionVal);
            }
            version.set(FLD_TEXT, sb.toString());
        }
    }

    public int getCacheTime() {
        return 300;
    }

    public List<String> getHierarchy(TimeTool date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> hierarchy = this.getExtStringListField(EXT_FLD_HIERARCHY_SLAVES);
        if (!hierarchy.isEmpty()) {
            for (String string : hierarchy) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String codeString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(codeString);
            }
        }
        return ret;
    }

    private boolean isDateWithinDatesString(TimeTool date, String datesString) {
        String[] parts = datesString.split("\\|");
        if (parts.length == 2) {
            LocalDate from = LocalDate.parse(parts[0]);
            LocalDate to = LocalDate.parse(parts[1]);
            LocalDate localDate = date.toLocalDate();
            return !(!from.isBefore(localDate) && !from.isEqual(localDate) || !to.isAfter(localDate) && !to.isEqual(localDate));
        }
        return false;
    }

    private List<String> getExtStringListField(String extKey) {
        ArrayList<String> ret = new ArrayList<String>();
        Hashtable<String, String> map = this.loadExtension();
        String values = map.get(extKey);
        if (values != null && !values.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = values.split(", ");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(string);
                ++n2;
            }
        }
        return ret;
    }

    public List<String> getServiceGroups(TimeTool date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> groups = this.getExtStringListField(EXT_FLD_SERVICE_GROUPS);
        if (!groups.isEmpty()) {
            for (String string : groups) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String groupString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(groupString);
            }
        }
        return ret;
    }

    public List<String> getServiceBlocks(TimeTool date) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> blocks = this.getExtStringListField(EXT_FLD_SERVICE_BLOCKS);
        if (!blocks.isEmpty()) {
            for (String string : blocks) {
                int dateStart = string.indexOf(91);
                String datesString = string.substring(dateStart + 1, string.length() - 1);
                String blockString = string.substring(0, dateStart);
                if (!this.isDateWithinDatesString(date, datesString)) continue;
                ret.add(blockString);
            }
        }
        return ret;
    }

    public String getServiceTyp() {
        Hashtable<String, String> map = this.loadExtension();
        return map.get("LEISTUNG_TYP");
    }

    public boolean remove() {
        return this.getDBConnection().exec("DELETE FROM " + this.getTableName() + " WHERE ID='" + this.getId() + "'") > 0;
    }

    public TarmedExtension getExtension() {
        if (this.extension == null) {
            this.extension = TarmedExtension.getExtension(this);
        }
        return this.extension;
    }

    /*
     * Exception decompiling
     */
    public static boolean hasParentIdReference() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isAvailableLaw(String law) {
        if (availableLawsCache == null) {
            availableLawsCache = TarmedLeistung.getAvailableLaws();
        }
        for (String available : availableLawsCache) {
            if (!available.equalsIgnoreCase(law)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAvailableLaws() {
        ArrayList<String> ret = new ArrayList<String>();
        DBConnection connection = PersistentObject.getDefaultConnection();
        JdbcLink.Stm stm = connection.getStatement();
        try {
            try {
                ResultSet res = stm.query("SELECT DISTINCT Law FROM tarmed where ID <> 'Version';");
                while (res.next()) {
                    String law = res.getString(1);
                    if (law == null) continue;
                    ret.add(law);
                }
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(TarmedLeistung.class).error("Error getting laws", (Throwable)e);
                connection.releaseStatement(stm);
            }
        }
        finally {
            connection.releaseStatement(stm);
        }
        return ret;
    }

    public List<TarmedLimitation> getLimitations() {
        String lim = this.loadExtension().get("limits");
        if (lim != null && !lim.isEmpty()) {
            String[] lines;
            ArrayList<TarmedLimitation> ret = new ArrayList<TarmedLimitation>();
            String[] stringArray = lines = lim.split("#");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ret.add(TarmedLimitation.of(line).setTarmedLeistung(this));
                ++n2;
            }
            this.fix9533(ret);
            return ret;
        }
        return Collections.emptyList();
    }

    private void fix9533(List<TarmedLimitation> ret) {
        boolean sessionfound = false;
        for (TarmedLimitation tarmedLimitation : ret) {
            if (tarmedLimitation.getLimitationUnit() != TarmedLimitation.LimitationUnit.SESSION) continue;
            sessionfound = true;
            break;
        }
        if (sessionfound) {
            for (TarmedLimitation tarmedLimitation : ret) {
                if (tarmedLimitation.getLimitationUnit() != TarmedLimitation.LimitationUnit.COVERAGE) continue;
                tarmedLimitation.setSkip(true);
            }
        }
    }

    public static class MandantFilter
    implements IFilter {
        MandantFilter(Mandant m) {
        }

        public boolean select(Object object) {
            return object instanceof TarmedLeistung;
        }
    }

    public static enum MandantType {
        SPECIALIST,
        PRACTITIONER;

    }

    static class TarmedComparator
    implements Comparator {
        TarmedComparator() {
        }

        public int compare(Object o1, Object o2) {
            TarmedLeistung tl1 = (TarmedLeistung)((Object)o1);
            TarmedLeistung tl2 = (TarmedLeistung)((Object)o2);
            return tl1.getCode().compareTo(tl2.getCode());
        }
    }
}

