/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedExclusion;
import ch.elexis.data.TarmedExclusive;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TarmedKumulation
extends PersistentObject {
    private static final String TABLENAME = "TARMED_KUMULATION";
    private static final String VERSION = "1.1.0";
    public static final String FLD_MASTER_CODE = "MasterCode";
    public static final String FLD_MASTER_ART = "MasterArt";
    public static final String FLD_SLAVE_CODE = "SlaveCode";
    public static final String FLD_SLAVE_ART = "SlaveArt";
    public static final String FLD_TYP = "Typ";
    public static final String FLD_VIEW = "View";
    public static final String FLD_VALID_SIDE = "ValidSide";
    public static final String FLD_VALID_FROM = "ValidFrom";
    public static final String FLD_VALID_TO = "ValidTo";
    public static final String FLD_LAW = "Law";
    private static final String VERSION_110 = "1.1.0";
    public static final String TYP_EXCLUSION = "E";
    public static final String TYP_INCLUSION = "I";
    public static final String TYP_EXCLUSIVE = "X";
    public static TimeTool timeHelper = new TimeTool();
    private static final String upd110 = "ALTER TABLE TARMED_KUMULATION ADD Law VARCHAR(3);CREATE INDEX tarmedKumulation_IDX1 on TARMED_KUMULATION (Law);INSERT INTO TARMED_KUMULATION (ID, MasterCode) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.1.0") + ")";
    public static final String createDB = "CREATE TABLE TARMED_KUMULATION (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',MasterCode\t\t\tVARCHAR(25),MasterArt \t\t\tCHAR(1),SlaveCode\t\t\tVARCHAR(25),SlaveArt \t\t\tCHAR(1),Typ\t\t\t\t\tCHAR(1),View\t\t\t\t\tCHAR(1),ValidSide\t\t\tCHAR(1),ValidFrom\t\t\tCHAR(10),ValidTo\t\t\t\tCHAR(10),Law\t\t\t\t\tVARCHAR(3));CREATE INDEX tarmedKumulation on TARMED_KUMULATION (MasterCode);CREATE INDEX tarmedKumulation_IDX1 on TARMED_KUMULATION (Law);INSERT INTO TARMED_KUMULATION (ID, MasterCode) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.1.0") + ");";

    static {
        TarmedKumulation.addMapping((String)TABLENAME, (String[])new String[]{FLD_MASTER_CODE, FLD_MASTER_ART, FLD_SLAVE_CODE, FLD_SLAVE_ART, FLD_TYP, FLD_VIEW, FLD_VALID_SIDE, FLD_VALID_FROM, FLD_VALID_TO, FLD_LAW});
        if (!TarmedKumulation.tableExists((String)TABLENAME)) {
            TarmedKumulation.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi;
            TarmedKumulation version = TarmedKumulation.load("Version");
            if (!version.exists()) {
                TarmedKumulation.createOrModifyTable((String)upd110);
                version = TarmedKumulation.load("Version");
            }
            if ((vi = new VersionInfo(version.get(FLD_MASTER_CODE))).isOlder("1.1.0")) {
                if (vi.isOlder("1.1.0")) {
                    TarmedKumulation.createOrModifyTable((String)upd110);
                }
                version.set(FLD_MASTER_CODE, "1.1.0");
            }
        }
    }

    public TarmedKumulation() {
    }

    public static TarmedKumulation load(String id) {
        return new TarmedKumulation(id);
    }

    protected TarmedKumulation(String id) {
        super(id);
    }

    public TarmedKumulation(String masterCode, String masterArt, String slaveCode, String slaveArt, String typ, String view, String validSide, String from, String to, String law) {
        this.create(null);
        String[] values = new String[]{masterCode, masterArt, slaveCode, slaveArt, typ, view, validSide, from, to, law};
        String[] fields = new String[]{FLD_MASTER_CODE, FLD_MASTER_ART, FLD_SLAVE_CODE, FLD_SLAVE_ART, FLD_TYP, FLD_VIEW, FLD_VALID_SIDE, FLD_VALID_FROM, FLD_VALID_TO, FLD_LAW};
        this.set(fields, values);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getLabel() {
        return String.valueOf(this.getMasterCode()) + ": " + this.getTyp() + " -> " + this.getSlaveCode() + " [" + this.getValidFromTime().toString(9) + " - " + this.getValidToTime().toString(9) + "]";
    }

    public static String getExclusions(String code, TimeTool date) {
        Query query = new Query(TarmedKumulation.class);
        query.add(FLD_MASTER_CODE, "=", code);
        query.add(FLD_TYP, "=", TYP_EXCLUSION);
        List exclusions = query.execute();
        if (exclusions == null || exclusions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (TarmedKumulation excl : exclusions) {
            if ("G".equals(excl.getSlaveArt()) || !excl.isValidKumulation(date)) continue;
            if (!sb.toString().isEmpty()) {
                sb.append(",");
            }
            sb.append(excl.getSlaveCode());
        }
        return sb.toString();
    }

    public static List<TarmedExclusion> getExclusions(String mastercode, TarmedKumulationType masterType, TimeTool date, String law) {
        Query query = new Query(TarmedKumulation.class);
        query.add(FLD_MASTER_CODE, "=", mastercode);
        query.add(FLD_MASTER_ART, "=", masterType.getArt());
        if (law != null && !law.isEmpty()) {
            query.add(FLD_LAW, "=", law);
        }
        query.add(FLD_TYP, "=", TYP_EXCLUSION);
        List exclusions = query.execute();
        if (exclusions == null || exclusions.isEmpty()) {
            return Collections.emptyList();
        }
        exclusions = exclusions.stream().filter(k -> k.isValidKumulation(date)).collect(Collectors.toList());
        return exclusions.stream().map(k -> new TarmedExclusion((TarmedKumulation)((Object)k))).collect(Collectors.toList());
    }

    public static List<TarmedKumulation> getKumulations(String code, TarmedKumulationType type, TimeTool date, String law) {
        List kumulations;
        Query query = new Query(TarmedKumulation.class);
        query.startGroup();
        query.add(FLD_MASTER_CODE, "=", code);
        query.add(FLD_MASTER_ART, "=", type.getArt());
        query.endGroup();
        query.or();
        query.startGroup();
        query.add(FLD_SLAVE_CODE, "=", code);
        query.add(FLD_SLAVE_ART, "=", type.getArt());
        query.endGroup();
        if (law != null && !law.isEmpty()) {
            query.add(FLD_LAW, "=", law);
        }
        if ((kumulations = query.execute()) == null || kumulations.isEmpty()) {
            return Collections.emptyList();
        }
        return kumulations.stream().filter(k -> k.isValidKumulation(date)).collect(Collectors.toList());
    }

    public static List<TarmedExclusive> getExclusives(String mastercode, TarmedKumulationType masterType, TimeTool date, String law) {
        Query query = new Query(TarmedKumulation.class);
        query.add(FLD_MASTER_CODE, "=", mastercode);
        query.add(FLD_MASTER_ART, "=", masterType.getArt());
        if (law != null && !law.isEmpty()) {
            query.add(FLD_LAW, "=", law);
        }
        query.add(FLD_TYP, "=", TYP_EXCLUSIVE);
        List exclusives = query.execute();
        if (exclusives == null || exclusives.isEmpty()) {
            return Collections.emptyList();
        }
        exclusives = exclusives.stream().filter(k -> k.isValidKumulation(date)).collect(Collectors.toList());
        return exclusives.stream().map(k -> new TarmedExclusive((TarmedKumulation)((Object)k))).collect(Collectors.toList());
    }

    public boolean isValidKumulation(TimeTool date) {
        TimeTool from = new TimeTool(this.getValidFrom());
        TimeTool to = new TimeTool(this.getValidTo());
        return date.isAfterOrEqual(from) && date.isBeforeOrEqual(to);
    }

    private TimeTool parseDate(String date) {
        if (!StringTool.isNothing((Object)date)) {
            timeHelper.set(date);
            return timeHelper;
        }
        return null;
    }

    public String getMasterCode() {
        return this.get(FLD_MASTER_CODE);
    }

    public String getSlaveCode() {
        return this.get(FLD_SLAVE_CODE);
    }

    public String getMasterArt() {
        return this.get(FLD_MASTER_ART);
    }

    public String getSlaveArt() {
        return this.get(FLD_SLAVE_ART);
    }

    public String getTyp() {
        return this.get(FLD_TYP);
    }

    public String getView() {
        return this.get(FLD_VIEW);
    }

    public String getValidSide() {
        return this.get(FLD_VALID_SIDE);
    }

    public String getValidFrom() {
        return this.get(FLD_VALID_FROM);
    }

    public TimeTool getValidFromTime() {
        return this.parseDate(this.getValidFrom());
    }

    public String getValidTo() {
        return this.get(FLD_VALID_TO);
    }

    public TimeTool getValidToTime() {
        return this.parseDate(this.getValidTo());
    }

    public void setMasterCode(String mc) {
        this.set(FLD_MASTER_CODE, mc);
    }

    public void setSlaveCode(String sc) {
        this.set(FLD_SLAVE_CODE, sc);
    }

    public void setMasterArt(String mArt) {
        this.set(FLD_MASTER_ART, mArt);
    }

    public void setSlaveArt(String sArt) {
        this.set(FLD_SLAVE_ART, sArt);
    }

    public void setTyp(String typ) {
        this.set(FLD_TYP, typ);
    }

    public void setView(String view) {
        this.set(FLD_VIEW, view);
    }

    public void setValidSide(String validSide) {
        this.set(FLD_VALID_SIDE, validSide);
    }

    public void setValidFrom(String vFrom) {
        this.set(FLD_VALID_FROM, vFrom);
    }

    public void setValidTo(String vTo) {
        this.set(FLD_VALID_TO, vTo);
    }

    public boolean isSlaveType(TarmedKumulationType type) {
        return TarmedKumulationType.ofArt(this.getSlaveArt()) == type;
    }

    public boolean isSlaveCode(String code) {
        return this.getSlaveCode().equals(code);
    }

    public boolean isMasterType(TarmedKumulationType type) {
        return TarmedKumulationType.ofArt(this.getMasterArt()) == type;
    }

    public boolean isMasterCode(String code) {
        return this.getMasterCode().equals(code);
    }

    public boolean isTyp(String typ) {
        return this.getTyp().equals(typ);
    }

    public String toString() {
        return String.valueOf(this.getMasterArt()) + " " + this.getMasterCode() + " -> " + this.getSlaveArt() + " " + this.getSlaveCode() + " [" + this.getTyp() + "]" + " (" + this.getValidFrom() + "-" + this.getValidTo() + ")";
    }

    public static enum TarmedKumulationType {
        SERVICE("L"),
        GROUP("G"),
        CHAPTER("K"),
        BLOCK("B");

        private String art;

        private TarmedKumulationType(String art) {
            this.art = art;
        }

        public String getArt() {
            return this.art;
        }

        public static TarmedKumulationType ofArt(String slaveArt) {
            if ("L".equals(slaveArt)) {
                return SERVICE;
            }
            if ("G".equals(slaveArt)) {
                return GROUP;
            }
            if ("K".equals(slaveArt)) {
                return CHAPTER;
            }
            if ("B".equals(slaveArt)) {
                return BLOCK;
            }
            return null;
        }

        public static String toString(TarmedKumulationType type) {
            if (type == SERVICE) {
                return "Leistung";
            }
            if (type == GROUP) {
                return "Gruppe";
            }
            if (type == CHAPTER) {
                return "Kapitel";
            }
            if (type == BLOCK) {
                return "Block";
            }
            return null;
        }
    }
}

