/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedExclusion;
import ch.elexis.data.TarmedExtension;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLimitation;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TarmedGroup
extends PersistentObject {
    public static final String TABLENAME = "TARMED_GROUP";
    private static final String FLD_GROUPNAME = "GroupName";
    private static final String FLD_SERVICES = "Services";
    private static final String FLD_LAW = "Law";
    private static final String FLD_VALIDFROM = "ValidFrom";
    private static final String FLD_VALIDTO = "ValidTo";
    public static final String ROW_VERSION = "Version";
    private static final String VERSION = "1.0.0";
    public static final Object SERVICES_SEPARATOR = "|";
    public static TimeTool curTimeHelper = new TimeTool();
    private TarmedExtension extension;
    public static final String createDB = "CREATE TABLE TARMED_GROUP (ID \t\t\t\t\tVARCHAR(32) primary key,lastupdate \t\t\tBIGINT,deleted \t\t\t\tCHAR(1) default '0',GroupName\t\t\tVARCHAR(32),Services\t\t\t\tTEXT,Law\t\t\t\t\tVARCHAR(3),ValidFrom\t\t\tCHAR(8),ValidTo\t\t\t\tCHAR(8));CREATE INDEX tarmedgroup_idx1 on TARMED_GROUP (GroupName);CREATE INDEX tarmedgroup_idx2 on TARMED_GROUP (Law);INSERT INTO TARMED_GROUP (id, GroupName) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        TarmedGroup.addMapping((String)TABLENAME, (String[])new String[]{FLD_GROUPNAME, FLD_SERVICES, FLD_LAW, FLD_VALIDFROM, FLD_VALIDTO});
        if (!TarmedGroup.tableExists((String)TABLENAME)) {
            TarmedGroup.createOrModifyTable((String)createDB);
        } else {
            TarmedGroup version = TarmedGroup.load(ROW_VERSION);
            VersionInfo vi = new VersionInfo(version.get(FLD_GROUPNAME));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_GROUPNAME, VERSION);
            }
        }
    }

    protected TarmedGroup() {
    }

    public static TarmedGroup load(String id) {
        return new TarmedGroup(id);
    }

    public static Optional<TarmedGroup> find(String groupName, String law, TimeTool validFrom) {
        Query query = new Query(TarmedGroup.class);
        query.add(FLD_GROUPNAME, "=", groupName);
        query.add(FLD_LAW, "=", law);
        List groups = query.execute();
        groups = groups.stream().filter(g -> g.validAt(validFrom)).collect(Collectors.toList());
        if (!groups.isEmpty()) {
            return Optional.of((TarmedGroup)((Object)groups.get(0)));
        }
        return Optional.empty();
    }

    public boolean validAt(TimeTool validTime) {
        TimeTool validFrom = new TimeTool(this.get(FLD_VALIDFROM));
        TimeTool validTo = new TimeTool(this.get(FLD_VALIDTO));
        return validTime.isAfterOrEqual(validFrom) && validTime.isBeforeOrEqual(validTo);
    }

    protected TarmedGroup(String id) {
        super(id);
    }

    public TarmedGroup(String id, String groupname, String law, String validFrom, String validTo, String services) {
        this.create(id, new String[]{FLD_GROUPNAME, FLD_LAW, FLD_VALIDFROM, FLD_VALIDTO, FLD_SERVICES}, new String[]{groupname, law, validFrom, validTo, services});
        this.extension = new TarmedExtension(this);
    }

    public String getLabel() {
        return String.valueOf(this.get("id")) + " - " + this.get(FLD_SERVICES);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public void addService(String serviceCode) {
        StringBuilder sb = new StringBuilder(this.get(FLD_SERVICES));
        if (sb.length() > 0) {
            sb.append(SERVICES_SEPARATOR);
        }
        sb.append(serviceCode);
        this.set(FLD_SERVICES, sb.toString());
    }

    public List<String> getServices() {
        String value = this.get(FLD_SERVICES);
        if (value != null && !value.isEmpty()) {
            String[] parts = value.split("\\" + SERVICES_SEPARATOR);
            return Arrays.asList(parts);
        }
        return Collections.emptyList();
    }

    public TarmedExtension getExtension() {
        if (this.extension == null) {
            this.extension = TarmedExtension.getExtension(this);
        }
        return this.extension;
    }

    public Hashtable<String, String> loadExtension() {
        if (this.getExtension() != null) {
            return (Hashtable)this.extension.getMap("limits");
        }
        return new Hashtable<String, String>();
    }

    public void setExtension(Hashtable<? extends Object, ? extends Object> map) {
        if (this.getExtension() == null) {
            throw new IllegalStateException("No Extension available for tarmed [" + this.getId() + "]");
        }
        this.extension.setMap("limits", map);
    }

    public String getCode() {
        return this.get(FLD_GROUPNAME);
    }

    public List<TarmedExclusion> getExclusions(Konsultation kons) {
        if (kons == null) {
            curTimeHelper.setTime(new Date());
        } else {
            curTimeHelper.set(kons.getDatum());
        }
        return this.getExclusions(curTimeHelper);
    }

    public List<TarmedExclusion> getExclusions(TimeTool date) {
        return TarmedKumulation.getExclusions(this.getCode(), TarmedKumulation.TarmedKumulationType.GROUP, date, this.get(FLD_LAW));
    }

    public List<TarmedLimitation> getLimitations() {
        String lim = this.loadExtension().get("limits");
        if (lim != null && !lim.isEmpty()) {
            String[] lines;
            ArrayList<TarmedLimitation> ret = new ArrayList<TarmedLimitation>();
            String[] stringArray = lines = lim.split("#");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ret.add(TarmedLimitation.of(line).setTarmedGroup(this));
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }
}

