/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class TarmedExtension
extends PersistentObject {
    private static final String TABLENAME = "TARMED_EXTENSION";
    private static final String VERSION = "1.0.0";
    public static final String FLD_CODE = "Code";
    public static final String FLD_LIMITS = "limits";
    public static final String FLD_MED_INTERPRET = "med_interpret";
    public static final String FLD_TECH_INTERPRET = "tech_interpret";
    private static final String upd100_h2 = "ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD lastupdate BIGINT;ALTER TABLE TARMED_EXTENSION ADD deleted CHAR(1) default '0';UPDATE TARMED_EXTENSION SET id=(SELECT LPAD(random_uuid(), 25));ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD PRIMARY KEY (id);ALTER TABLE TARMED_EXTENSION MODIFY Code VARCHAR(32);INSERT INTO TARMED_EXTENSION (ID, Code) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.0.0") + ");";
    private static final String upd100_mysql = "ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD lastupdate BIGINT;ALTER TABLE TARMED_EXTENSION ADD deleted CHAR(1) default '0';UPDATE TARMED_EXTENSION SET id=(SELECT LEFT(UUID(), 25));ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD PRIMARY KEY (id);ALTER TABLE TARMED_EXTENSION MODIFY Code VARCHAR(32);INSERT INTO TARMED_EXTENSION (ID, Code) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.0.0") + ");";
    private static final String upd100_postgresql = "ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD lastupdate BIGINT;ALTER TABLE TARMED_EXTENSION ADD deleted CHAR(1) default '0';UPDATE TARMED_EXTENSION SET id=(SELECT lpad(random()::text, 25));ALTER TABLE TARMED_EXTENSION ADD id VARCHAR(25);ALTER TABLE TARMED_EXTENSION ADD PRIMARY KEY (id);ALTER TABLE TARMED_EXTENSION MODIFY Code VARCHAR(32);INSERT INTO TARMED_EXTENSION (ID, Code) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.0.0") + ");";
    public static final String createDB = "CREATE TABLE TARMED_EXTENSION (ID \t\t\t\t\tVARCHAR(25) primary key, lastupdate \t\t\tBIGINT,deleted \t\t\t\tCHAR(1) default '0',Code\t\t\t\t\tVARCHAR(32),limits\t \t\t\tBLOB,med_interpret\t\tTEXT,tech_interpret \t\tTEXT);CREATE INDEX tarmed4 on TARMED_EXTENSION (Code);INSERT INTO TARMED_EXTENSION (ID, Code) VALUES (" + JdbcLink.wrap((String)"Version") + ", " + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        TarmedExtension.addMapping((String)TABLENAME, (String[])new String[]{FLD_CODE, FLD_LIMITS, FLD_MED_INTERPRET, FLD_TECH_INTERPRET});
        if (!TarmedExtension.tableExists((String)TABLENAME)) {
            TarmedExtension.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi;
            TarmedExtension version = TarmedExtension.load("Version");
            if (!version.exists()) {
                String dbFlavor = TarmedExtension.getDefaultConnection().getDBFlavor();
                if ("h2".equals(dbFlavor)) {
                    TarmedExtension.createOrModifyTable((String)upd100_h2);
                } else if ("mysql".equals(dbFlavor)) {
                    TarmedExtension.createOrModifyTable((String)upd100_mysql);
                } else if ("postgresql".equals(dbFlavor)) {
                    TarmedExtension.createOrModifyTable((String)upd100_postgresql);
                }
            }
            if ((vi = new VersionInfo(version.get(FLD_CODE))).isOlder(VERSION)) {
                version.set(FLD_CODE, VERSION);
            }
        }
    }

    protected TarmedExtension() {
    }

    public TarmedExtension(TarmedLeistung tarmedLeistung) {
        this.create(null, new String[]{FLD_CODE}, new String[]{tarmedLeistung.getId()});
    }

    public TarmedExtension(TarmedGroup tarmedGruppe) {
        this.create(null, new String[]{FLD_CODE}, new String[]{tarmedGruppe.getId()});
    }

    public static TarmedExtension load(String id) {
        return new TarmedExtension(id);
    }

    protected TarmedExtension(String id) {
        super(id);
    }

    public static TarmedExtension getExtension(TarmedLeistung tarmedLeistung) {
        Query query = new Query(TarmedExtension.class);
        query.add(FLD_CODE, "=", tarmedLeistung.getId());
        List result = query.execute();
        if (!result.isEmpty()) {
            return (TarmedExtension)((Object)result.get(0));
        }
        return null;
    }

    public static TarmedExtension getExtension(TarmedGroup tarmedGroup) {
        Query query = new Query(TarmedExtension.class);
        query.add(FLD_CODE, "=", tarmedGroup.getId());
        List result = query.execute();
        if (!result.isEmpty()) {
            return (TarmedExtension)((Object)result.get(0));
        }
        return null;
    }

    public String getLabel() {
        return ((Object)((Object)this)).toString();
    }

    protected String getTableName() {
        return TABLENAME;
    }
}

