/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class TarmedExclusive {
    private String slaveCode;
    private TarmedKumulation.TarmedKumulationType slaveType;

    public TarmedExclusive(TarmedKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = TarmedKumulation.TarmedKumulationType.ofArt(kumulation.getSlaveArt());
    }

    public boolean isMatching(TarmedLeistung tarmedLeistung, TimeTool date) {
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.SERVICE) {
            return this.slaveCode.equals(tarmedLeistung.getCode());
        }
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date);
            return groups.contains(this.slaveCode);
        }
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.BLOCK) {
            List<String> blocks = tarmedLeistung.getServiceBlocks(date);
            return blocks.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingChapter(TarmedLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        String parentId = tarmedLeistung.getParent();
        if (parentId != null && !parentId.equals("NIL")) {
            return this.isMatchingChapter(TarmedLeistung.load(parentId));
        }
        return false;
    }

    public boolean isMatching(TarmedGroup tarmedGroup) {
        if (this.slaveType != TarmedKumulation.TarmedKumulationType.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TarmedKumulation.TarmedKumulationType.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }

    public TarmedKumulation.TarmedKumulationType getSlaveType() {
        return this.slaveType;
    }
}

