/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.TarmedGroup;
import ch.elexis.data.TarmedKumulation;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class TarmedExclusion {
    private String slaveCode;
    private TarmedKumulation.TarmedKumulationType slaveType;
    private boolean validSide;

    public TarmedExclusion(TarmedKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = TarmedKumulation.TarmedKumulationType.ofArt(kumulation.getSlaveArt());
        this.validSide = "1".equals(kumulation.getValidSide());
    }

    public boolean isMatching(TarmedLeistung tarmedLeistung, TimeTool date) {
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.SERVICE) {
            return this.isMatchingService(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulation.TarmedKumulationType.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date);
            return groups.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingService(TarmedLeistung tarmedLeistung) {
        return this.slaveCode.equals(tarmedLeistung.getCode());
    }

    private boolean isMatchingChapter(TarmedLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        String parentId = tarmedLeistung.getParent();
        if (parentId != null && !parentId.equals("NIL")) {
            return this.isMatchingChapter(TarmedLeistung.load(parentId));
        }
        return false;
    }

    public boolean isMatching(TarmedGroup tarmedGroup) {
        if (this.slaveType != TarmedKumulation.TarmedKumulationType.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public boolean isValidSide() {
        return this.validSide;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TarmedKumulation.TarmedKumulationType.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }
}

