/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;

public class RFE
extends PersistentObject {
    public static final String Version = "0.1.0";
    private static final String TABLENAME = "ch_elexis_arzttarif_ch_rfe";
    private static final String createDB = "CREATE TABLE ch_elexis_arzttarif_ch_rfe (ID VARCHAR(25) primary key,deleted CHAR(1) default '0',lastupdate bigint,type CHAR(2),konsID VARCHAR(25));CREATE INDEX ch_elexis_arzttarif_ch_rfe_idx ON ch_elexis_arzttarif_ch_rfe (konsID);INSERT INTO ch_elexis_arzttarif_ch_rfe (ID, konsID) VALUES ('VERSION','0.1.0');";
    static final String[][] rfe = new String[][]{{"01", "01- Kontakt auf Wunsch des Patienten", "01-Wunsch"}, {"02", "02- Notfallkonsultation (vor 1.6.2012)", "02-NF"}, {"03", "03- Kontakt auf Zuweisung", "03-Zuweis."}, {"04", "04- Folgekontakt auf Verordnung/Empfehlung", "04-Verord."}, {"05", "05- Folgekontakt wegen ausw\u00e4rtiger H\u00e4matologie und Chemie", "05-Labor"}, {"06", "06- Kontakt in Zusammenhang mit Langzeitpflege", "06-Langz."}, {"07", "07- Kontakt in kausalem Zusammenhang mit Eingriff / Hospitalisation", "07-Spital"}, {"99", "99- Kein Arztkontakt", "99-"}};
    static HashMap<String, String> rfeHash;

    static {
        RFE.addMapping((String)TABLENAME, (String[])new String[]{"type", "konsID"});
        RFE version = RFE.load("VERSION");
        if (!version.exists()) {
            RFE.createOrModifyTable((String)createDB);
        }
        rfeHash = new HashMap();
        String[][] stringArray = rfe;
        int n = rfe.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            rfeHash.put(line[0], line[1]);
            ++n2;
        }
    }

    public RFE(String KonsId, String code) {
        this.create(null);
        this.set(new String[]{"konsID", "type"}, new String[]{KonsId, code});
    }

    public static HashMap<String, String> getRFEDef() {
        return rfeHash;
    }

    public static String[] getRFETexts() {
        String[] ret = new String[rfe.length];
        int i = 0;
        while (i < rfe.length) {
            ret[i] = rfe[i][1];
            ++i;
        }
        return ret;
    }

    public static String[][] getRFEDescriptions() {
        return rfe;
    }

    public static void clear(Konsultation k) {
        RFE.getConnection().exec("DELETE FROM ch_elexis_arzttarif_ch_rfe WHERE KonsID=" + k.getWrappedId());
    }

    public String getText() {
        String code = this.getCode();
        return rfeHash.get(code);
    }

    public static List<RFE> getRfeForKons(String konsID) {
        Query qbe = new Query(RFE.class);
        qbe.add("konsID", "=", konsID);
        return qbe.execute();
    }

    public String getCode() {
        return RFE.checkNull((Object)this.get("type"));
    }

    public Konsultation getKons() {
        return Konsultation.load((String)this.get("konsID"));
    }

    public String getLabel() {
        return String.valueOf(this.getKons().getLabel()) + " : " + this.getText();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static RFE load(String id) {
        return new RFE(id);
    }

    protected RFE(String id) {
        super(id);
    }

    protected RFE() {
    }
}

