/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.ui.optifier.NoObligationOptifier;
import ch.elexis.data.Query;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class PhysioLeistung
extends VerrechenbarAdapter {
    public static final String FLD_BIS = "bis";
    public static final String FLD_VON = "von";
    public static final String FLD_TP = "TP";
    private static final String VALUE_VERSION = "VERSION";
    public static final String FLD_TITEL = "Titel";
    public static final String FLD_ZIFFER = "Ziffer";
    public static final String FLD_TEXT = "text";
    public static final String VERSION = "0.0.1";
    private static final String TABLENAME = "CH_ELEXIS_ARZTTARIFE_CH_PHYSIO";
    private static final String XIDDOMAIN = "www.xid.ch/id/physiotarif";
    public static final String CODESYSTEMNAME = "Physiotherapie";
    public static final String FIXEDPRICE = "\n[FIXPRICE]";
    private static IOptifier noObligationOptifier = new NoObligationOptifier();
    private static final String createDB = "CREATE TABLE CH_ELEXIS_ARZTTARIFE_CH_PHYSIO (ID\t\t\tVARCHAR(25) primary key,lastupdate BIGINT,deleted  CHAR(1) default '0',validFrom\tCHAR(8),validUntil CHAR(8),TP CHAR(8),ziffer\t\tVARCHAR(6),titel\t\tVARCHAR(255),description TEXT);CREATE INDEX cheacp on CH_ELEXIS_ARZTTARIFE_CH_PHYSIO (ziffer);";

    static {
        PhysioLeistung.addMapping((String)TABLENAME, (String[])new String[]{"von=S:D:validFrom", "bis=S:D:validUntil", FLD_ZIFFER, FLD_TITEL, "text=description", FLD_TP});
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)"Physiotarif", (int)1);
        PhysioLeistung pv = PhysioLeistung.load(VALUE_VERSION);
        if (!pv.exists()) {
            PhysioLeistung.createOrModifyTable((String)createDB);
            pv.create(VALUE_VERSION);
            pv.set(FLD_ZIFFER, VERSION);
        }
    }

    public PhysioLeistung(String code, String text, String tp, TimeTool validFrom, TimeTool validTo) {
        this.create(null);
        this.set(new String[]{FLD_ZIFFER, FLD_TITEL, FLD_TP, FLD_VON, FLD_BIS}, new String[]{code, text, tp, validFrom != null ? validFrom.toString(9) : "19700101", validTo != null ? validTo.toString(9) : "20380118"});
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String[] getDisplayedFields() {
        return new String[]{FLD_ZIFFER, FLD_TITEL};
    }

    public double getFactor(TimeTool date, IFall fall) {
        String text = this.get(FLD_TEXT);
        if (text != null && text.endsWith(FIXEDPRICE)) {
            return 1.0;
        }
        return this.getVKMultiplikator(date, fall);
    }

    public int getTP(TimeTool date, IFall fall) {
        return PhysioLeistung.checkZero((Object)this.get(FLD_TP));
    }

    public static PhysioLeistung load(String id) {
        return new PhysioLeistung(id);
    }

    protected PhysioLeistung(String id) {
        super(id);
    }

    protected PhysioLeistung() {
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public String getCodeSystemCode() {
        return "311";
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_ZIFFER, FLD_TITEL});
        return vals[0] + " " + vals[1];
    }

    public String getText() {
        return this.get(FLD_TITEL);
    }

    public String getCode() {
        return this.get(FLD_ZIFFER);
    }

    public String getCodeSystemName() {
        return CODESYSTEMNAME;
    }

    public boolean isDragOK() {
        return true;
    }

    public IOptifier getOptifier() {
        return noObligationOptifier;
    }

    public List<Object> getActions(Object context) {
        return null;
    }

    public int getCacheTime() {
        return 300;
    }

    public static PhysioLeistung getFromCode(String code) {
        Query query = new Query(PhysioLeistung.class);
        String found = query.findSingle(FLD_ZIFFER, "=", code);
        if (found != null && !found.isEmpty()) {
            return PhysioLeistung.load(found);
        }
        return null;
    }
}

