/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PhysioLeistung;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PhysioImporter
extends ImporterPage {
    private TimeTool validFrom = new TimeTool();
    private TimeTool endOfEpoch = new TimeTool("20380118");

    public PhysioImporter() {
        this.validFrom.clear();
        this.validFrom.set(TimeTool.getInstance().get(1), 0, 1);
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fis = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fis.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite validDateComposite = new Composite((Composite)fis, 0);
        validDateComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        validDateComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(validDateComposite, 0);
        lbl.setText("Tarif ist g\u00fcltig ab:");
        final DateTime validDate = new DateTime(validDateComposite, 65572);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(20, 5);
        validDate.setLayoutData((Object)fd);
        validDate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            private void setValidFromDate() {
                PhysioImporter.this.validFrom.set(validDate.getYear(), validDate.getMonth(), validDate.getDay());
            }
        });
        validDate.setDate(this.validFrom.get(1), this.validFrom.get(2), this.validFrom.get(5));
        return fis;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        CSVReader reader = new CSVReader((Reader)new FileReader(this.results[0]), ';');
        monitor.beginTask("Importiere Physio", 100);
        String[] line = reader.readNext();
        while ((line = reader.readNext()) != null) {
            if (line.length < 3) continue;
            monitor.subTask(line[1]);
            this.updateOrCreateFromLine(line);
        }
        this.closeAllOlder();
        monitor.done();
        return Status.OK_STATUS;
    }

    private void closeAllOlder() {
        TimeTool defaultValidFrom = new TimeTool();
        defaultValidFrom.set(1970, 0, 1);
        Query qEntries = new Query(PhysioLeistung.class);
        List entries = qEntries.execute();
        for (PhysioLeistung physio : entries) {
            String sVon = physio.get("von");
            TimeTool tVon = new TimeTool(sVon);
            String sBis = physio.get("bis");
            if (sVon == null || sVon.trim().length() == 0) {
                physio.set("von", defaultValidFrom.toString(9));
                physio.set("bis", this.validFrom.toString(9));
                continue;
            }
            if (this.validFrom.equals((Object)tVon)) continue;
            if (sBis == null || sBis.trim().length() == 0) {
                physio.set("bis", this.validFrom.toString(9));
                continue;
            }
            TimeTool tBis = new TimeTool(sBis);
            if (!tBis.isEqual(this.endOfEpoch)) continue;
            physio.set("bis", this.validFrom.toString(9));
        }
    }

    private void updateOrCreateFromLine(String[] line) {
        Query qEntries = new Query(PhysioLeistung.class);
        qEntries.add("Ziffer", "=", line[0]);
        List entries = qEntries.execute();
        ArrayList<PhysioLeistung> openEntries = new ArrayList<PhysioLeistung>();
        for (PhysioLeistung physio : entries) {
            String sBis = physio.get("bis");
            if (sBis == null || sBis.trim().length() == 0) {
                openEntries.add(physio);
                continue;
            }
            TimeTool tBis = new TimeTool(sBis);
            if (!tBis.isEqual(this.endOfEpoch)) continue;
            openEntries.add(physio);
        }
        if (openEntries.isEmpty()) {
            PhysioLeistung physio;
            physio = new PhysioLeistung(line[0], line[1], line[2], this.validFrom, null);
            if (this.lineHasFixPrice(line)) {
                this.applyFixPrice(physio, line[3]);
            }
        } else {
            for (PhysioLeistung physio : openEntries) {
                if (physio.get("von").equals(this.validFrom.toString(9))) {
                    physio.set(new String[]{"Titel", "TP"}, new String[]{line[1], line[2]});
                    if (!this.lineHasFixPrice(line)) continue;
                    this.applyFixPrice(physio, line[3]);
                    continue;
                }
                physio.set("bis", this.validFrom.toString(9));
                PhysioLeistung newPhysio = new PhysioLeistung(line[0], line[1], line[2], this.validFrom, null);
                if (!this.lineHasFixPrice(line)) continue;
                this.applyFixPrice(newPhysio, line[3]);
            }
        }
    }

    private void applyFixPrice(PhysioLeistung physio, String string) {
        physio.set("TP", string);
        StringBuilder sb = new StringBuilder();
        String existingText = physio.get("text");
        if (existingText != null) {
            sb.append(existingText);
        }
        sb.append("\n[FIXPRICE]");
        physio.set("text", sb.toString());
    }

    private boolean lineHasFixPrice(String[] line) {
        return line.length > 3 && line[3] != null && !line[3].isEmpty() && Character.isDigit(line[3].charAt(0));
    }

    public String getDescription() {
        return "Physiotherapie-Tarif";
    }

    public String getTitle() {
        return "Physio";
    }
}

