/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Map;

public class LaborLeistung
extends VerrechenbarAdapter {
    public static final String FLD_NAME = "Name";
    public static final String FLD_CODE = "Code";
    public static final String FLD_TEXT = "Text";
    private static final String TABLENAME = "ARTIKEL";
    public static final String XIDDOMAIN = "www.xid.ch/id/analysenliste_ch/";

    static {
        LaborLeistung.addMapping((String)TABLENAME, (String[])new String[]{FLD_NAME, "Text=Name", "EK_Preis", "VK_Preis", "Typ", "Code=SubID", "ExtInfo"});
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)"Laborleistung", (int)1);
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public static void createTable() {
        LaborLeistung.getConnection().exec("DELETE FROM ARTIKEL WHERE TYP='Laborleistung'");
    }

    LaborLeistung(String code, String text, String tp_vk) {
        this.create(null);
        if (text.length() > 78) {
            Map ex = this.getMap("ExtInfo");
            ex.put("FullText", text);
            text = text.substring(0, 75);
            this.setMap("ExtInfo", ex);
        }
        this.set(new String[]{FLD_CODE, FLD_TEXT, "VK_Preis"}, new String[]{code, text.trim(), tp_vk});
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCode() {
        return this.get(FLD_CODE);
    }

    public String getText() {
        return LaborLeistung.checkNull((Object)this.get(FLD_TEXT));
    }

    public String getCodeSystemName() {
        return "Laborleistung";
    }

    public Money getKosten(TimeTool dat) {
        String r = this.get("EK_Preis");
        return StringTool.isNothing((Object)r) ? new Money(0) : new Money((int)Math.round(Double.parseDouble(r) * this.getEKMultiplikator(dat, null) * 100.0));
    }

    public static LaborLeistung load(String id) {
        return new LaborLeistung(id);
    }

    public LaborLeistung() {
    }

    protected LaborLeistung(String id) {
        super(id);
    }

    protected String getConstraint() {
        return "Typ='Laborleistung'";
    }

    protected void setConstraint() {
        this.set("Typ", "Laborleistung");
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_CODE, FLD_TEXT});
        return String.valueOf(vals[0]) + " " + vals[1];
    }

    public boolean isDragOK() {
        return true;
    }

    public int getTP(TimeTool date, IFall fall) {
        return LaborLeistung.checkZero((Object)this.get("VK_Preis")) * 100;
    }

    public double getFactor(TimeTool date, IFall fall) {
        double ret = this.getVKMultiplikator(date, "EAL");
        if (ret == 1.0 && (ret = this.getVKMultiplikator(date, "ch.elexis.data.LaborLeistung")) != 1.0) {
            PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='EAL' WHERE typ='ch.elexis.data.LaborLeistung'");
        }
        return ret;
    }

    public List<Object> getActions(Object context) {
        return null;
    }
}

