/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class ComplementaryLeistung
extends VerrechenbarAdapter {
    public static final String FLD_CHAPTER = "chapter";
    public static final String FLD_CODE = "code";
    public static final String FLD_CODE_TEXT = "codetext";
    public static final String FLD_DESCRIPTION = "description";
    public static final String FLD_FIXEDVALUE = "fixedvalue";
    public static final String FLD_VALID_FROM = "validfrom";
    public static final String FLD_VALID_TO = "validto";
    public static final String VERSION = "0.0.2";
    public static final String TABLENAME = "CH_ELEXIS_ARZTTARIFE_CH_COMPLEMENTARY";
    public static final String XIDDOMAIN = "www.xid.ch/id/complementary";
    private static final String CODESYSTEMCODE = "590";
    public static final String CODESYSTEMNAME = "Komplement\u00e4rmedizin";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_ARZTTARIFE_CH_COMPLEMENTARY (ID VARCHAR(25) primary key,lastupdate BIGINT,deleted CHAR(1) default '0',chapter VARCHAR(255),code VARCHAR(16),codetext VARCHAR(255),description TEXT,fixedvalue VARCHAR(16),validfrom CHAR(8),validto CHAR(8));CREATE INDEX complementaryindex on CH_ELEXIS_ARZTTARIFE_CH_COMPLEMENTARY (code);";
    private static IOptifier OPTIFIER;

    static {
        VersionInfo vi;
        ComplementaryLeistung.addMapping((String)TABLENAME, (String[])new String[]{FLD_CHAPTER, FLD_CODE, FLD_CODE_TEXT, FLD_DESCRIPTION, FLD_FIXEDVALUE, FLD_VALID_FROM, FLD_VALID_TO});
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)"complementary", (int)1);
        ComplementaryLeistung version = ComplementaryLeistung.load("VERSION");
        if (!version.exists()) {
            ComplementaryLeistung.createOrModifyTable((String)createDB);
            version.create("VERSION");
            version.set(FLD_CODE, VERSION);
        }
        if ((vi = new VersionInfo(version.get(FLD_CODE))).isOlder(VERSION)) {
            ComplementaryLeistung.updateFixedValues();
            version.set(FLD_CODE, VERSION);
        }
    }

    protected ComplementaryLeistung() {
    }

    private static void updateFixedValues() {
        Query query = new Query(ComplementaryLeistung.class);
        query.clear(true);
        query.add("id", "<>", "VERSION");
        List all = query.execute();
        for (ComplementaryLeistung complementaryLeistung : all) {
            if (!complementaryLeistung.isFixedValueSet()) continue;
            int value = complementaryLeistung.getFixedValue();
            complementaryLeistung.setFixedValue(value * 100);
        }
    }

    protected ComplementaryLeistung(String id) {
        super(id);
    }

    public ComplementaryLeistung(String id, String chapter, String code, String codeText, String description, String validFromString, String validToString) {
        this.create(id);
        this.set(new String[]{FLD_CHAPTER, FLD_CODE, FLD_CODE_TEXT, FLD_DESCRIPTION, FLD_VALID_FROM, FLD_VALID_TO}, new String[]{chapter, code, codeText, description, validFromString, validToString});
    }

    public static ComplementaryLeistung load(String id) {
        return new ComplementaryLeistung(id);
    }

    public int getTP(TimeTool date, IFall fall) {
        if (this.isFixedValueSet()) {
            return this.getFixedValue();
        }
        return this.getHourlyWage() / 12;
    }

    public int getHourlyWage() {
        String wageString = CoreHub.mandantCfg.get("arzttarife/complementary/hourlywage", "0");
        return Integer.valueOf(wageString);
    }

    public int getFixedValue() {
        try {
            return Integer.valueOf(this.get(FLD_FIXEDVALUE));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setFixedValue(int value) {
        if (value < 0) {
            this.set(FLD_FIXEDVALUE, "");
        } else {
            this.set(FLD_FIXEDVALUE, Integer.toString(value));
        }
    }

    public boolean isFixedValueSet() {
        String fixedValue = this.get(FLD_FIXEDVALUE);
        return fixedValue != null && !fixedValue.isEmpty();
    }

    public boolean isDragOK() {
        return true;
    }

    public double getFactor(TimeTool date, IFall fall) {
        return 1.0;
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public List<Object> getActions(Object context) {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCodeSystemCode() {
        return CODESYSTEMCODE;
    }

    public String getCodeSystemName() {
        return CODESYSTEMNAME;
    }

    public String getCode() {
        return this.get(FLD_CODE);
    }

    public String getText() {
        return this.get(FLD_CODE_TEXT);
    }

    public String getLabel() {
        return "(" + this.getCode() + ") " + this.getText();
    }

    private TimeTool getValidTo() {
        String value = this.get(FLD_VALID_TO);
        if (!StringTool.isNothing((Object)value)) {
            TimeTool res = new TimeTool(value);
            res.set(11, 23);
            res.set(12, 59);
            res.set(13, 59);
            return res;
        }
        return null;
    }

    private TimeTool getValidFrom() {
        String value = this.get(FLD_VALID_FROM);
        if (!StringTool.isNothing((Object)value)) {
            return new TimeTool(value);
        }
        return null;
    }

    public synchronized IOptifier getOptifier() {
        if (OPTIFIER == null) {
            OPTIFIER = new IVerrechenbar.DefaultOptifier(){

                public Result<IVerrechenbar> add(IVerrechenbar code, Konsultation kons) {
                    boolean valid = true;
                    if (CoreHub.mandantCfg.get("arzttarife/complementary/fixtovvg", false)) {
                        String gesetz = kons.getFall().getConfiguredBillingSystemLaw().name();
                        String system = kons.getFall().getAbrechnungsSystem();
                        if (gesetz.isEmpty()) {
                            if (!"vvg".equalsIgnoreCase(system)) {
                                valid = false;
                            }
                        } else if (!"vvg".equalsIgnoreCase(gesetz)) {
                            valid = false;
                        }
                    }
                    return valid ? super.add(code, kons) : new Result(Result.SEVERITY.WARNING, 0, "Komplement\u00e4rmedizinische Leistungen k\u00f6nnen nur auf eine Fall mit Gesetz oder Name VVG verrechnet werden.", null, false);
                }
            };
        }
        return OPTIFIER;
    }

    public static IVerrechenbar getFromCode(String code, TimeTool date) {
        Query query = new Query(ComplementaryLeistung.class, FLD_CODE, code, TABLENAME, new String[]{FLD_VALID_FROM, FLD_VALID_TO});
        List leistungen = query.execute();
        for (ComplementaryLeistung leistung : leistungen) {
            TimeTool validFrom = leistung.getValidFrom();
            TimeTool validTo = leistung.getValidTo();
            if (!date.isAfterOrEqual(validFrom) || !date.isBeforeOrEqual(validTo)) continue;
            return leistung;
        }
        return null;
    }

    public boolean isValid(TimeTool now) {
        return now.isAfter(this.getValidFrom()) && now.isBeforeOrEqual(this.getValidTo());
    }
}

