/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.ui.dbcheck;

import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.TimeTool;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTarmedInBlock
extends ExternalMaintenance {
    private static Logger logger = LoggerFactory.getLogger(UpdateTarmedInBlock.class);
    private JdbcLink pj;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        int absoluteCnt = 0;
        HashSet<String> problems = new HashSet<String>();
        TimeTool today = new TimeTool();
        this.pj = PersistentObject.getConnection();
        try {
            Query lQuery = new Query(Leistungsblock.class);
            List blocks = lQuery.execute();
            for (Leistungsblock block : blocks) {
                StringBuilder newCodes = new StringBuilder();
                byte[] compressed = this.getBinaryRaw("Leistungen", "LEISTUNGSBLOCK", block.getId());
                if (compressed == null) continue;
                String storable = new String(CompEx.expand((byte[])compressed), "UTF-8");
                String[] stringArray = storable.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (p != null && !p.isEmpty()) {
                        String[] parts = p.split("::");
                        if (parts[0].equals(TarmedLeistung.class.getName())) {
                            String code = this.getCodeFromId(parts[1]);
                            TarmedLeistung leistung = (TarmedLeistung)TarmedLeistung.getFromCode(code, today);
                            if (leistung != null) {
                                ++absoluteCnt;
                                if (newCodes.length() > 0) {
                                    newCodes.append(",");
                                }
                                newCodes.append(leistung.storeToString());
                            } else {
                                problems.add(String.valueOf(block.getName()) + " -> " + code);
                                if (newCodes.length() > 0) {
                                    newCodes.append(",");
                                }
                                newCodes.append(p);
                            }
                        } else {
                            if (newCodes.length() > 0) {
                                newCodes.append(",");
                            }
                            newCodes.append(p);
                        }
                    }
                    ++n2;
                }
                this.setBinaryRaw("Leistungen", "LEISTUNGSBLOCK", block.getId(), CompEx.Compress((String)newCodes.toString(), (int)-1610612736));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Could not update Tarmed in blocks." + e);
        }
        ArrayList problemsList = new ArrayList(problems);
        Collections.sort(problemsList);
        StringBuilder problemsString = new StringBuilder();
        for (String string : problemsList) {
            problemsString.append("- ").append(string).append("\n");
        }
        return String.valueOf(absoluteCnt) + " Tarmed Leistungen angepasst.\nIn folgenden Bl\u00f6cken sind noch fehlerhafte Leistungen\n" + problemsString.toString();
    }

    private String getCodeFromId(String string) {
        String[] parts = string.split("-");
        if (parts.length == 2) {
            return parts[0];
        }
        return string;
    }

    public String getMaintenanceDescription() {
        return "Tarmed Leistungen in den Bl\u00f6cken auf das heutige Datum anpassen";
    }

    private byte[] getBinaryRaw(String field, String tablename, String id) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(field).append(" FROM ").append(tablename).append(" WHERE ID='").append(id).append("'");
        JdbcLink.Stm stm = null;
        try {
            stm = this.pj.getStatement();
            ResultSet res = stm.query(sql.toString());
            if (res != null && res.next()) {
                byte[] byArray = res.getBytes(field);
                return byArray;
            }
        }
        catch (Exception ex) {
            logger.error("Could not update Tarmed in blocks." + ex);
        }
        finally {
            if (stm != null) {
                this.pj.releaseStatement(stm);
            }
        }
        return null;
    }

    private void setBinaryRaw(String field, String tablename, String id, byte[] value) {
        StringBuilder sql = new StringBuilder(1000);
        sql.append("UPDATE ").append(tablename).append(" SET ").append(field).append("=?").append(" WHERE ID='").append(id).append("'");
        String cmd = sql.toString();
        PreparedStatement stm = this.pj.prepareStatement(cmd);
        try {
            try {
                stm.setBytes(1, value);
                stm.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ExHandler.handle((Throwable)ex);
                try {
                    stm.close();
                }
                catch (SQLException e) {
                    logger.error("Could not update Tarmed in blocks." + e);
                    throw new PersistenceException("Could not close statement " + e.getMessage());
                }
            }
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {
                logger.error("Could not update Tarmed in blocks." + e);
                throw new PersistenceException("Could not close statement " + e.getMessage());
            }
        }
    }

    private ResultSet executeSqlQuery(String sql) {
        JdbcLink conn = null;
        JdbcLink.Stm stm = null;
        ResultSet res = null;
        try {
            try {
                conn = PersistentObject.getConnection();
                stm = conn.getStatement();
                res = stm.query(sql);
            }
            catch (JdbcLinkException je) {
                je.printStackTrace();
                ExHandler.handle((Throwable)je);
                if (stm != null && conn != null) {
                    conn.releaseStatement(stm);
                }
            }
        }
        finally {
            if (stm != null && conn != null) {
                conn.releaseStatement(stm);
            }
        }
        return res;
    }
}

